package jp.ac.do_johodai.j314.xhtml2scorm;

import java.util.Iterator;
import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;

//xpathで使用するネームスペースのプレフィックスを特定するためのクラス
//http://www-06.ibm.com/jp/developerworks/java/060906/j_x-javaxpathapi.shtml
//http://java.sun.com/javase/ja/6/docs/ja/api/javax/xml/namespace/NamespaceContext.html
class MyNamespaceContext implements NamespaceContext {
    public String getNamespaceURI(String prefix) {
        // System.out.println("prefix:'"+prefix+"'");
        if (prefix == null)
            throw new IllegalArgumentException("Null prefix");
        else if (prefix.equals(""))
            return "http://www.w3.org/1999/xhtml";
        else if (prefix.equals("h"))
            return "http://www.w3.org/1999/xhtml";
        else if (prefix.equals("a"))
            return "http://x314.do-johodai.ac.jp/ans";
        else if (prefix.equals("m"))
            return "http://www.imsglobal.org/xsd/imscp_v1p1";
        return XMLConstants.NULL_NS_URI;
    }

    public String getPrefix(String uri) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPrefixes(String uri) {
        throw new UnsupportedOperationException();
    }
}
