package jp.ac.do_johodai.j314.xhtml2scorm;

import java.io.*;
import java.net.URL;

import org.w3c.dom.*;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.*;

public class X2S {
    File currentDir;
    File[] inputFiles;
    MetaData currentDirMetaData = null;
    MetaData metaDataRoot = null;

    void init() {
        currentDir = new File(System.getProperty("user.dir"));
        File cm = new File(currentDir,"mutial_metadata.n3");
        currentDirMetaData = new MetaData(cm);
        MetaData md = currentDirMetaData;
        while (true) {
            MetaData tmpMD = md.makeParentMetaData();
            if (tmpMD==null)
                break;
            md = tmpMD;
        }
        metaDataRoot = md;
    }

    public void process(String args[]) {
        init();
        inputFiles = new File[args.length];
        for (int i=0;i<args.length;i++) {
            File tmpF = new File(args[i]);
            inputFiles[i] = tmpF.getAbsoluteFile(); 
            if (isErrFile(inputFiles[i])) {
                System.out.println("処理を中止します．");
                return;
            }
        }
        for (int i=0;i<inputFiles.length;i++) {
            InputXHTML ix = new InputXHTML(inputFiles[i]);
            ix.setParentMetaData(currentDirMetaData);
            if (!ix.isValid()) {
                System.out.println(ix.getErrMessage());
                System.out.println("処理を中止します．");
                return;
            }
            String inFileName = inputFiles[i].getName();
            String s = null;
            if(inFileName.endsWith(".xhtml")){
                s = inFileName.substring(0,inFileName.length()-6);
            } else if(inFileName.endsWith(".html")){
                s = inFileName.substring(0,inFileName.length()-5);
            }
            //String s = inFileName.substring(0,inFileName.length()-6);
            String sFileName = s+".S.xhtml";
            String mFileName = s+".S.xml";
            String aFileName = s+".A.xml";
            File scormFile = new File(sFileName);
            File metaFile = new File(mFileName);
            File ansFile = new File(aFileName);
            if (ix.writeSCORM(scormFile)) {
                System.out.println("SCORM教材を出力しました．");
                System.out.println(sFileName);
            } else {
                System.out.println("SCORM教材の出力に失敗しました．");
                System.out.println(sFileName);
                return;
            }
            if (ix.writeMetaData(metaFile)) {
                System.out.println("メタデータを出力しました．");
                System.out.println(mFileName);
            } else {
                System.out.println("メタデータの出力に失敗しました．");
                System.out.println(mFileName);
                return;
            }
            if (ix.isNeededAnsData()) {
                if (ix.writeAnsData(ansFile)) {
                    System.out.println("解答データを出力しました。");
                    System.out.println(aFileName);
                } else {
                    System.out.println("解答データの出力に失敗しました。");
                    System.out.println(aFileName);
                }
            }
        }
        if (writeIMSMANIFEST()) {
            System.out.println("imsmanifest.xmlを出力しました。");
        } else {
            System.out.println("imsmanifest.xmlの出力に失敗しました。");
            return;
        }
        if (writeJavaScript()) {
            System.out.println("js/my.jsを出力しました。");
        } else {
            System.out.println("js/my.jsの出力に失敗しました。");
            return;
        }
    }

    //エラーメッセージ
    String em1 = "入力XHTMLファイルはカレントディレクトリに"
               + "存在しなければなりません。";
    String em2 = "入力XHTMLファイルがありません。";
    String em3 = "ファイル名から判断して，たぶん入力"
               + "XHTMLファイルはSCORM教材です．";
    String em4 = "入力ファイルの拡張子はxhtmlもしくはhtmlでなければ"
               + "なりません．";
    //ファイル名とか場所のエラーチェック
    boolean isErrFile(File f) {
        File d = f.getParentFile();
        if (!d.equals(currentDir)) {
            System.out.println(em1);
            System.out.println(f.toString());
            return true;
        }
        if (!f.exists()) {
            System.out.println(em2);
            System.out.println(f.toString());
            return true;
        }
        if (f.getName().endsWith(".S.xhtml")) {
            System.out.println(em3);
            System.out.println(f.toString());
            return true;
        }
        if (!f.getName().endsWith(".xhtml") && !f.getName().endsWith(".html")) {
            System.out.println(em4);
            System.out.println(f.toString());
            return true;
        }
        return false;
    }

    boolean writeIMSMANIFEST() {
        try {
            URL url = getClass().getResource("/jp/ac/do_johodai/j314/xhtml2scorm/resources/default_imsmanifest.xml");
            InputStream is = url.openStream();
            DOMImplementationRegistry dir = DOMImplementationRegistry.newInstance();
            DOMImplementationLS di = (DOMImplementationLS)dir.getDOMImplementation("LS 3.0");
            LSInput in = di.createLSInput();
            in.setByteStream(is);
            LSParser parser = di.createLSParser(DOMImplementationLS.MODE_SYNCHRONOUS, null);
            DOMConfiguration c = parser.getDomConfig();
            //c.setParameter("validate", true);
            c.setParameter("resource-resolver",new MyLSResourceResolver());
            Document d = parser.parse(in);
            is.close();

            Y.makeManifestDoc(d, currentDirMetaData);

            File f = new File(currentDir,"imsmanifest.xml");
            FileOutputStream fos = new FileOutputStream(f);
            LSOutput out = di.createLSOutput();
            out.setByteStream(fos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(d, out);
            return true;
        }catch(Exception e){
            e.printStackTrace();
            return false;
        }
    }
    boolean writeJavaScript() {
        try {
            URL url = getClass().getResource("/jp/ac/do_johodai/j314/xhtml2scorm/resources/my.js");
            InputStream is = url.openStream();
            File f = new File(currentDir,"js");
            f.mkdir();
            File ff = new File(f,"my.js");
            FileOutputStream fos = new FileOutputStream(ff);
            //以下、かなり糞なコード。
            int c;
            while ((c=is.read())!=-1) {
                fos.write(c);
            }
            is.close();
            fos.close();

            url = getClass().getResource("/jp/ac/do_johodai/j314/xhtml2scorm/resources/prototype.js");
            is = url.openStream();
            ff = new File(f,"prototype.js");
            fos = new FileOutputStream(ff);
            //以下、かなり糞なコード。
            while ((c=is.read())!=-1) {
                fos.write(c);
            }
            is.close();
            fos.close();

            return true;
        } catch(Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
