package jp.ac.do_johodai.j314.xhtml2scorm;

import java.util.ArrayList;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.*;

public class Y {
    static Document doc;
    static String fin = "false";
    static int[] qnum;
    static String[] AllfileName;

    /*
    static Node[] xpath(String xpath,Document d) {
        XPathEvaluator evaluator=new XPathEvaluatorImpl(d);
        XPathNSResolver xpathNSResolver=evaluator.createNSResolver(d);
        XPathResult nodeSet=(XPathResult)evaluator.evaluate(xpath,d,xpathNSResolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
        ArrayList<Node> al = new ArrayList<Node>();
        Node n = nodeSet.iterateNext();
        while (n!=null) {
            al.add(n);
            n = nodeSet.iterateNext(); 
        }
        return al.toArray(new Node[0]);
    }*/
    static Node[] xpath(String query, Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList) expr.evaluate(doc, XPathConstants.NODESET);
            Node ret[] = new Node[nl.getLength()];
            for (int i = 0; i < nl.getLength(); i++) {
                ret[i] = nl.item(i);
            }
            return ret;
        } catch (XPathExpressionException e) {
            return null;
        }
    }

    public static void convert(Document d, InputXHTML iXHTML) {
        doc = d;

        // javascriptの追加
        Node head[] = xpath("//*[local-name()='head']/text()", doc);
        Node head0 = head[0].getParentNode();
        Element script1 = (Element) doc.createElement("script");
        script1.setAttribute("type", "text/javascript");
        script1.setAttribute("src", "./js/my.js");
        script1.setAttribute("charset", "utf-8");
        head0.appendChild(script1);
        Element script2 = (Element) doc.createElement("script");
        script2.setAttribute("type", "text/javascript");
        script2.setAttribute("src", "./js/prototype.js");
        script2.setAttribute("charset", "utf-8");
        head0.appendChild(script2);

        // bodyの書き換え
        Node body[] = xpath("//*[local-name()='body']", doc);
        Element body0 = (Element) body[0];
        body0.setAttribute("onload", "MyInit();");
        body0.setAttribute("onubload", "MyFin();");
        // body0.setAttribute("qid", String.valueOf(title[0].getNodeValue()));

        // rdfタグの削除
        body0.removeChild(body0.getChildNodes().item(1));

        // 解答データの格納
        Node AllAns[] = xpath(
                "//*[local-name()='li']/text()[normalize-space()]", doc);
        iXHTML.ansData.allAns = AllAns;
        Node n[] = xpath("/:html/:body/:ul[@class]", doc);
        iXHTML.ansData.qcount = n.length;
        qnum = new int[n.length];
        // Node title[] = xpath("//*[local-name()='title']/text()",doc);

        // String xp = "/:html/:body/:ul[@id='" + typeId + "']";

        String typeId = null;
        for (int i = 0; i < n.length; i++) {
            typeId = n[i].getAttributes().item(0).getNodeValue();
            int qcount = 0;
            String[] qtype = new String[6];
            qtype[0] = "";
            qtype[1] = "single";
            qtype[2] = "multiple";
            qtype[3] = "fill_in";
            qtype[4] = "pulldown";
            qtype[5] = "upload";
            for (int j = 0; j < 6; j++) {
                if (qtype[j].equals(typeId)) {
                    qcount = j;

                    break;
                }
            }
            // 問題作成ならconvertSentakuへ
            if (qcount > 0 && qcount != 5) {
                if (n.length - 1 == i) {
                    fin = "true";
                }
                convertSentaku((Element) n[i], typeId, doc, qcount, i, iXHTML);
            } else if (qcount == 5) {
                body0.setAttribute("onload", "MyInit();upfile();");
            }
        }
    }

    static void convertSentaku(Element e, String typeId, Document doc,
            int qcount, int idcount, InputXHTML iXHTML) {
        Node p = e.getParentNode();
        iXHTML.ansData.csCheck = "true";
        int count = 1;
        idcount = idcount + 1;
        // formの作成
        Element ee = (Element) doc.createElement("form");

        // Node title[] = xpath("//*[local-name()='title']/text()",doc);
        String questionId = "question" + idcount;
        ee.setAttribute("id", questionId);
        // ee.setAttribute("action",
        // String.valueOf("javascript:sentakuSaiten()"));

        // 解答と選択肢のテキストの取得
        // String questionA = "/:html/:body/:ul[@id='" + questionId +
        // "']/:li/:ul/:li/text()";
        String questionV = "/:html/:body/:ul[@id='" + questionId
                + "']/:li/text()[normalize-space()]";
        Node ans[] = xpath(questionV, doc);// 解答
        // Node tf[] = xpath(questionA,doc);//選択肢テキスト
        qnum[idcount - 1] = ans.length;
        // for(int i=0;i<ans.length;i++){
        //     System.out.println(ans[i].getTextContent());
        //     System.out.println(tf[i].getTextContent());
        // }
        // AnsData.questionId = questionId;
        // AnsData.tfNode = tf;
        // AnsData.ansNode = ans;

        switch (qcount) {
        case 1:
            for (int i = 0; i < ans.length; i++) {
                if (!ans[i].getNodeValue().trim().equals("")) {
                    // qtiラベルの作成
                    Element response_label1 = (Element) doc
                            .createElement("response_label");
                    response_label1
                            .setAttribute("ident", String.valueOf(count));
                    // inputの作成
                    Element input = (Element) doc.createElement("input");
                    input.setAttribute("type", "radio");
                    input.setAttribute("name", "question");
                    input.setAttribute("value", ans[i].getNodeValue().trim());
                    // System.out.println("data="+ans[0].getNodeValue().trim());
                    response_label1.appendChild(input);
                    Element br = (Element) doc.createElement("br");
                    response_label1.appendChild(doc.createTextNode(ans[i]
                            .getNodeValue()));
                    response_label1.appendChild(br);
                    ee.appendChild(response_label1);
                    count++;
                }
            }
            count = 0;
            break;
        case 2:
            for (int i = 0; i < ans.length; i++) {
                if (!ans[i].getNodeValue().trim().equals("")) {
                    // qtiラベルの作成
                    Element response_label2 = (Element) doc
                            .createElement("response_label");
                    response_label2
                            .setAttribute("ident", String.valueOf(count));

                    // inputの作成
                    Element input = (Element) doc.createElement("input");
                    input.setAttribute("type", "checkbox");
                    input.setAttribute("name", "question");
                    input.setAttribute("value", ans[i].getNodeValue().trim());
                    response_label2.appendChild(input);

                    Element br = (Element) doc.createElement("br");
                    response_label2.appendChild(doc.createTextNode(ans[i]
                            .getNodeValue()));
                    response_label2.appendChild(br);
                    ee.appendChild(response_label2);
                    count++;
                }
            }
            count = 0;
            break;
        case 3:
            // qtiラベルの作成
            Element response_label3 = (Element) doc
                    .createElement("response_label");
            response_label3.setAttribute("ident", String.valueOf(count));

            // inputの作成
            Element input = (Element) doc.createElement("input");
            input.setAttribute("type", "text");
            input.setAttribute("name", "question");
            input.setAttribute("value", "");
            response_label3.appendChild(input);
            Element br = (Element) doc.createElement("br");
            response_label3.appendChild(br);
            ee.appendChild(response_label3);
            count = 0;
            break;
        case 4:
            Element response_label4 = (Element) doc
                    .createElement("response_label");
            response_label4.setAttribute("ident", String.valueOf(count));

            // inputの作成
            Element select = (Element) doc.createElement("select");
            select.setAttribute("id", "question");

            Element option0 = (Element) doc.createElement("option");
            option0.setAttribute("value", "");
            select.appendChild(option0);

            for (int i = 0; i < ans.length; i++) {
                if (!ans[i].getNodeValue().trim().equals("")) {
                    Element option = (Element) doc.createElement("option");
                    option.setAttribute("value", ans[i].getNodeValue().trim());
                    option.appendChild(doc
                            .createTextNode(ans[i].getNodeValue()));
                    select.appendChild(option);
                }
            }
            response_label4.appendChild(select);
            ee.appendChild(response_label4);
            count = 0;
            break;
        default:
            System.out.println("問題のタイプを入力してください");
        }
        if (fin.equals("true")) {
            Element sendinput = (Element) doc.createElement("input");
            sendinput.setAttribute("type", "button");
            sendinput.setAttribute("value", "採点");
            sendinput.setAttribute("onclick", "loadXMLFile()");
            ee.appendChild(sendinput);
            fin = "false";
        }
        // 追加
        p.replaceChild(ee, e);
    }

    static Document makeMetaDoc(Document d, MetaData md) {
        String[] generalKeywordsName = null;
        String ns = "http://ltsc.ieee.org/xsd/LOM";

        // general
        NodeList general = d.getElementsByTagNameNS(ns, "general");
        Element generalNode = (Element) general.item(0);

        // general_Title
        String generalTitleName = md.getTitle();
        Element generalTitle = d.createElementNS(ns, "title");

        Element generalTitleString = d.createElementNS(ns, "langstring");
        generalTitleString.setTextContent(generalTitleName);
        generalTitle.appendChild(generalTitleString);
        generalNode.appendChild(generalTitle);

        // general_description
        String generalDescriptionName = md.getDescription();
        Element generalDescription = d.createElementNS(ns, "description");

        Element generalDesctriptionString = d.createElementNS(ns, "langstring");
        generalDesctriptionString.setAttribute("xml:lang", "jp");
        generalDesctriptionString.setTextContent(generalDescriptionName);
        generalDescription.appendChild(generalDesctriptionString);
        generalNode.appendChild(generalDescription);

        // general_keywords
        String generalKeyword = md.getKeywords();
        if (generalKeyword != null) {
            generalKeywordsName = generalKeyword.split(",");
            for (int i = 0; i < generalKeywordsName.length; i++) {
                Element generalKeywords = d.createElementNS(ns, "keyword");
                Element generalKeywordsString = d.createElementNS(ns,
                        "langstring");
                generalKeywordsString.setAttribute("xml:lang", "jp");
                generalKeywordsString.setTextContent(generalKeywordsName[i]);
                generalKeywords.appendChild(generalKeywordsString);
                generalNode.appendChild(generalKeywords);
            }
        }

        // lifecycle
        NodeList lifecycle = d.getElementsByTagNameNS(ns, "lifecycle");
        Element lifecycleNode = (Element) lifecycle.item(0);

        // lifecycle_contribute_Author
        String lifecyclecontributeAuthor = md.getAuthor();
        Element contribute = d.createElementNS(ns, "contribute");

        Element contributeValue = d.createElementNS(ns, "value");
        contribute.appendChild(contributeValue);

        Element lifecycleContributeString = d.createElementNS(ns, "langstring");
        lifecycleContributeString.setAttribute("xml:lang", "jp");
        lifecycleContributeString.setTextContent(lifecyclecontributeAuthor);
        contributeValue.appendChild(lifecycleContributeString);
        
        Element roleNode = d.createElementNS(ns, "role");
        contribute.appendChild(roleNode);
        
        Element roleVocabularyNode = d.createElementNS(ns, "vocabulary");
        roleNode.appendChild(roleVocabularyNode);
        
        Element vocabularySource = d.createElementNS(ns, "source");
        roleVocabularyNode.appendChild(vocabularySource);
        
        Element sourceStringNode = d.createElementNS(ns, "langstring");
        sourceStringNode.setAttribute("xml:lang", "jp");
        sourceStringNode.setTextContent("LOMv1.0");
        vocabularySource.appendChild(sourceStringNode);
        
        Element sourceValueNode = d.createElementNS(ns, "value");
        roleVocabularyNode.appendChild(sourceValueNode);
        
        Element sValueString = d.createElementNS(ns, "langstring");
        sValueString.setAttribute("xml:lang", "jp");
        sValueString.setTextContent("Author");
        sourceValueNode.appendChild(sValueString);
        

        Element centityNode = d.createElementNS(ns, "centity");
        
        String creatorName = md.getCreator();
        creatorName = "begin:vcard fn: " + creatorName + " end:vcard";
        Element vcardNode = d.createElementNS(ns, "vcard");
        vcardNode.setTextContent(creatorName);
        centityNode.appendChild(vcardNode);
        
        contribute.appendChild(centityNode);
        
        Element dateNode = d.createElementNS(ns, "date");
        
        String createdValue = md.getCreated();
        Element datetimeNode = d.createElementNS(ns, "datetime");
        datetimeNode.setTextContent(createdValue);
        dateNode.appendChild(datetimeNode);
        
        Element datedescriptionNode = d.createElementNS(ns, "description");
        Element datelangString = d.createElementNS(ns, "langstring");
        datelangString.setTextContent("created");
        datedescriptionNode.appendChild(datelangString);
        dateNode.appendChild(datedescriptionNode);
        
        contribute.appendChild(dateNode);

        lifecycleNode.appendChild(contribute);

        // metametadata

        // NodeList metametadata = d.getElementsByTagNameNS(ns,"metametadata");

        // technical

        // NodeList technical = d.getElementsByTagNameNS(ns,"technical");

        // educational
        NodeList educational = d.getElementsByTagNameNS(ns, "educational");
        Element educationalNode = (Element) educational.item(0);

        // educational_difficulty
        Element educationalDifficulty = d.createElementNS(ns, "difficulty");
        educationalNode.appendChild(educationalDifficulty);

        Element difficultyVocabulary = d.createElementNS(ns, "Vocabulary");
        educationalDifficulty.appendChild(difficultyVocabulary);

        String educationalDifficultyValue = md.getDifficulty();
        Element difficultyValue = d.createElementNS(ns, "value");
        difficultyVocabulary.appendChild(difficultyValue);

        Element educationalDifficultyString = d.createElementNS(ns,
                "langstring");
        educationalDifficultyString.setAttribute("xml:lang", "jp");
        educationalDifficultyString.setTextContent(educationalDifficultyValue);
        difficultyValue.appendChild(educationalDifficultyString);

        // educational_typicalLearningtime
        Element typicalLearningtime = d.createElementNS(ns,
                "typicalLearningTime");
        educationalNode.appendChild(typicalLearningtime);

        Element LearningtimeDuration = d.createElementNS(ns, "Duration");
        typicalLearningtime.appendChild(LearningtimeDuration);

        String educationalLearningtimeString = md.getLearningtime();
        Element LearningtimeValue = d.createElementNS(ns, "value");
        LearningtimeValue.setTextContent(educationalLearningtimeString);
        LearningtimeDuration.appendChild(LearningtimeValue);

        // rights
        NodeList rights = d.getElementsByTagNameNS(ns, "rights");
        Element rightsNode = (Element) rights.item(0);

        // rights_description
        Element rightsDescription = d.createElementNS(ns, "description");
        rightsNode.appendChild(rightsDescription);

        String rightsDescriptionString = md.getRights();
        Element DescriptionString = d.createElementNS(ns, "langstring");
        DescriptionString.setTextContent(rightsDescriptionString);
        rightsDescription.appendChild(DescriptionString);

        // relation
        NodeList relation = d.getElementsByTagNameNS(ns, "relation");
        Element relationNode = (Element) relation.item(0);
        String entryString = md.getEntry();
        if (entryString != null) {
            String[] entryArray = entryString.split(",");
            Element kindNode = d.createElementNS(ns, "kind");
            Element vocabularyNode = d.createElementNS(ns, "vocabulary");

            Element kindsourceNode = d.createElementNS(ns, "source");
            Element kindsourcelangString = d.createElementNS(ns, "langstring");
            kindsourcelangString.setAttribute("xml:lang", "x-none");
            kindsourcelangString.setTextContent("Lomv1.0");
            kindsourceNode.appendChild(kindsourcelangString);
            vocabularyNode.appendChild(kindsourceNode);

            Element kindvalueNode = d.createElementNS(ns, "value");
            Element kindvalueString = d.createElementNS(ns, "langstring");
            kindvalueString.setAttribute("xml:lang", "x-none");
            kindvalueString.setTextContent("Requires");
            kindvalueNode.appendChild(kindvalueString);
            vocabularyNode.appendChild(kindvalueNode);

            kindNode.appendChild(vocabularyNode);
            relationNode.appendChild(kindNode);

            Element relationResourceNode = d.createElementNS(ns, "resource");
            for(int i = 0; i < entryArray.length; i++) {
                Element resourceCatelogentryNode = d.createElementNS(ns,
                "catalogentry");
                Element catalogentryCatalog = d.createElementNS(ns, "catalog");
                catalogentryCatalog.setTextContent("learnings");
                resourceCatelogentryNode.appendChild(catalogentryCatalog);
                Element catalogentryEntry = d.createElementNS(ns, "entry");
                Element entryLangstring = d.createElementNS(ns, "langstring");
                entryLangstring.setTextContent(entryArray[i]);
                catalogentryEntry.appendChild(entryLangstring);
                resourceCatelogentryNode.appendChild(catalogentryEntry);

                relationResourceNode.appendChild(resourceCatelogentryNode);

                relationNode.appendChild(relationResourceNode);    
            }
        }
        /*
        //relation_kind
        String kindString = md.getKind();
        if (!kindString.equals(null)) {
            Element kindNode = d.createElementNS(ns, "kind");
            Element vocabularyNode = d.createElementNS(ns, "vocabulary");
            
            Element kindsourceNode = d.createElementNS(ns, "source");
            Element kindsourcelangString = d.createElementNS(ns, "langstring");
            kindsourcelangString.setAttribute("xml:lang", "x-none");
            kindsourcelangString.setTextContent("Lomv1.0");     
            kindsourceNode.appendChild(kindsourcelangString);
            vocabularyNode.appendChild(kindsourceNode);
            
            Element kindvalueNode = d.createElementNS(ns, "value");
            Element kindvalueString = d.createElementNS(ns, "langstring");
            kindvalueString.setAttribute("xml:lang", "x-none");
            kindvalueString.setTextContent(kindString);     
            kindvalueNode.appendChild(kindvalueString);
            vocabularyNode.appendChild(kindvalueNode);
            
            kindNode.appendChild(vocabularyNode);
            relationNode.appendChild(kindNode);
            
        }
        
        //relation_catalog&entry
        String catalogString = md.getCatalog();
        String entryString = md.getEntry();
        if (!catalogString.equals(null) && !entryString.equals(null)) {
            Element relationResourceNode = d.createElementNS(ns, "resource");
            Element resourceCatelogentryNode = d.createElementNS(ns, "catalogentry");
            
            Element catalogentryCatalog = d.createElementNS(ns, "catalog");
            catalogentryCatalog.setTextContent(catalogString);
            resourceCatelogentryNode.appendChild(catalogentryCatalog);
            
            Element catalogentryEntry = d.createElementNS(ns, "entry");
            Element entryLangstring = d.createElementNS(ns, "langstring");
            entryLangstring.setTextContent(entryString);
            catalogentryEntry.appendChild(entryLangstring);
            resourceCatelogentryNode.appendChild(catalogentryEntry);
            
            relationResourceNode.appendChild(resourceCatelogentryNode);
            
            relationNode.appendChild(relationResourceNode);
        }
        */

        return d;
    }

    static Document makeManifestDoc(Document d, MetaData md) {
        String textFileName = null;
        // int count = 0;
        // String itemTitleName = null;
        // String textName = null;
        String ns = "http://www.imsproject.org/xsd/ims_cp_rootv1p1";
        int idCount = 1;
        NodeList resources = d.getElementsByTagNameNS(ns, "resources");

        /*
        
        //organizationsの中身
        Node repOrg[] = xpath("//*[local-name()='organizations']",d);
        Element repOrg0 = (Element)repOrg[0];
        repOrg0.setAttribute("default", "");//IDっぽいのは後で考える
        
        NodeList organizations = d.getElementsByTagNameNS(ns,"organizations");
        Element organization = d.createElementNS(ns,"organization");
        organization.setAttribute("objectiveGlobalToSystem", "true");
        organization.setAttribute("identifier", "");//IDっぽいのは後で考える
        
        //organization_title
        Element orgTitle = d.createElementNS(ns,"title");
        orgTitle.setTextContent("");//保留
        organization.appendChild(orgTitle);
        
        //metadata
        Element orgMetadata = d.createElementNS(ns, "metadata");
        organization.appendChild(orgMetadata);
    
        //Item
        Element firstItem = d.createElementNS(ns, "Item");
        firstItem.setAttribute("identifier", "");//IDっぽいのは後で考える
        firstItem.setAttribute("identifierref", "");//IDっぽいのは後で考える
        organization.appendChild(firstItem);
        
        //Item_title
        itemTitleName = md.getTitle();
        Element itemTitle = d.createElementNS(ns,"title");
        itemTitle.setTextContent(itemTitleName);
        firstItem.appendChild(itemTitle);

        //adlcp:timelimitaction
        Element adlcpTimelimitaction = d.createElement("adlcp:timelimitaction");
        adlcpTimelimitaction.setTextContent("");//保留
        firstItem.appendChild(adlcpTimelimitaction);
        
        //metadata
        Element firstItemMetadata = d.createElementNS(ns, "metadata");
        firstItem.appendChild(firstItemMetadata);
        
        */
        
        //シーケンシングっぽいデータなので後回し
        //<adlnav:presentation>
        //<adlnav:navigationInterface>
        //<adlnav:hideLMSUI>continue</adlnav:hideLMSUI>
        //</adlnav:navigationInterface>
        //</adlnav:presentation>

        // ArrayList<MetaData> texttitle = md.getChildren();
        ArrayList<MetaData> fileName = md.getChildren();

        // String a = texttitle.get(count).getTitle();
        // System.out.println("1"+a);

        // for (MetaData m : texttitle) {
        //     count++;
        //     System.out.println("title"+m.getTitle());
        // }

        for (MetaData m : fileName) {

            /*
            
            //教材Item
            Element textItem = d.createElementNS(ns,"Item");
            textItem.setAttribute("identifier", "");//IDっぽいのは後で考える
            textItem.setAttribute("identifierref", "");//IDっぽいのは後で考える
                
            //title
            textName = (String)texttitle.get(count).getTitle();
            Element textTitle = d.createElementNS(ns,"title");
            textTitle.setTextContent(textName);
            textItem.appendChild(textTitle);
            
            count++;
            
            //adlcp:timelimitaction
            Element textAdlcpTimelimitaction = d.createElement("adlcp:timelimitaction");
            textAdlcpTimelimitaction.setTextContent("");//保留
            textItem.appendChild(textAdlcpTimelimitaction);
            
            //metadata
            Element textMetadata = d.createElementNS(ns, "metadata");
            textItem.appendChild(textMetadata);
            
            firstItem.appendChild(textItem);
                
            Element e1 = (Element)organizations.item(0);
            e1.appendChild(organization);
            //organizations End
            
            */

            // resourcesの中身
            // resource
            textFileName = m.getFileName();
            Element resource = d.createElementNS(ns, "resource");

            String tmpId = "DO-JOHODAI-";
            tmpId = tmpId + idCount;
            resource.setAttribute("identifier", tmpId);// IDっぽいのは後で考える
            idCount++;

            resource.setAttribute("adlcp:scormType", "sco");
            resource.setAttribute("type", "webcontent");
            resource.setAttribute("href", textFileName);

            //file
            /*
            Element file = d.createElementNS(ns, "file");
            file.setAttribute("href", textFileName);
            resource.appendChild(file);
            
            //metadata
            Element metadata = d.createElementNS(ns, "metadata");
            file.appendChild(metadata);
            
            //schema
            Element schema = d.createElementNS(ns, "schema");
            schema.setTextContent("ADL SCORM");
            metadata.appendChild(schema);
            
            //schemaversion
            Element schemaversion = d.createElementNS(ns, "schemaversion");
            schemaversion.setTextContent("2004 3rd Edition");
            metadata.appendChild(schemaversion);
            
            //adlcp:location
            Element adlcpLocation = d.createElement("adlcp:location");
            String textLomFileName = textFileName.replace(".S.xhtml", ".S.xml"); 
            adlcpLocation.setTextContent(textLomFileName);
            metadata.appendChild(adlcpLocation);
            
            */

            Element metadata = d.createElementNS(ns, "metadata");
            resource.appendChild(metadata);

            Element adlcpLocation = d.createElement("adlcp:location");
            String textLomFileName = textFileName.replace(".S.xhtml", ".S.xml");
            adlcpLocation.setTextContent(textLomFileName);
            metadata.appendChild(adlcpLocation);

            Element e2 = (Element) resources.item(0);
            e2.appendChild(resource);

        }

        return d;
    }
}