/*
 * 更新内容
 * 
 * MyInit()のAPI取得部分を更新(c314では動きました)
 * 穴埋め問題(input text)に対応
 * function questionSelect()の修正
 * それっぽい感じでデータをセット可能になりました(まだ未検証の部分がありますが)
 */

/*
 * my javascript
 * 教材に組込むためのJavaScript
 * 教材のHTMLbodyタグのonloadとonunloadにそれぞれ
 * MyInit()とMyFin()を指定するべし．
 * その他の関数は，これから作る．
 * LMSから情報をゲットするテスト関数だけ書いた．
 */


/*
 * 1.2と2004でfunction名が異なるものは振り分けてますが，
 * 2004の方はまだ試せてません．
 * 1.2の方はJenaLMSで動作確認をしています（一応動きます）．
 * Error処理を少し加えました．少しだけですが…
 * 
 */



//
//------------------------------ データモデル格納 Start ------------------------------
//
var API = null;
var sType = null;
var sRun = false;
var sFin = false;

var myCredit;
var myEntry;
var myExit;
var myLocation;
var myMode;
var myScoreChildren;
var myScoreMax;
var myScoreMin;
var myScoreRaw;
var mySessionTime;
var myUserId;
var myUserName;
var myTotalTime;
var myInteractionsUserResponse;
var myInteractionsTime;
var myCompScore;
var myLearningTime;
var myTimeLimitAction;
var myPreferenceChildren;
var myPreferenceAudio;
var myPreferenceLanguage;
var myPreferenceSpeed;
var myPreferenceText;

var setError ="0";
var errorCode = new Array();

function DataModelStore2004() {
	myCredit 		  			= "cmi.credit";
	myEntry 		   			= "cmi.entry";
	myExit 			   			= "cmi.exit";
	myLocation 		   			= "cmi.location";
	myMode 			   			= "cmi.mode";
	myScoreChildren     		= "cmi.score._children";
	myScoreMax 		   			= "cmi.score.max";
	myScoreMin 		   			= "cmi.score.min";
	myScoreRaw 		   			= "cmi.score.raw";
	mySessionTime 	   			= "cmi.session_time";
	myUserId 		   			= "cmi.learner_id";
	myUserName 		   			= "cmi.learner_name";
	myTotalTime 		   		= "cmi.total_time";
//	myInteractionsUserResponse 	= "cmi.interactions.n.learner_response";
//	myInteractionsTime 	   		= "cmi.interactions.n.timestamp";
	myCompScore 		   		= "cmi.scaled_passing_score";
	myLearningTime 		   		= "cmi.max_time_allowed";
	myTimeLimitAction 	   		= "cmi.time_limit_action";
	myPreferenceChildren 	   	= "cmi.learner_preferece._children";
	myPreferenceAudio 	   		= "cmi.learner_preferece.audip_level";
	myPreferenceLanguage 	  	= "cmi.learner_preferece.language";
	myPreferenceSpeed 	   		= "cmi.learner_preferece.delivery_speed";
	myPreferenceText 	   		= "cmi.learner_preferece.audio_captioning";
	errorCode["error_0"]   		= "No error";//エラーが発生していない
	errorCode["error_101"] 		= "General exception";//一般的な例外 Initialize()
	errorCode["error_102"] 		= "General Initialization Failure";//初期化の失敗 Initialize()
	errorCode["error_103"] 		= "Already Initialized";//初期化後に初期化しようとした Initialize()
	errorCode["error_104"] 		= "Content Instance Terminated";//セッション終了後に初期化 Initialize()
	errorCode["error_111"] 		= "General Termination Failure";//終了処理失敗 Terminate()
	errorCode["error_112"] 		= "Termination Before Initialization";//初期化前に終了しようとした Terminate()
	errorCode["error_113"] 		= "Termination After Termination";//終了後に終了しようとした Terminate()
	errorCode["error_122"] 		= "Retrieve Data Before Initialization";//初期化前にデータの読み出しを行った GetValue()
	errorCode["error_123"] 		= "Retrieve Data After Termination";//終了後にデータの読み出しを行った GetValue()
	errorCode["error_132"] 		= "Store Data Before Initialization";//初期化前にデータを格納しようとした SetValue()
	errorCode["error_133"] 		= "Store Data After Termination";//終了後にデータを格納しようとした SetValue()
	errorCode["error_142"] 		= "Commit Before Initialization";//初期化前にデータを保存しようとした Commit()
	errorCode["error_143"] 		= "Commit After Termination";//終了後にデータを保存しようとした Commit()
	errorCode["error_201"] 		= "General Argument Error";//API関数に不当な引数を渡そうとした Initialize() Terminate() Commit()
	errorCode["error_301"] 		= "General Get Failure";//データの読み出し失敗 GetValue()
	errorCode["error_351"] 		= "General Set Failure";//データの格納に失敗 SetValue()
	errorCode["error_391"] 		= "General Commit Failure";//データの保存に失敗 Commit()
	errorCode["error_401"] 		= "Undefined Data Model Element";//定義されていないデータモデルの要素を指定 GetValue() SetValue()
	errorCode["error_402"] 		= "Unimplemented Data Model Element";//実装されていないデータモデル要素
	errorCode["error_403"] 		= "Data Model Element Value Not Initialized";//SCOが初期化されていないデータモデル要素の値のデータを読み出そうとした GetValue()
	errorCode["error_404"] 		= "Data Model Element Is Read Only";//読み出し専用のデータに格納しようとした SetValue()
	errorCode["error_405"] 		= "Data Model Element Is Write Only";//書き込み専用のデータを読み出そうとした GetValue()
	errorCode["error_406"] 		= "Data Model Element Type Mismatch";//不正なデータタイプの値をデータモデル要素に格納しようとした SetValue()
	errorCode["error_407"] 		= "Data Model Element Value Out Of Range";//範囲外の値をデータモデル要素に格納しようとした SetValue()
	errorCode["error_408"]	 	= "Data Model Dependency Not Established";//他の要素が設定される前に設定されるべきデータモデルが設定されていない GetValue() SetValue()
}

function DataModelStore1_2() {
	myCredit 		   			= "cmi.core.credit";
	myEntry 		   			= "cmi.core.entry";
	myExit 			   			= "cmi.core.exit";
	myLocation 		   			= "cmi.core.lesson_location";
	myMode 			   			= "cmi.core.lesson_mode";
	myScoreChildren 	   		= "cmi.core.score._children";
	myScoreMax 		   			= "cmi.core.score.max";
	myScoreMin 		   			= "cmi.core.score.min";
	myScoreRaw 		   			= "cmi.core.score.raw";
	mySessionTime 		   		= "cmi.core.session_time";
	myUserId 		   			= "cmi.core.student_id";
	myUserName 		   			= "cmi.core.student_name";
	myTotalTime 		   		= "cmi.core.total_time";
//	myInteractionsUserResponse 	= "cmi.interactions.n.student_response";
//	myInteractionsTime 	   		= "cmi.interactions.n.time";
	myCompScore 		   		= "cmi.student_data.mastary_score";
	myLearningTime 		   		= "cmi.student_data.max_time_allowed";
	myTimeLimitAction 	   		= "cmi.student_data.time_limit_action";
	myPreferenceChildren 	   	= "cmi.student_preference._children";
	myPreferenceAudio 	   		= "cmi.student_preference.audio";
	myPreferenceLanguage 	   	= "cmi.student_preference.language";
	myPreferenceSpeed 	   		= "cmi.student_preference.speed";
	myPreferenceAudioText 	   	= "cmi.student_preference.text";
	errorCode["error_0"]   		= "No error";//エラーが発生していない
	errorCode["error_101"] 		= "General exception";//一般的な例外 Initialize()
	errorCode["error_201"] 		= "Invalid argument error";
	errorCode["error_202"] 		= "Element cannot have children";
	errorCode["error_203"] 		= "Element not an array. Cannot have count";
	errorCode["error_301"] 		= "Not initialized";
	errorCode["error_401"] 		= "Not implemented error";
	errorCode["error_402"] 		= "Invalid set value, element is a keyword";
	errorCode["error_403"] 		= "Element is read only";
	errorCode["error_404"] 		= "Element is write only";
	errorCode["error_405"] 		= "Incorrect Data Type";
}
//
//------------------------------ データモデル格納 End ------------------------------
//
//
//------------------------------ Initialize Start ------------------------------
//
function MyInit() {
    API = FindAPI2004(window);
    if(API != null) {
	if(sRun == "true") {
	    setError = "103";
	    return false;
        }
	if(sFin == "true") {
	    setError = "104";
	    return false;
	}
	sType = "2004";
	sRun = "true";
	API.Initialize("");
	alert("2004");
	DataModelStore2004();
	beginningTime();
    } else {
	API = FindAPI1_2(window);
	if(API != null) {
	    sType = "1_2";
	    API.LMSInitialize("");
	    alert("1_2");
	    DataModelStore1_2();
	    beginningTime();
	}
    }
    if(API == null){
        alert("API not found.");
    }
}
//
//------------------------------ FindAPI Start ------------------------------
//

//
//SCORM1.2ver FindAPI
//
function FindAPI1_2(win) {
    if((typeof(win.API) != "undefined") && (win.API != null)) {
        return win.API;
    } else if (win.location != top.location) {
        return FindAPI1_2(win.parent);
    } else {
        if (win.opener != null) {
            return FindAPI1_2(win.opener);
        } else {
            return null;
        }
    }
}

//
//SCORM2004ver FindAPI
//
function FindAPI2004(win) {
    if ((typeof(win.API_1484_11) != "undefined") && (win.API_1484_11 != null)) {
	return win.API_1484_11;
    } else if(win.location == top.location) {
	return null;
    } else {
	return FindAPI2004(win.parent);
    }
}
//
//------------------------------ FindAPI End ------------------------------
//
//
//------------------------------ Initialize End ------------------------------
//





//
//------------------------------ Terminate Start ------------------------------
//
function MyFin() {
    if (API != null) {
	if(sType == "1_2") {
	    API.LMSFinish("");
	} else if(sType == "2004") {
	    if(sRun == "false") {
		setError = "112";
		return false;
            }
	    if(sFin == "true") {
		setError = "113";
		return false;
            }
	    sFin = "true";
	    API.Terminate("");
        }
    }
}
//
//------------------------------ Terminate End ------------------------------
//





//
//------------------------------ LMSGetValue Start ------------------------------
//
function MyGetValue(name) {
//alert("getValue");
    if(sRun == "false") {
	setError = "122";
	return false;
    }
    if(sFin == "true") {
	setError = "123";
	return false;
    }
    if (API != null) {
	if(sType == "1_2") {
	    var value = API.LMSGetValue(name);
	} else if(sType == "2004") {
	    var value = API.GetValue(name);
        }
    if(value.toString() == "undefined") {
	setError = "301";
	return false;
    }
    return value.toString();
    }
    return "";
}

//
//------------------------------ LMSGetValue End ------------------------------
//





//
//------------------------------ LMSSetValue Start ------------------------------
//
function MySetValue(name, value) {
//alert("setValue");
    if(sRun == "false") {
	setError = "132";
	return false;
    }
    if(sFin == "true") {
	setError = "133";
	return false;
    }
    if(value == "undefined" || value == "") {
	setError = "351";
	return false;
    }
    if (API != null) {
	if(sType == "1_2") {
	    var result = API.LMSSetValue(name, value);
	} else if(sType == "2004") {
	    var result = API.SetValue(name, value);
        }
    }
}

//
//------------------------------ LMSSetValue End ------------------------------
//






//
//------------------------------ LMSCommit Start ------------------------------
//
function MyCommit() {
    if(sRun == "false") {
	setError = "142";
	return false;
    }
    if(sFin == "true") {
	setError = "143";
	return false;
    }
    if (API != null) {
	if(sType == "1_2") {
	    var result = API.LMSCommit("");
	} else if(sType == "2004") {
	    var result = API.Commit("");
        }
    }
    return true;
}

//
//------------------------------ LMSCommit End ------------------------------
//





//
//------------------------------ LMSGetLastError Start ------------------------------
//
function MyGetLastError() {
    //if(sType == "1_2") {
	//return API.LMSGetLastError().toString();
    //} else if(sType == "2004") {
	//return API.GetLastError().toString();
    //}
	return setError;
}

//
//------------------------------ LMSGetLastError End ------------------------------
//





//
//------------------------------ LMSGetLastString Start ------------------------------
//
function MyGetErrorString() {
    //if (API != null) {
	//if(sType == "1_2") {
	//    return API.LMSGetErrorString(errorCode).toString();
	//} else if(sType == "2004") {
	//    return API.GetErrorString(errorCode).toString();
    //    }
    //}
    //return "";
	var errorString = "error_" + setError;
	return errorCode[errorString];
}

//
//------------------------------ LMSGetLastString End ------------------------------
//





//
//------------------------------ LMSGetLastDiagnostic Start ------------------------------
//
function MyGetDiagnostic(errorCode) {
    if (API != null) {
	if(sType == "1_2") {
	    return API.LMSGetDiagnostic(errorCode).toString();
	} else if(sType == "2004") {
	    return API.GetDiagnostic(errorCode).toString();
        }
    }
    return "";
}

//
//------------------------------ LMSGetLastDiagnostic End ------------------------------
//





//
//------------------------------ 時間取得 Start ------------------------------
//
var startTime;
var passTime;
var passingTime;
var translationTime;

function beginningTime() {
    startTime = new Date().getTime();
}

function endTime() {
    var passTime = "00:00:00.00";

    if (startTime != 0) {
      	var passingTime = new Date().getTime();
      	var translationTime = ((passingTime - startTime) / 1000);
      	passTime = transSeconds(translationTime);
    }
    return passTime;
} 

function transSeconds(tTime) {
    var Sec = (tTime % 60);

    tTime -= Sec;
    var tmpMin = (tTime % 3600);
    tTime -= tmpMin;
    if ((tTime % 3600) != 0) {
	var Hour = "00" ;
    } else {
	var Hour = "" + (tTime / 3600);
    }
    if ((tmpMin % 60) != 0) {
	var Min = "00";
    } else { 
	var Min = "" + (tmpMin / 60);
    }
    Sec = "" + Sec;
    Sec = Sec.substring(0,Sec.indexOf("."));
    if (Hour.length < 2) {
	Hour = "0"+ Hour;
    }
    if (Min.length < 2) {
	Min = "0" + Min;
    }
    if (Sec.length < 2) {
	Sec = "0" + Sec;
    }
    var reTime = Hour + ":" + Min + ":" + Sec;
    return reTime;
}

function timeSave() {
    var tt = MyGetValue(myTotalTime) + endTime();
    MySetValue(myTotalTime, tt);
    MySetValue(mySessionTime, endTime());
}
//
//------------------------------ 時間取得 End ------------------------------
//





//
//------------------------------ ラジオボタン問題 Start ------------------------------
//
function sentakuRadio(tmp,kai_node) {
    var che = "false";//未解答チェック
    var i = 0;
    var ts = "false";
//alert(kai_node[0].textContent);
    for(i = 0; i < tmp.length; i++) {
		if(tmp[i].checked) {
	    	che = "true";
	    	//alert(tmp[i].value);
	    	if(tmp[i].value == kai_node[0].textContent) {
	        	//解答処理
				ts = "true";
	    	}
		}
		if(che == "false" && i == tmp.length-1) {
	    	//誤答処理
	    	ts = "miss";
		}
    }
    return ts;
}

//
//------------------------------ ラジオボタン問題 End ------------------------------
//





//
//------------------------------ チェックボックス問題 Start ------------------------------
//
function sentakuCheckBox(tmp,kai_node) {
    var che = "false";//未解答チェック
    var cCount = 0;//正答数
    var cc = 0;//正誤判定
    var ts = "false";
    for(i = 0; i < tmp.length; i++) {
		if(tmp[i].checked) {
	    	che = "true";
	    	//alert(tmp[i].value);
	    	cc = CheckAns(tmp[i].value,kai_node);
			cCount += cc;
		}
    }
	if(cCount == kai_node.length) {
	    //解答処理
	    ts = "true";
    } else if(che == "false" && i == tmp.length) {
	    //誤答処理
	    ts = "miss";
    }
    return ts;
}

function CheckAns(ans,kai_node) {
	var check = 0;
	for (j = 0; j < kai_node.length; j++) {
		if(ans == kai_node[j].textContent) {
			check++;
		}
	}
	if (check == 0) {
		check--;
	}
	return check;
}
//
//------------------------------ チェックボックス問題 End ------------------------------
//





//
//------------------------------ セレクトボックス問題 Start ------------------------------
//
function sentakuSelect(tmp,kai_node) {
    var che = "false";//未解答チェック
    var i = 0;
    var ts = "false";
    for(i = 0; i < tmp.length; i++) {
		if(tmp[i].selected) {
	    	che = "true";
	    	//alert(tmp[i].value);
	    	if(tmp[i].value == kai_node[0].textContent) {
	        	//解答処理
				ts = "true";
	    	}
	    	if(ts == "false" && tmp[i].text == "") {
				//誤答処理
				ts = "miss";
	    	}
		}
		if(che == "false" && i == tmp.length-1) {
	    	//誤答処理
	    	ts = "miss";
		}
    }
    return ts;
}



//
//------------------------------ セレクトボックス問題 End ------------------------------
//





//
//------------------------------ 穴埋め問題 Start ------------------------------
//
function sentakuTextBox(tmp,kai_node) {
    var che = "false";//未解答チェック
    var ts = "false";
    if(tmp[0].value != "") {
		che = "true";
		if(tmp[0].value == kai_node[0].textContent) {
	    	//解答処理
	    	ts = "true";
		}
    } else {
		 //誤答処理
		ts = "miss";
    }
    return ts;
}



//
//------------------------------ 穴埋め問題 End ------------------------------
//






//
//------------------------------ 複合問題 Start ------------------------------
//
function sentakuSaiten(httpObj) {
    var seigo;//問題の正誤格納
    var XML = httpObj.responseXML;//解答XML
    var Node1;//解答ノード
    var Node2;//解答タグ
    var lastq = 0;
	var i = 0;
    var mLen = document.getElementsByTagName("form");//問題数とかその他もろもろ
    var sLen;//問題の種類の情報
    questionResultInit(mLen, XML);
    qnum = mLen.length;
    for(i = 0; i < mLen.length; i++) {
		sLen = document.getElementById(mLen[i].id);
		Node1 = XML.getElementsByTagName(sLen.id);
		Node2 = Node1[0].getElementsByTagName("ans");
		seigo = questionSelect(sLen,Node2);
		if(seigo == "true") {
	        //正解処理
			sScore = sScore + partScore;
	        alert(i+1 + "番目：正解");
	    } else if(seigo == "false") {
	        //不正解処理
	        alert(i+1 + "番目：不正解");
		} else if(seigo == "miss") {
	        //不正解処理
	        alert(i+1 + "番目：未入力");
	    }
		lastq = i;
    }
	Result(mLen[lastq].id);
	questionResultFin();
}
var qnum = 0;//問題数
var partScore = 0;
var sScore = 0; 
//
//
//
function questionResultInit(mLen, XML) {
	qnum = mLen.length;
	var fullScore = XML.getElementsByTagName("setvar")[0].textContent;
	partScore = fullScore/qnum;
	//alert(partScore);
}
function questionResultFin() {
	var tempMax = MyGetValue(myScoreMax);
	if(tempMax == "" || tempMax < sScore) {
		MySetValue(myScoreMax, sScore);
	} 
	var tempMin = MyGetValue(myScoreMin);
	if(tempMin == "" || tempMin > sScore) {
		MySetValue(myScoreMin, sScore);
	}
	MySetValue(myScoreRaw, sScore);
	alert(sScore);
	sScore = 0;
}
function Result(lastQName) {
	var formRoot = document.getElementById(lastQName);
	var getForm = formRoot.lastChild;
	var box = document.createElement("input");
	box.setAttribute("type", "text");
	box.setAttribute("value", sScore + "点");
	box.setAttribute("size", 5);
	formRoot.replaceChild(box, getForm);
}	
	
	
	






function loadXMLFile() {
	//var ansFile = document.body.getAttribute("qid");
	//ansFile = ansFile + "A.xml"; 
	var ss = document.URL.split('/');
	ansFile = ss[ss.length-1];
	ansFile = ansFile.replace('.S.xhtml','.A.xml');
	new Ajax.Request(ansFile, { method: "get", onComplete: sentakuSaiten });
}
function displayData(httpObj) {
	var XML = httpObj.responseXML;
	//var qid = document.body.getAttribute("qid");
	var qid = document.body.getAttribute("qid");
	var Node1 = XML.getElementsByTagName(qid);
	var Node2 = Node1[0].getElementsByTagName("ans");
	for (j = 0;j < Node2.length;j++) {
			alert(Node2[j].textContent);
	}
}



function questionSelect(tmp,kai_node) {
    var qt;
    var qType = tmp[0]
    //alert(qType.type);
    if(qType.tagName == "select") {
	var selTmp = document.getElementById(tmp[0].id);
	qt = sentakuSelect(selTmp,kai_node);
    } else if(qType.type == "radio") {
	qt = sentakuRadio(tmp,kai_node);
    } else if (qType.type == "text") {
	qt = sentakuTextBox(tmp,kai_node);
    } else if (qType.type == "checkbox") {
	qt = sentakuCheckBox(tmp,kai_node);
    }
    return qt;
}



function sentakuSaiten_proto() {
    var seigo;//問題の正誤格納
    var i = 0;
    var mLen = document.getElementsByTagName("form");//問題数とかその他もろもろ
    var sLen;//問題の種類の情報
    for(i = 0; i < mLen.length; i++) {
	sLen = document.getElementById(mLen[i].id);
	seigo = questionSelect(sLen);
	if(seigo == "true") {
	    //正解処理
	    alert(i+1 + "番目：正解");
	} else if(seigo == "false") {
	    //不正解処理
	    alert(i+1 + "番目：不正解");
	} else if(seigo == "miss") {
	    //不正解処理
	    alert(i+1 + "番目：未入力");
	}
    }
}
//-------------------------------------------------------------------------------





//-------------------------------------------------------------------------------


//
//------------------------------ 複合問題 End ------------------------------
//





//
//------------------------------ 学習者名取得 Start ------------------------------
//
function GetLearnerName(){
    var name = "";
    if(API != null) {
	name   = MyGetValue(myUserName);
    }
    return name;
}
//
//------------------------------ 学習者名取得 End ------------------------------
//





//
//------------------------------ SCO初期化 Start ------------------------------
//
function MySCOInit() {
    var mInit = MyInit();
    if (mInit == true) {
    	if(GetLearnerName()=="") {
      	    alert("ログオンされていません。");
        } else {
	    var fStudy = learningStatusInit();
      	} 
	if (fStudy == "false") {
            // 前回終了時のページを表示する
            var loc = MyGetValue(myLocation);
            if ((loc != "") && (location.pathname != loc)) {
                res = confirm("前回終了時のページに移動しますか？");
		if(res == "true") {
		    location.href = loc;
		}
            } else {
                MySetValue(myLocation, location.pathname);
                MyCommit();
            }
    	}
    }
}


//
//SCO初期化 学習状態の初期化(SCOに初アクセス)
//
function learningStatusInit() {
    var flag = "false";
    if(sType == "2004") {
    	var completion_status = MyGetValue("cmi.completion_status");
    	if (completion_status == "unknown" ||completion_status == "not_attempted") {
            MySetValue(myMode, "normal"); //cmi.modeはnormalで固定で
            MySetValue("cmi.completion_status", "incomplete");
            MyCommit();
	    flag = "true";
        }
    } else if(sType == "1_2") {
    	var lesson_status = MyGetValue("cmi.core.lesson_status");
    	if (lesson_status == "not_attempted") {
      	    //MySetValue(myMode, "normal"); //cmi.modeはnormalで固定で
       	    MySetValue("cmi.core.lesson_status", "incomplete");
       	    MyCommit();
	    flag = "true";
    	}
    }
    return flag;
}

//
//------------------------------ SCO初期化 End ------------------------------
//





function MySCOFin() {
	
}



//
//------------------------------ SCO 終了 Start ------------------------------
//
function MySCOExit() {
    MySetValue(myExit, "logout");
    timeSave();
    MyCommit();
    MyFin();
}
//
//------------------------------ SCO 終了 End ------------------------------
//





//
//------------------------------ SCO 中断 Start ------------------------------
//
function MySCOSuspend() {
    MySetValue(myExit, "suspended");
    timeSave();
    MyCommit();
    MyFin();
}
//
//------------------------------ SCO 中断 End ------------------------------
//





//
//------------------------------ SCO 修了 Start ------------------------------
//
function MySCOComplete() {
    learningStatusComp();
    MyCommit();
    MyFin();
}

function learningStatusComp() {
    if(sType == "2004") {
	MySetValue("cmi.completion_status", "completed");
	MySetValue(myExit, "normal");
    } else if(sType == "1_2") {
	MySetValue("cmi.core.lesson_status", "completed");
	MySetValue(myExit, "");
    }
    MySetValue(myLocation, "");
    timeSave();
}
//
//------------------------------ SCO 修了 End ------------------------------
//


//
//ファイルアップロード
//
function createHttpRequest() {
    //Win ie用
    if (window.ActiveXObject) {
        try {
            return new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            try {
                //旧MSXML用
                return new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e2) {
                return null;
            }
        }
    } else if (window.XMLHttpRequest) {
        //Win ie以外のXMLHttpRequestオブジェクト実装ブラウザ用
        return new XMLHttpRequest();
    } else {
        return null;
    }
}

function createEmptyDOM() {
    //Win ie用
    if (window.ActiveXObject) {
        return new ActiveXObject("Microsoft.XMLDOM");
    } else if (document.implementation) {
        return document.implementation.createDocument("", "", null);
    } else {
        return null;
    }
}

function upfile() {
	var urltmp    = document.URL;
	var s         = urltmp.split("lampix");
	var tmpvalue  = urltmp.split(".");
	//var upname    = encodeURI(document.getElementById("up").value);
	var tmpvalue2 = tmpvalue[tmpvalue.length - 2].split("/");
	var saveurl   = encodeURI( s[0] + "lampix/upfile/" + tmpvalue2[tmpvalue2.length - 1] );
	urltmp = s[0] + "lampix/include/up.php";
	//alert(saveurl);
	
	//form作成
	var bodytag = document.getElementsByTagName("body");
	
	var form = document.createElement("form");
	form.setAttribute("action", urltmp);
	form.setAttribute("method", "post");
	form.setAttribute("enctype", "multipart/form-data");
	bodytag[0].appendChild(form);
	
	var input1 = document.createElement("input");
	input1.setAttribute("type", "file");
	input1.setAttribute("size", 30);
	input1.setAttribute("name", "upfile");
	form.appendChild(input1);
	var hidd = document.createElement("input");
	hidd.setAttribute("type", "hidden");
	hidd.setAttribute("name", "hidd");
	hidd.setAttribute("value", tmpvalue2[tmpvalue2.length - 1]);
	form.appendChild(hidd);
	var input2 = document.createElement("input");
	input2.setAttribute("type", "submit");
	input2.setAttribute("value", "up");
	form.appendChild(input2);
	//alert(tmpvalue2[tmpvalue2.length - 1]);
	
	
	/*
	var ajax = createHttpRequest();
	ajax.open("POST", urltmp, "true");//設計で入力したファイルの呼び出し
	ajax.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    ajax.onreadystatechange = function() {
        if (ajax.readyState == 4 && ajax.status == 200) {
            //alert("");
	    }
	}
	var data = "upname=" + upname + "&saveurl=" + saveurl;
	*/
	
	
}








function MyTest() {
    var eTime = endTime();
    alert(eTime);
    if (API == null) {
        alert("API not found!");
        return;
    }
    MySetValue("cmi.core.lesson_status", "incomplete");
//    var v = API.LMSGetValue("dummy.data1");
//    var v = API.LMSGetValue("cmi.core.lesson_status");
    var a = MyGetValue("cmi.core.lesson_status");
//    alert(a);
    window.document.testForm.text1.value = a;
}




