/*
 * Decompiled with CFR 0.152.
 */
package arq.cmd;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.AlgebraGeneratorQuad;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;

public class QueryUtils {
    public static void printPlan(Query query2, QueryExecution qe) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(query2, qe.getDataset().asDatasetGraph(), ARQ.getContext());
        if (f == null) {
            System.err.println("printPlan: Unknown engine type: " + Utils.className(qe));
        }
        Plan plan = f.create(query2, qe.getDataset().asDatasetGraph(), BindingRoot.create(), ARQ.getContext());
        SerializationContext sCxt = new SerializationContext(query2);
        IndentedWriter out = new IndentedWriter(System.out);
        plan.output(out, sCxt);
        out.flush();
    }

    public static void printQuery(Query query2) {
        IndentedWriter out = new IndentedWriter(System.out);
        QueryUtils.printQuery(out, query2);
    }

    public static void printQuery(IndentedWriter out, Query query2) {
        QueryUtils.printQuery(out, query2, Syntax.defaultSyntax);
    }

    public static void printQuery(IndentedWriter out, Query query2, Syntax syntax) {
        query2.serialize(out, syntax);
        out.flush();
    }

    public static void printOp(Query query2) {
        IndentedWriter out = new IndentedWriter(System.out);
        QueryUtils.printOp(out, query2);
    }

    public static void printOp(IndentedWriter out, Query query2) {
        Op op = Algebra.compile(query2);
        SerializationContext sCxt = new SerializationContext(query2);
        op.output(out, sCxt);
        out.flush();
    }

    public static void printQuad(Query query2) {
        IndentedWriter out = new IndentedWriter(System.out);
        QueryUtils.printQuad(out, query2);
    }

    public static void printQuad(IndentedWriter out, Query query2) {
        Op op = AlgebraGeneratorQuad.compileQuery(query2);
        SerializationContext sCxt = new SerializationContext(query2);
        op.output(out, sCxt);
    }
}

