/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.CmdUtils;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineQuad;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.junit.QueryTestSuiteFactory;
import com.hp.hpl.jena.sparql.junit.SimpleTestRunner;
import com.hp.hpl.jena.sparql.test.ARQTestSuite;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class qtest {
    static String className;
    static String usage;

    public static void main(String[] argv) {
        block3: {
            try {
                qtest.main2(argv);
            }
            catch (TerminationException ex) {
                System.exit(ex.getCode());
            }
            catch (CmdException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block3;
                ex.getCause().printStackTrace(System.err);
            }
        }
    }

    public static void main2(String[] argv) {
        CmdLineArgs cl = new CmdLineArgs(argv);
        ArgDecl helpDecl = new ArgDecl(false, "h", "help");
        cl.add(helpDecl);
        ArgDecl allDecl = new ArgDecl(false, "all");
        cl.add(allDecl);
        ArgDecl wgDecl = new ArgDecl(false, "wg", "dawg");
        cl.add(wgDecl);
        ArgDecl dirDecl = new ArgDecl(true, "dir");
        cl.add(dirDecl);
        ArgDecl queryDecl = new ArgDecl(true, "query");
        cl.add(queryDecl);
        ArgDecl dataDecl = new ArgDecl(true, "data");
        cl.add(dataDecl);
        ArgDecl resultDecl = new ArgDecl(true, "result");
        cl.add(resultDecl);
        ArgDecl engineDecl = new ArgDecl(true, "engine");
        cl.add(engineDecl);
        ArgDecl setDecl = new ArgDecl(true, "set", "define", "defn", "def");
        cl.add(setDecl);
        try {
            cl.process();
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            qtest.usage(System.err);
            throw new TerminationException(2);
        }
        if (cl.contains(helpDecl) || !cl.hasArgs() && !cl.hasPositional()) {
            qtest.usage();
            throw new TerminationException(0);
        }
        if (cl.getValues(setDecl) != null) {
            Iterator iter = cl.getValues(setDecl).iterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                String[] frags = arg.split("=", 2);
                if (frags.length != 2) {
                    throw new RuntimeException("Can't split '" + arg + "'");
                }
                String symbolName = frags[0];
                String value = frags[1];
                if (!symbolName.matches("^[a-zA-Z]*:")) {
                    symbolName = "http://jena.hpl.hp.com/ARQ#" + symbolName;
                }
                Symbol symbol = Symbol.create(symbolName);
                ARQ.getContext().set(symbol, value);
            }
        }
        if (cl.contains(engineDecl)) {
            if (cl.getValue(engineDecl).equalsIgnoreCase("engine2") || cl.getValue(engineDecl).equalsIgnoreCase("ref")) {
                QueryEngineRef.register();
            } else if (cl.getValue(engineDecl).equalsIgnoreCase("quad")) {
                QueryEngineQuad.register();
            } else {
                qtest.argError("No such engine (" + cl.getValue(engineDecl) + ")");
            }
        }
        if (cl.contains(queryDecl) || cl.contains(dataDecl) || cl.contains(resultDecl)) {
            if (!(cl.contains(queryDecl) && cl.contains(dataDecl) && cl.contains(resultDecl))) {
                qtest.argError("Must give query, data and result to run a single test");
            }
            String query2 = cl.getValue(queryDecl);
            String data = cl.getValue(dataDecl);
            String result = cl.getValue(resultDecl);
            TestSuite suite = QueryTestSuiteFactory.make(query2, data, result);
            SimpleTestRunner.runAndReport(suite);
            return;
        }
        if (cl.contains(allDecl)) {
            qtest.allTests();
            throw new TerminationException(0);
        }
        if (cl.contains(wgDecl)) {
            qtest.dawgTests();
            throw new TerminationException(0);
        }
        if (!cl.hasPositional()) {
            qtest.argError("No manifest file");
        }
        String testfile = cl.getPositionalArg(0);
        String testfileAbs = IRIResolver.resolveGlobal(testfile);
        NodeValue.VerboseWarnings = false;
        E_Function.WarnOnUnknownFunction = false;
        qtest.oneManifest(testfileAbs);
        throw new TerminationException(0);
    }

    static void oneManifest(String testManifest) {
        TestSuite suite = QueryTestSuiteFactory.make(testManifest);
        SimpleTestRunner.runAndReport(suite);
    }

    static void allTests() {
        qtest.ensureDirExists("testing");
        qtest.ensureDirExists("testing/ARQ");
        qtest.ensureDirExists("testing/DAWG");
        qtest.ensureDirExists("testing/DAWG-Approved");
        TestSuite ts = ARQTestSuite.suite();
        TestRunner.run(ts);
        throw new TerminationException(0);
    }

    static void dawgTests() {
        System.err.println("DAWG tests not packaged up yet");
        throw new TerminationException(4);
    }

    static void usage() {
        qtest.usage(System.err);
    }

    static void usage(PrintStream out) {
        out.println(usage);
    }

    static void argError(String s) {
        System.err.println("Argument Error: " + s);
        throw new TerminationException(3);
    }

    static void ensureDirExists(String dirname) {
        File f = new File(dirname);
        if (!f.exists() || !f.isDirectory()) {
            System.err.println("Can't find required directory: '" + dirname + "'");
            throw new TerminationException(8);
        }
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
        className = Utils.classShortName(qtest.class);
        usage = "One of:\n  " + className + " [--all]\n" + "  " + className + " [--dawg]\n" + "  " + className + " manifest\n" + "  " + className + " --query queryFile --data dataFile --result resultsFile\n" + "     where --all      run all built-in tests\n" + "           --dawg     run working group tests\n" + "           manifest   run a set of tests";
    }
}

