/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.sw.EncodingXmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class AsciiXmlWriter
extends EncodingXmlWriter {
    public AsciiXmlWriter(OutputStream out, WriterConfig cfg, String encoding) throws IOException {
        super(out, cfg, encoding);
    }

    public void writeRaw(char[] cbuf, int offset, int len) throws IOException {
        int ptr = this.mOutputPtr;
        byte[] outBuf = this.mOutputBuffer;
        while (len > 0) {
            int inEnd;
            int max2 = outBuf.length - this.mOutputPtr;
            if (max2 < 1) {
                this.flushBuffer();
                ptr = 0;
                max2 = outBuf.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            if (this.mCheckContent) {
                inEnd = offset + max2;
                while (offset < inEnd) {
                    char c = cbuf[offset];
                    if (c < ' ') {
                        if (c != '\n' && c != '\r' && c != '\t') {
                            this.throwInvalidChar(c);
                        }
                    } else if (c > '~') {
                        if (c != '\u007f') {
                            this.mOutputPtr = ptr;
                            this.throwInvalidAsciiChar(c);
                        } else if (this.mXml11) {
                            this.mOutputPtr = ptr;
                            this.throwInvalidChar(c);
                        }
                    }
                    outBuf[ptr++] = (byte)c;
                    ++offset;
                }
            } else {
                inEnd = offset + max2;
                while (offset < inEnd) {
                    outBuf[ptr++] = (byte)cbuf[offset];
                    ++offset;
                }
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
    }

    public void writeRaw(String str2, int offset, int len) throws IOException {
        int ptr = this.mOutputPtr;
        byte[] outBuf = this.mOutputBuffer;
        while (len > 0) {
            int inEnd;
            int max2 = outBuf.length - this.mOutputPtr;
            if (max2 < 1) {
                this.flushBuffer();
                ptr = 0;
                max2 = outBuf.length;
            }
            if (max2 > len) {
                max2 = len;
            }
            if (this.mCheckContent) {
                inEnd = offset + max2;
                while (offset < inEnd) {
                    char c = str2.charAt(offset);
                    if (c < ' ') {
                        if (c != '\n' && c != '\r' && c != '\t') {
                            this.throwInvalidChar(c);
                        }
                    } else if (c > '~') {
                        if (c != '\u007f') {
                            this.mOutputPtr = ptr;
                            this.throwInvalidAsciiChar(c);
                        } else if (this.mXml11) {
                            this.mOutputPtr = ptr;
                            this.throwInvalidChar(c);
                        }
                    }
                    outBuf[ptr++] = (byte)c;
                    ++offset;
                }
            } else {
                inEnd = offset + max2;
                while (offset < inEnd) {
                    outBuf[ptr++] = (byte)str2.charAt(offset);
                    ++offset;
                }
            }
            len -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected void writeAttrValue(String data) throws IOException, XMLStreamException {
    }

    protected int writeCDataContent(String data) throws IOException {
        return -1;
    }

    protected int writeCDataContent(char[] cbuf, int start, int len) throws IOException {
        return -1;
    }

    protected int writeCommentContent(String data) throws IOException {
        return -1;
    }

    protected int writePIData(String data) throws IOException, XMLStreamException {
        return -1;
    }

    protected void writeTextContent(String data) throws IOException {
    }

    protected void writeTextContent(char[] cbuf, int start, int len) throws IOException {
    }

    protected void throwInvalidAsciiChar(int c) throws IOException {
        this.flush();
        throw new IOException("Invalid XML character (0x" + Integer.toHexString(c) + "); can only be output using character entity when using Ascii encoding");
    }
}

