/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public abstract class EncodingXmlWriter
extends XmlWriter {
    static final int DEFAULT_BUFFER_SIZE = 4000;
    static final byte BYTE_SPACE = 32;
    static final byte BYTE_COLON = 58;
    static final byte BYTE_SEMICOLON = 59;
    static final byte BYTE_LBRACKET = 91;
    static final byte BYTE_RBRACKET = 93;
    static final byte BYTE_QMARK = 63;
    static final byte BYTE_EQ = 61;
    static final byte BYTE_SLASH = 47;
    static final byte BYTE_HASH = 35;
    static final byte BYTE_HYPHEN = 45;
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_AMP = 38;
    static final byte BYTE_QUOT = 34;
    static final byte BYTE_APOS = 39;
    static final byte BYTE_X = 120;
    protected final OutputStream mOut;
    protected final byte[] mOutputBuffer;
    protected int mOutputPtr;
    protected int mSurrogate = 0;

    public EncodingXmlWriter(OutputStream out, WriterConfig cfg, String encoding) throws IOException {
        super(cfg, encoding);
        this.mOut = out;
        this.mOutputBuffer = new byte[4000];
        this.mOutputPtr = 0;
    }

    protected int getOutputPtr() {
        return this.mOutputPtr;
    }

    public void close() throws IOException {
        this.mOut.close();
    }

    public final void flush() throws IOException {
        this.flushBuffer();
        this.mOut.flush();
    }

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException;

    public final void writeCDataStart() throws IOException {
        this.writeAscii("<![CDATA[");
    }

    public final void writeCDataEnd() throws IOException {
        this.writeAscii("]]>");
    }

    public final void writeCommentStart() throws IOException {
        this.writeAscii("<!--");
    }

    public final void writeCommentEnd() throws IOException {
        this.writeAscii("-->");
    }

    public final void writePIStart(String target, boolean addSpace) throws IOException {
        this.writeAscii((byte)60, (byte)63);
        this.writeRaw(target);
        if (addSpace) {
            this.writeAscii((byte)32);
        }
    }

    public final void writePIEnd() throws IOException {
        this.writeAscii((byte)63, (byte)62);
    }

    public int writeCData(String data) throws IOException {
        this.writeAscii("<![CDATA[");
        int ix = this.writeCDataContent(data);
        if (ix >= 0) {
            return ix;
        }
        this.writeAscii("]]>");
        return 0;
    }

    public int writeCData(char[] cbuf, int offset, int len) throws IOException {
        this.writeAscii("<![CDATA[");
        int ix = this.writeCDataContent(cbuf, offset, len);
        if (ix >= 0) {
            return ix;
        }
        this.writeAscii("]]>");
        return 0;
    }

    public final void writeCharacters(String data) throws IOException {
        if (this.mTextWriter != null) {
            this.mTextWriter.write(data);
        } else {
            this.writeTextContent(data);
        }
    }

    public final void writeCharacters(char[] cbuf, int offset, int len) throws IOException {
        if (this.mTextWriter != null) {
            this.mTextWriter.write(cbuf, offset, len);
        } else {
            this.writeTextContent(cbuf, offset, len);
        }
    }

    public int writeComment(String data) throws IOException {
        this.writeAscii("<!--");
        int ix = this.writeCommentContent(data);
        if (ix >= 0) {
            return ix;
        }
        this.writeAscii("-->");
        return 0;
    }

    public void writeDTD(String data) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        this.writeRaw(data, 0, data.length());
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws IOException, XMLStreamException {
        this.writeAscii("<!DOCTYPE ");
        this.writeAscii(rootName);
        if (systemId != null) {
            if (publicId != null) {
                this.writeAscii(" PUBLIC \"");
                this.writeRaw(publicId, 0, publicId.length());
                this.writeAscii("\" \"");
            } else {
                this.writeAscii(" SYSTEM \"");
            }
            this.writeRaw(systemId, 0, systemId.length());
            this.writeAscii((byte)34);
        }
        if (internalSubset != null && internalSubset.length() > 0) {
            this.writeAscii((byte)32, (byte)91);
            this.writeRaw(internalSubset, 0, internalSubset.length());
            this.writeAscii((byte)93);
        }
        this.writeAscii((byte)60);
    }

    public void writeEntityReference(String name) throws IOException, XMLStreamException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(name, this.mNsAware);
        }
        this.writeAscii((byte)38);
        this.writeName(name);
        this.writeAscii((byte)59);
    }

    public void writeXmlDeclaration(String version2, String encoding, String standalone) throws IOException {
        this.writeAscii("<?xml version='");
        this.writeAscii(version2);
        this.writeAscii((byte)39);
        if (encoding != null && encoding.length() > 0) {
            this.writeAscii(" encoding='");
            this.writeRaw(encoding, 0, encoding.length());
            this.writeAscii((byte)39);
        }
        if (standalone != null) {
            this.writeAscii(" standalone='");
            this.writeAscii(standalone);
            this.writeAscii((byte)39);
        }
        this.writeAscii((byte)63, (byte)62);
    }

    public int writePI(String target, String data) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(target, this.mNsAware);
        }
        this.writeAscii((byte)60, (byte)63);
        this.writeName(target);
        if (data != null && data.length() > 0) {
            this.writeAscii((byte)32);
            int ix = this.writePIData(data);
            if (ix >= 0) {
                return ix;
            }
        }
        this.writeAscii((byte)63, (byte)62);
        return 0;
    }

    public void writeStartTagStart(String prefix, String localName) throws IOException, XMLStreamException {
        this.writeAscii((byte)60);
        if (prefix != null && prefix.length() > 0) {
            if (this.mCheckNames) {
                this.verifyNameValidity(prefix, this.mNsAware);
            }
            this.writeName(prefix);
            this.writeAscii((byte)58);
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        this.writeName(localName);
    }

    public void writeStartTagEnd() throws IOException {
        this.writeAscii((byte)62);
    }

    public void writeStartTagEmptyEnd() throws IOException {
        this.writeAscii(" />");
    }

    public void writeEndTag(String prefix, String localName) throws IOException {
        this.writeAscii((byte)60, (byte)47);
        if (prefix != null && prefix.length() > 0) {
            this.writeName(prefix);
            this.writeAscii((byte)58);
        }
        this.writeName(localName);
        this.writeAscii((byte)62);
    }

    public void writeAttribute(String prefix, String localName, String value) throws IOException, XMLStreamException {
        this.writeAscii((byte)32);
        if (prefix != null && prefix.length() > 0) {
            if (this.mCheckNames) {
                this.verifyNameValidity(prefix, this.mNsAware);
            }
            this.writeName(prefix);
            this.writeAscii((byte)58);
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        this.writeName(localName);
        this.writeAscii((byte)61, (byte)34);
        int len = value.length();
        if (len > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(value, 0, len);
            } else {
                this.writeAttrValue(value);
            }
        }
        this.writeAscii((byte)34);
    }

    protected final void flushBuffer() throws IOException {
        if (this.mOutputPtr > 0) {
            int ptr = this.mOutputPtr;
            this.mOutputPtr = 0;
            this.mOut.write(this.mOutputBuffer, 0, ptr);
        }
    }

    protected final void writeAscii(byte b) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this.mOutputPtr >= this.mOutputBuffer.length) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = b;
    }

    protected final void writeAscii(byte b1, byte b2) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this.mOutputPtr + 1 >= this.mOutputBuffer.length) {
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = b1;
        this.mOutputBuffer[this.mOutputPtr++] = b2;
    }

    protected final void writeAscii(String str2) throws IOException {
        byte[] buf;
        int len;
        int ptr;
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((ptr = this.mOutputPtr) + (len = str2.length()) >= (buf = this.mOutputBuffer).length) {
            if (len > buf.length) {
                this.writeRaw(str2, 0, len);
                return;
            }
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        this.mOutputPtr += len;
        for (int i = 0; i < len; ++i) {
            buf[ptr++] = (byte)str2.charAt(i);
        }
    }

    protected final int writeAsEntity(int c) throws IOException {
        int ptr = this.mOutputPtr;
        byte[] buf = this.mOutputBuffer;
        if (ptr + 10 >= buf.length) {
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        buf[ptr++] = 38;
        buf[ptr++] = 35;
        buf[ptr++] = 120;
        if (c < 16) {
            buf[ptr++] = (byte)(c < 10 ? 48 + c : 87 + c);
        } else {
            int digits = c < 256 ? 2 : (c < 4096 ? 3 : (c < 65536 ? 4 : 6));
            ptr += digits;
            for (int i = 1; i <= digits; ++i) {
                int digit = c & 0xF;
                c >>= 4;
                buf[ptr - i] = (byte)(digit < 10 ? 48 + digit : 87 + digit);
            }
        }
        buf[ptr++] = 59;
        this.mOutputPtr = ptr;
        return ptr;
    }

    protected final void writeName(String str2) throws IOException {
        this.writeRaw(str2, 0, str2.length());
    }

    protected final int calcSurrogate(int secondSurr) throws IOException {
        if (secondSurr < 56320 || secondSurr > 57343) {
            this.throwUnpairedSurrogate();
        }
        int firstSurr = this.mSurrogate;
        this.mSurrogate = 0;
        int ch = 65536 + (firstSurr - 55296 << 10) + (secondSurr - 56320);
        if (ch > 0x10FFFF) {
            throw new IOException("Illegal surrogate character pair, resulting code 0x" + Integer.toHexString(ch) + " above legal XML character range");
        }
        return ch;
    }

    protected final void throwUnpairedSurrogate() throws IOException {
        int surr = this.mSurrogate;
        this.mSurrogate = 0;
        this.flush();
        throw new IOException("Unpaired surrogate character (0x" + Integer.toHexString(surr) + ")");
    }

    protected abstract void writeAttrValue(String var1) throws IOException, XMLStreamException;

    protected abstract int writeCDataContent(String var1) throws IOException;

    protected abstract int writeCDataContent(char[] var1, int var2, int var3) throws IOException;

    protected abstract int writeCommentContent(String var1) throws IOException;

    protected abstract int writePIData(String var1) throws IOException, XMLStreamException;

    protected abstract void writeTextContent(String var1) throws IOException;

    protected abstract void writeTextContent(char[] var1, int var2, int var3) throws IOException;
}

