/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.ImportManager;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.ModelExpansion;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.exceptions.NoSpecificTypeException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Set;

public class AssemblerHelp {
    public static Resource withFullModel(Resource root) {
        return (Resource)root.inModel(AssemblerHelp.fullModel(root.getModel()));
    }

    public static Model fullModel(Model m) {
        return AssemblerHelp.fullModel(ImportManager.instance, m);
    }

    public static Model fullModel(ImportManager im, Model m) {
        return m.contains(JA.This, RDF.type, JA.Expanded) ? m : (Model)ModelExpansion.withSchema(im.withImports(m), JA.getSchema()).add(JA.This, RDF.type, JA.Expanded).setNsPrefixes(PrefixMapping.Extended).setNsPrefixes(m);
    }

    public static void loadClasses(AssemblerGroup group, Model m) {
        RDFNode ANY = null;
        StmtIterator it = m.listStatements(null, JA.assembler, ANY);
        while (it.hasNext()) {
            AssemblerHelp.loadClass(group, it.nextStatement());
        }
    }

    private static void loadClass(AssemblerGroup group, Statement statement) {
        try {
            Resource type = statement.getSubject();
            Class<?> c = Class.forName(AssemblerHelp.getString(statement));
            Constructor con = AssemblerHelp.getResourcedConstructor(c);
            if (con == null) {
                AssemblerHelp.establish(group, type, c.newInstance());
            } else {
                AssemblerHelp.establish(group, type, con.newInstance(statement.getSubject()));
            }
        }
        catch (Exception e2) {
            throw new JenaException(e2);
        }
    }

    private static void establish(AssemblerGroup group, Resource type, Object x) {
        if (!(x instanceof Assembler)) {
            throw new JenaException("constructed entity is not an Assembler: " + x);
        }
        group.implementWith(type, (Assembler)x);
    }

    private static Constructor getResourcedConstructor(Class c) {
        try {
            return c.getConstructor(Resource.class);
        }
        catch (SecurityException e2) {
            return null;
        }
        catch (NoSuchMethodException e3) {
            return null;
        }
    }

    public static Resource findSpecificType(Resource root) {
        return AssemblerHelp.findSpecificType(root, JA.Object);
    }

    public static Resource findSpecificType(Resource root, Resource givenType) {
        Model desc = root.getModel();
        StmtIterator types = root.listProperties(RDF.type);
        ArrayList<Resource> results = new ArrayList<Resource>();
        while (types.hasNext()) {
            Resource type = AssemblerHelp.getResource(types.nextStatement());
            if (!desc.contains(type, RDFS.subClassOf, givenType)) continue;
            boolean allowed = true;
            StmtIterator subs = desc.listStatements(null, RDFS.subClassOf, type);
            while (subs.hasNext()) {
                Resource sub = subs.nextStatement().getSubject();
                if (((Object)sub).equals(type) || !root.hasProperty(RDF.type, sub)) continue;
                allowed = false;
            }
            if (!allowed) continue;
            results.add(type);
        }
        if (results.size() == 1) {
            return (Resource)results.get(0);
        }
        if (results.size() == 0) {
            return givenType;
        }
        throw new NoSpecificTypeException(root, results);
    }

    public static Resource getResource(Statement s) {
        RDFNode ob = s.getObject();
        if (ob.isLiteral()) {
            throw new BadObjectException(s);
        }
        return (Resource)ob;
    }

    public static String getString(Statement s) {
        RDFNode ob = s.getObject();
        if (ob.isResource()) {
            throw new BadObjectException(s);
        }
        Literal L = (Literal)ob;
        if (!L.getLanguage().equals("")) {
            throw new BadObjectException(s);
        }
        if (L.getDatatype() == null) {
            return L.getLexicalForm();
        }
        if (L.getDatatype() == XSDDatatype.XSDstring) {
            return L.getLexicalForm();
        }
        throw new BadObjectException(s);
    }

    public static String getString(Statement s, Literal L) {
        if (!L.getLanguage().equals("")) {
            throw new BadObjectException(s);
        }
        if (L.getDatatype() == null) {
            return L.getLexicalForm();
        }
        if (L.getDatatype() == XSDDatatype.XSDstring) {
            return L.getLexicalForm();
        }
        throw new BadObjectException(s);
    }

    public static Set findAssemblerRoots(Model model) {
        return AssemblerHelp.findAssemblerRoots(model, JA.Object);
    }

    public static Set findAssemblerRoots(Model model, Resource type) {
        return AssemblerHelp.fullModel(model).listSubjectsWithProperty(RDF.type, type).toSet();
    }

    public static Resource singleModelRoot(Model singleRoot) {
        return AssemblerHelp.singleRoot(singleRoot, JA.Model);
    }

    public static Resource singleRoot(Model singleRoot, Resource type) {
        Set roots = AssemblerHelp.findAssemblerRoots(singleRoot, type);
        if (roots.size() == 1) {
            return (Resource)roots.iterator().next();
        }
        if (roots.size() == 0) {
            throw new BadDescriptionNoRootException(singleRoot, type);
        }
        throw new BadDescriptionMultipleRootsException(singleRoot, type);
    }
}

