/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;

public class ConnectionDescription {
    public final String subject;
    public final String dbURL;
    public final String dbUser;
    public final String dbPassword;
    public final String dbType;
    protected IDBConnection connection;

    public ConnectionDescription(String subject, String dbURL, String dbUser, String dbPassword, String dbType) {
        this.subject = subject;
        this.dbURL = dbURL;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
        this.dbType = dbType;
    }

    public IDBConnection getConnection() {
        if (this.connection == null) {
            if (this.dbURL == null || this.dbType == null) {
                throw new JenaException("this connection " + this + " cannot be opened because no dbURL or dbType was specified");
            }
            this.connection = ModelFactory.createSimpleRDBConnection(this.dbURL, this.dbUser, this.dbPassword, this.dbType);
        }
        return this.connection;
    }

    public static ConnectionDescription create(String subject, String dbURL, String dbUser, String dbPassword, String dbType) {
        return new ConnectionDescription(subject, dbURL, dbUser, dbPassword, dbType);
    }

    public String toString() {
        return "UrlConnection( subject=" + this.subject + " url=" + this.dbURL + " type=" + this.dbType + " user=" + this.dbUser + " password=" + this.dbPassword + (this.connection == null ? " unopened" : " opened") + ")";
    }
}

