/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestMultiUnion
extends AbstractTestGraph {
    public TestMultiUnion(String s) {
        super(s);
    }

    public static TestSuite suite() {
        return new TestSuite(TestMultiUnion.class);
    }

    public Graph getGraph() {
        Graph gBase = TestMultiUnion.graphWith("");
        Graph g1 = TestMultiUnion.graphWith("");
        return new MultiUnion(new Graph[]{gBase, g1});
    }

    public void testEmptyGraph() {
        MultiUnion m = new MultiUnion();
        Graph g0 = TestMultiUnion.graphWith("x p y");
        TestMultiUnion.assertEquals("Empty model should have size zero", 0, m.size());
        TestMultiUnion.assertFalse("Empty model should not contain another graph", m.dependsOn(g0));
    }

    public void testGraphSize1() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph g2 = TestMultiUnion.graphWith("x p y; z p a");
        MultiUnion m01 = new MultiUnion(new Graph[]{g0, g1});
        MultiUnion m10 = new MultiUnion(new Graph[]{g1, g0});
        MultiUnion m12 = new MultiUnion(new Graph[]{g1, g2});
        MultiUnion m21 = new MultiUnion(new Graph[]{g2, g1});
        MultiUnion m02 = new MultiUnion(new Graph[]{g0, g2});
        MultiUnion m20 = new MultiUnion(new Graph[]{g2, g0});
        MultiUnion m00 = new MultiUnion(new Graph[]{g0, g0});
        int s0 = g0.size();
        int s1 = g1.size();
        int s2 = g2.size();
        TestMultiUnion.assertEquals("Size of union of g0 and g1 not correct", s0 + s1, m01.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g0 not correct", s0 + s1, m10.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g2 not correct", s1 + s2, m12.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g1 not correct", s1 + s2, m21.size());
        TestMultiUnion.assertEquals("Size of union of g0 and g2 not correct", s0 + s2 - 1, m02.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g0 not correct", s0 + s2 - 1, m20.size());
        TestMultiUnion.assertEquals("Size of union of g0 with itself not correct", s0, m00.size());
    }

    public void testGraphSize2() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph g2 = TestMultiUnion.graphWith("x p y; z p a");
        MultiUnion m01 = new MultiUnion(this.iterateOver(g0, g1));
        MultiUnion m10 = new MultiUnion(this.iterateOver(g1, g0));
        MultiUnion m12 = new MultiUnion(this.iterateOver(g1, g2));
        MultiUnion m21 = new MultiUnion(this.iterateOver(g2, g1));
        MultiUnion m02 = new MultiUnion(this.iterateOver(g0, g2));
        MultiUnion m20 = new MultiUnion(this.iterateOver(g2, g0));
        MultiUnion m00 = new MultiUnion(this.iterateOver(g0, g0));
        int s0 = g0.size();
        int s1 = g1.size();
        int s2 = g2.size();
        TestMultiUnion.assertEquals("Size of union of g0 and g1 not correct", s0 + s1, m01.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g0 not correct", s0 + s1, m10.size());
        TestMultiUnion.assertEquals("Size of union of g1 and g2 not correct", s1 + s2, m12.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g1 not correct", s1 + s2, m21.size());
        TestMultiUnion.assertEquals("Size of union of g0 and g2 not correct", s0 + s2 - 1, m02.size());
        TestMultiUnion.assertEquals("Size of union of g2 and g0 not correct", s0 + s2 - 1, m20.size());
        TestMultiUnion.assertEquals("Size of union of g0 with itself not correct", s0, m00.size());
    }

    public void testGraphAddSize() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph g2 = TestMultiUnion.graphWith("x p y; z p a");
        int s0 = g0.size();
        int s1 = g1.size();
        int s2 = g2.size();
        MultiUnion m0 = new MultiUnion(new Graph[]{g0});
        TestMultiUnion.assertEquals("Size of union of g0 not correct", s0, m0.size());
        m0.addGraph(g1);
        TestMultiUnion.assertEquals("Size of union of g1 and g0 not correct", s0 + s1, m0.size());
        m0.addGraph(g2);
        TestMultiUnion.assertEquals("Size of union of g0, g1 and g2 not correct", s0 + s1 + s2 - 1, m0.size());
        m0.removeGraph(g1);
        TestMultiUnion.assertEquals("Size of union of g0 and g2 not correct", s0 + s2 - 1, m0.size());
        m0.removeGraph(g0);
        TestMultiUnion.assertEquals("Size of union of g2 not correct", s2, m0.size());
        m0.removeGraph(g0);
        TestMultiUnion.assertEquals("Size of union of g2 not correct", s2, m0.size());
        m0.removeGraph(g2);
        TestMultiUnion.assertEquals("Size of empty union not correct", 0, m0.size());
    }

    public void testAdd() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        Graph g2 = TestMultiUnion.graphWith("x p y; z p a");
        MultiUnion m = new MultiUnion(new Graph[]{g0, g1});
        int s0 = g0.size();
        int s1 = g1.size();
        int s2 = g2.size();
        int m0 = m.size();
        m.add(TestMultiUnion.triple("a q b"));
        TestMultiUnion.assertEquals("m.size should have increased by one", m0 + 1, m.size());
        TestMultiUnion.assertEquals("g0.size should have increased by one", s0 + 1, g0.size());
        TestMultiUnion.assertEquals("g1 size should be constant", s1, g1.size());
        m.setBaseGraph(g1);
        s0 = g0.size();
        s1 = g1.size();
        s2 = g2.size();
        m0 = m.size();
        m.add(TestMultiUnion.triple("a1 q b1"));
        TestMultiUnion.assertEquals("m.size should have increased by one", m0 + 1, m.size());
        TestMultiUnion.assertEquals("g0 size should be constant", s0, g0.size());
        TestMultiUnion.assertEquals("g1.size should have increased by one", s1 + 1, g1.size());
        boolean expected = false;
        try {
            m.setBaseGraph(g2);
        }
        catch (IllegalArgumentException e2) {
            expected = true;
        }
        TestMultiUnion.assertTrue("Should not have been able to make g2 the updater", expected);
    }

    public void testDelete() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        MultiUnion m = new MultiUnion(new Graph[]{g0, g1});
        this.checkDeleteSizes(1, 2, 3, g0, g1, m);
        m.delete(TestMultiUnion.triple("x p y"));
        this.checkDeleteSizes(0, 2, 2, g0, g1, m);
        m.delete(TestMultiUnion.triple("x p y"));
        this.checkDeleteSizes(0, 2, 2, g0, g1, m);
        m.setBaseGraph(g1);
        m.delete(TestMultiUnion.triple("x p z"));
        this.checkDeleteSizes(0, 1, 1, g0, g1, m);
        m.delete(TestMultiUnion.triple("z p zz"));
        this.checkDeleteSizes(0, 0, 0, g0, g1, m);
    }

    public void testContains() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        MultiUnion m = new MultiUnion(new Graph[]{g0, g1});
        TestMultiUnion.assertTrue("m should contain triple", m.contains(TestMultiUnion.triple("x p y ")));
        TestMultiUnion.assertTrue("m should contain triple", m.contains(TestMultiUnion.triple("x p z ")));
        TestMultiUnion.assertTrue("m should contain triple", m.contains(TestMultiUnion.triple("z p zz ")));
        TestMultiUnion.assertFalse("m should not contain triple", m.contains(TestMultiUnion.triple("zz p z ")));
    }

    public void testModel() {
        Graph g0 = TestMultiUnion.graphWith("x p y");
        MultiUnion u = new MultiUnion(new Graph[]{g0});
        Model m = ModelFactory.createModelForGraph(u);
        TestMultiUnion.assertEquals("Model size not correct", 1L, m.size());
        Graph g1 = TestMultiUnion.graphWith("x p z; z p zz");
        u.addGraph(g1);
        TestMultiUnion.assertEquals("Model size not correct", 3L, m.size());
        m.read("file:testing/ontology/list0.rdf");
        TestMultiUnion.assertEquals("Model size not correct", 4L, m.size());
    }

    protected void checkDeleteSizes(int s0, int s1, int m0, Graph g0, Graph g1, Graph m) {
        TestMultiUnion.assertEquals("Delete check: g0 size", s0, g0.size());
        TestMultiUnion.assertEquals("Delete check: g1 size", s1, g1.size());
        TestMultiUnion.assertEquals("Delete check: m size", m0, m.size());
    }

    protected Iterator iterateOver(Object x0) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(x0);
        return l.iterator();
    }

    protected Iterator iterateOver(Object x0, Object x1) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(x0);
        l.add(x1);
        return l.iterator();
    }

    protected Iterator iterateOver(Object x0, Object x1, Object x2) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(x0);
        l.add(x1);
        l.add(x2);
        return l.iterator();
    }
}

