/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import java.util.HashSet;
import junit.framework.TestSuite;

public class TestQueryNode
extends QueryTestBase {
    public static final QueryNodeFactory F = QueryNode.factory;

    public TestQueryNode(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQueryNode.class);
    }

    public void testNoIndex() {
        TestQueryNode.assertTrue(true);
    }

    public void testFixed() {
        Node fixed = Node.create("fixed");
        QueryNode.Fixed n = new QueryNode.Fixed(fixed);
        TestQueryNode.assertSame(fixed, n.node);
        TestQueryNode.assertEquals(-1, n.index);
        TestQueryNode.assertEquals(false, n.mustMatch());
        TestQueryNode.assertSame(fixed, ((QueryNode)n).finder(null));
    }

    public void testBind() {
        int index = 7;
        Node bind = Node.create("?bind");
        QueryNode.Bind n = new QueryNode.Bind(bind, 7);
        TestQueryNode.assertSame(bind, n.node);
        TestQueryNode.assertEquals(7, n.index);
        TestQueryNode.assertEquals(true, ((QueryNode)n).mustMatch());
        TestQueryNode.assertSame(Node.ANY, n.finder(null));
    }

    public void testBound() {
        this.testBoundAt(0);
        this.testBoundAt(3);
        this.testBoundAt(7);
    }

    protected void testBoundAt(int index) {
        Node bound = Node.create("?bound");
        QueryNode.Bound n = new QueryNode.Bound(bound, index);
        TestQueryNode.assertSame(bound, n.node);
        TestQueryNode.assertEquals(index, n.index);
        TestQueryNode.assertEquals(false, n.mustMatch());
        Domain d = new Domain(index + 1);
        Node item = Node.create("'anItem'");
        d.setElement(index, item);
        TestQueryNode.assertSame(item, ((QueryNode)n).finder(d));
    }

    public void testJustBound() {
        boolean index = true;
        Node just = Node.create("?jBound");
        QueryNode.JustBound n = new QueryNode.JustBound(just, 1);
        TestQueryNode.assertSame(just, n.node);
        TestQueryNode.assertEquals(1, n.index);
        TestQueryNode.assertEquals(true, ((QueryNode)n).mustMatch());
        TestQueryNode.assertEquals(Node.ANY, n.finder(null));
    }

    public void testAny() {
        QueryNode.Any n = new QueryNode.Any();
        TestQueryNode.assertSame(Node.ANY, n.node);
        TestQueryNode.assertEquals(-1, n.index);
        TestQueryNode.assertEquals(false, n.mustMatch());
        TestQueryNode.assertSame(Node.ANY, n.finder(null));
    }

    public void testClassifyFixed() {
        Node fixed = Node.create("someURI");
        QueryNode n = QueryNode.classify(F, null, null, fixed);
        TestQueryNode.assertInstanceOf(QueryNode.Fixed.class, n);
        TestQueryNode.assertEquals(-1, n.index);
        TestQueryNode.assertSame(fixed, n.node);
    }

    public void testClassifyAny() {
        QueryNode n = QueryNode.classify(F, null, null, Node.ANY);
        TestQueryNode.assertInstanceOf(QueryNode.Any.class, n);
        TestQueryNode.assertEquals(-1, n.index);
        TestQueryNode.assertSame(Node.ANY, n.node);
    }

    public void testClassifyFirstBind() {
        Mapping m = new Mapping(new Node[0]);
        this.testClassifyBind(Node.create("?bind"), m, 0);
    }

    public void testClassifySecondBind() {
        Mapping m = new Mapping(new Node[0]);
        m.newIndex(Node.create("?other"));
        this.testClassifyBind(Node.create("?bind"), m, 1);
    }

    protected void testClassifyBind(Node bind, Mapping m, int index) {
        QueryNode n = QueryNode.classify(F, m, new HashSet(), bind);
        TestQueryNode.assertInstanceOf(QueryNode.Bind.class, n);
        TestQueryNode.assertSame(n.node, bind);
        TestQueryNode.assertEquals(index, n.index);
    }

    public void testClassifyBound() {
        this.testClassifyBound(0);
        this.testClassifyBound(1);
        this.testClassifyBound(4);
        this.testClassifyBound(17);
    }

    protected void testClassifyBound(int index) {
        Node bound = Node.create("?bound");
        Mapping m = this.getPreloadedMapping(index);
        m.newIndex(bound);
        QueryNode n = QueryNode.classify(F, m, new HashSet(), bound);
        TestQueryNode.assertInstanceOf(QueryNode.Bound.class, n);
        TestQueryNode.assertSame(n.node, bound);
        TestQueryNode.assertEquals(index, n.index);
    }

    public void testClassifyJustBound() {
        this.testClassifyJustBound(0);
        this.testClassifyJustBound(1);
        this.testClassifyJustBound(17);
        this.testClassifyJustBound(42);
    }

    protected void testClassifyJustBound(int index) {
        Node recent = Node.create("?recent");
        Mapping m = this.getPreloadedMapping(index);
        m.newIndex(recent);
        HashSet<Node> withRecent = new HashSet<Node>();
        withRecent.add(recent);
        QueryNode n = QueryNode.classify(F, m, withRecent, recent);
        TestQueryNode.assertInstanceOf(QueryNode.JustBound.class, n);
        TestQueryNode.assertSame(recent, n.node);
        TestQueryNode.assertEquals(index, n.index);
    }

    public void testBindingSetsJustBound() {
        Node X = Node.create("?X");
        Mapping m = this.getPreloadedMapping(0);
        HashSet s = new HashSet();
        QueryNode n = QueryNode.classify(F, m, s, X);
        TestQueryNode.assertTrue(s.contains(X));
    }

    public void testBindingSetsJustBoundTwice() {
        Node X = Node.create("?X");
        Node Y2 = Node.create("?Y");
        Mapping m = this.getPreloadedMapping(0);
        HashSet s = new HashSet();
        QueryNode.classify(F, m, s, X);
        QueryNode.classify(F, m, s, Y2);
        TestQueryNode.assertTrue(s.contains(X));
        TestQueryNode.assertTrue(s.contains(Y2));
    }

    protected Mapping getPreloadedMapping(int count) {
        Mapping m = new Mapping(new Node[0]);
        for (int i = 0; i < count; ++i) {
            m.newIndex(Node.create("?bound-" + i));
        }
        return m;
    }

    public void testMatchFixed() {
        Node fixed = Node.create("_anon");
        QueryNode.Fixed n = new QueryNode.Fixed(fixed);
        try {
            n.match(null, Node.create("named"));
            TestQueryNode.fail("Fixed should not be matching");
        }
        catch (QueryNode.MustNotMatchException e2) {
            TestQueryNode.pass();
        }
    }

    public void testMatchBound() {
        Node bound = Node.create("?xx");
        QueryNode.Bound n = new QueryNode.Bound(bound, 1);
        try {
            n.match(null, Node.create("_anon"));
            TestQueryNode.fail("Bound should not be matching");
        }
        catch (QueryNode.MustNotMatchException e2) {
            TestQueryNode.pass();
        }
    }

    public void testMatchAny() {
        QueryNode.Any n = new QueryNode.Any();
        try {
            n.match(null, Node.create("17"));
            TestQueryNode.fail("Any should not be matching");
        }
        catch (QueryNode.MustNotMatchException e2) {
            TestQueryNode.pass();
        }
    }

    public void testMatchBind() {
        Node v = Node.create("?v");
        Node x = Node.create("elephant");
        Node y = Node.create("hedgehog");
        QueryNode.Bind n = new QueryNode.Bind(v, 1);
        Domain d = new Domain(3);
        TestQueryNode.assertTrue(((QueryNode)n).match(d, x));
        TestQueryNode.assertSame(x, d.getElement(n.index));
        TestQueryNode.assertTrue(((QueryNode)n).match(d, y));
        TestQueryNode.assertSame(y, d.getElement(n.index));
    }

    public void testMatchJustBound() {
        Node v = Node.create("?who");
        Node A = Node.create("A");
        Node B = Node.create("B");
        QueryNode.JustBound n = new QueryNode.JustBound(v, 1);
        Domain d = new Domain(3);
        d.setElement(n.index, A);
        TestQueryNode.assertTrue(((QueryNode)n).match(d, A));
        TestQueryNode.assertFalse(((QueryNode)n).match(d, B));
        d.setElement(n.index, B);
        TestQueryNode.assertFalse(((QueryNode)n).match(d, A));
        TestQueryNode.assertTrue(((QueryNode)n).match(d, B));
    }
}

