/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.Set;
import junit.framework.TestSuite;

public class TestFindLiterals
extends GraphTestBase {
    static final Map1 getObject = new Map1(){

        public Object map1(Object o) {
            return ((Triple)o).getObject();
        }
    };

    public TestFindLiterals(String name) {
        super(name);
    }

    public static TestFindLiterals aTest(final String graph, final String size, final String search, final String results) {
        return new TestFindLiterals("TestFindLiterals: graph {" + graph + "} size " + size + " search " + search + " expecting {" + results + "}"){

            public void runBare() {
                Graph g = 2.graphWith(graph);
                int n = Integer.parseInt(size);
                Node literal = Node.create(search);
                2.assertEquals("graph has wrong size", n, g.size());
                Set got = 2.iteratorToSet(g.find(Node.ANY, Node.ANY, literal).mapWith(getObject));
                2.assertEquals(this.nodeSet(results), got);
            }
        };
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite(TestFindLiterals.class);
        result.addTest(TestFindLiterals.aTest("a P 'simple'", "1", "'simple'", "'simple'"));
        result.addTest(TestFindLiterals.aTest("a P 'simple'xsd:string", "1", "'simple'", "'simple'xsd:string"));
        result.addTest(TestFindLiterals.aTest("a P 'simple'", "1", "'simple'xsd:string", "'simple'"));
        result.addTest(TestFindLiterals.aTest("a P 'simple'xsd:string", "1", "'simple'xsd:string", "'simple'xsd:string"));
        result.addTest(TestFindLiterals.aTest("a P 'simple'; a P 'simple'xsd:string", "2", "'simple'", "'simple' 'simple'xsd:string"));
        result.addTest(TestFindLiterals.aTest("a P 'simple'; a P 'simple'xsd:string", "2", "'simple'xsd:string", "'simple' 'simple'xsd:string"));
        result.addTest(TestFindLiterals.aTest("a P 1", "1", "1", "1"));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:float", "1", "'1'xsd:float", "'1'xsd:float"));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:double", "1", "'1'xsd:double", "'1'xsd:double"));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:float", "1", "'1'xsd:float", "'1'xsd:float"));
        result.addTest(TestFindLiterals.aTest("a P '1.1'xsd:float", "1", "'1'xsd:float", ""));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:double", "1", "'1'xsd:int", ""));
        result.addTest(TestFindLiterals.aTest("a P 'abc'rdf:XMLLiteral", "1", "'abc'", ""));
        result.addTest(TestFindLiterals.aTest("a P 'abc'", "1", "'abc'rdf:XMLLiteral", ""));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:float", "1", "'1'xsd:double", ""));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:double", "1", "'1'xsd:float", ""));
        result.addTest(TestFindLiterals.aTest("a P 1", "1", "'1'", ""));
        result.addTest(TestFindLiterals.aTest("a P 1", "1", "'1'xsd:integer", "'1'xsd:integer"));
        result.addTest(TestFindLiterals.aTest("a P 1", "1", "'1'", ""));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:short", "1", "'1'xsd:integer", "'1'xsd:short"));
        result.addTest(TestFindLiterals.aTest("a P '1'xsd:int", "1", "'1'xsd:integer", "'1'xsd:int"));
        return result;
    }

    public void testFloatVsDouble() {
        Node A = Node.create("'1'xsd:float");
        Node B = Node.create("'1'xsd:double");
        TestFindLiterals.assertFalse(A.equals(B));
        TestFindLiterals.assertFalse(A.sameValueAs(B));
        TestFindLiterals.assertFalse(B.sameValueAs(A));
        TestFindLiterals.assertFalse(A.matches(B));
        TestFindLiterals.assertFalse(B.matches(A));
    }

    public void testProgrammaticValues() {
        Node ab = Node.createLiteral(new LiteralLabel(new Byte(42)));
        Node as = Node.createLiteral(new LiteralLabel(new Short(42)));
        Node ai = Node.createLiteral(new LiteralLabel(new Integer(42)));
        Node al = Node.createLiteral(new LiteralLabel(new Long(42L)));
        Graph g = TestFindLiterals.graphWith("");
        Node SB = Node.create("SB");
        Node SS = Node.create("SS");
        Node SI = Node.create("SI");
        Node SL = Node.create("SL");
        Node P = Node.create("P");
        g.add(Triple.create(SB, P, ab));
        g.add(Triple.create(SS, P, as));
        g.add(Triple.create(SI, P, ai));
        g.add(Triple.create(SL, P, al));
        TestFindLiterals.assertEquals(4, TestFindLiterals.iteratorToSet(g.find(Node.ANY, P, Node.create("42"))).size());
    }
}

