/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestNode
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);
    private static final AnonId A = AnonId.create();
    static String[] someURIs = new String[]{"http://domainy.thing/stuff/henry", "http://whatever.com/stingy-beast/bee", "ftp://erewhon/12345", "potatoe:rhubarb"};
    protected static String[] someNodes = new String[]{"42", "'hello'", "_anon", "'robotic'tick", "'teriffic'abc:def"};

    public TestNode(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNode.class);
    }

    public void testBlanks() {
        TestNode.assertTrue("anonymous nodes are blank", Node.createAnon().isBlank());
        TestNode.assertFalse("anonymous nodes aren't literal", Node.createAnon().isLiteral());
        TestNode.assertFalse("anonymous nodes aren't URIs", Node.createAnon().isURI());
        TestNode.assertFalse("anonymous nodes aren't variables", Node.createAnon().isVariable());
        TestNode.assertEquals("anonymous nodes have the right id", Node.createAnon(A).getBlankNodeId(), A);
    }

    public void testLiterals() {
        TestNode.assertFalse("literal nodes aren't blank", Node.createLiteral(L).isBlank());
        TestNode.assertTrue("literal nodes are literal", Node.createLiteral(L).isLiteral());
        TestNode.assertFalse("literal nodes aren't variables", Node.createLiteral(L).isVariable());
        TestNode.assertFalse("literal nodes aren't URIs", Node.createLiteral(L).isURI());
        TestNode.assertEquals("literal nodes preserve value", Node.createLiteral(L).getLiteral(), L);
    }

    public void testURIs() {
        TestNode.assertFalse("URI nodes aren't blank", Node.createURI(U).isBlank());
        TestNode.assertFalse("URI nodes aren't literal", Node.createURI(U).isLiteral());
        TestNode.assertFalse("URI nodes aren't variables", Node.createURI(U).isVariable());
        TestNode.assertTrue("URI nodes are URIs", Node.createURI(U).isURI());
        TestNode.assertEquals("URI nodes preserve URI", Node.createURI(U).getURI(), U);
    }

    public void testVariables() {
        TestNode.assertFalse("variable nodes aren't blank", Node.createVariable(N).isBlank());
        TestNode.assertFalse("variable nodes aren't literal", Node.createVariable(N).isLiteral());
        TestNode.assertFalse("variable nodes aren't URIs", Node.createVariable(N).isURI());
        TestNode.assertTrue("variable nodes are variable", Node.createVariable(N).isVariable());
        TestNode.assertEquals("variable nodes keep their name", N, Node.createVariable(N).getName());
        TestNode.assertEquals("variable nodes keep their name", "Alicex", Node.createVariable("Alicex").getName());
    }

    public void testANY() {
        TestNode.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
        TestNode.assertFalse("ANY nodes aren't literals", Node.ANY.isLiteral());
        TestNode.assertFalse("ANY nodes aren't URIs", Node.ANY.isURI());
        TestNode.assertFalse("ANY nodes aren't variables", Node.ANY.isVariable());
        TestNode.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
        TestNode.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
    }

    public void testNodeVariableConstructor() {
        TestNode.assertEquals(Node.createVariable("hello"), new Node_Variable("hello"));
        TestNode.assertEquals(Node.createVariable("world"), new Node_Variable("world"));
        TestNode.assertDiffer(Node.createVariable("hello"), new Node_Variable("world"));
        TestNode.assertEquals("myName", new Node_Variable("myName").getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] eqTestCases() {
        try {
            Node.cache(false);
            AnonId id = AnonId.create();
            LiteralLabel L2 = new LiteralLabel(id.toString(), "", false);
            LiteralLabel LLang1 = new LiteralLabel((Object)"xyz", "en", null);
            LiteralLabel LLang2 = new LiteralLabel((Object)"xyz", "EN", null);
            String U2 = id.toString();
            String N2 = id.toString();
            Object[][] objectArray = new Object[][]{{Node.ANY, "0"}, {Node.createAnon(id), "1"}, {Node.createAnon(), "2"}, {Node.createAnon(id), "1"}, {Node.createLiteral(L), "3"}, {Node.createLiteral(L2), "4"}, {Node.createLiteral(L), "3"}, {Node.createURI(U), "5"}, {Node.createURI(U2), "6"}, {Node.createURI(U), "5"}, {Node.createVariable(N), "7"}, {Node.createVariable(N2), "8"}, {Node.createVariable(N), "7"}, {Node.createLiteral(LLang1), "9"}, {Node.createLiteral(LLang2), "10"}};
            return objectArray;
        }
        finally {
            Node.cache(true);
        }
    }

    public void testNodeEquals() {
        Object[][] tests = this.eqTestCases();
        for (int i = 0; i < tests.length; ++i) {
            Object[] I = tests[i];
            TestNode.assertFalse(I[0] + " should not equal null", I[0].equals(null));
            TestNode.assertFalse(I[0] + "should not equal 'String'", I[0].equals("String"));
            for (int j = 0; j < tests.length; ++j) {
                Object[] J = tests[j];
                this.testEquality(I[1].equals(J[1]), I[0], J[0]);
            }
        }
    }

    private void testEquality(boolean testEq, Object x, Object y) {
        String testName = this.getType(x) + " " + x + " and " + this.getType(y) + " " + y;
        if (testEq) {
            TestNode.assertEquals(testName + "should be equal", x, y);
        } else {
            TestNode.assertDiffer(testName + " should differ", x, y);
        }
    }

    private String getType(Object x) {
        String fullName = x.getClass().getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquals() {
        try {
            Node.cache(false);
            TestNode.assertDiffer("different variables", Node.createVariable("xx"), Node.createVariable("yy"));
            TestNode.assertEquals("same vars", Node.createVariable("aa"), Node.createVariable("aa"));
            TestNode.assertEquals("same URI", Node.createURI(U), Node.createURI(U));
            TestNode.assertEquals("same anon", Node.createAnon(A), Node.createAnon(A));
            TestNode.assertEquals("same literal", Node.createLiteral(L), Node.createLiteral(L));
            TestNode.assertFalse("distinct URIs", Node.createURI(U) == Node.createURI(U));
            TestNode.assertFalse("distinct hyphens", Node.createAnon(A) == Node.createAnon(A));
            TestNode.assertFalse("distinct literals", Node.createLiteral(L) == Node.createLiteral(L));
            TestNode.assertFalse("distinct vars", Node.createVariable("aa") == Node.createVariable("aa"));
        }
        finally {
            Node.cache(true);
        }
    }

    public void testLabels() {
        AnonId id = AnonId.create();
        TestNode.assertEquals("get URI value", U, Node.createURI(U).getURI());
        TestNode.assertEquals("get blank value", id, Node.createAnon(id).getBlankNodeId());
        TestNode.assertEquals("get literal value", L, Node.createLiteral(L).getLiteral());
        TestNode.assertEquals("get variable name", N, Node.createVariable(N).getName());
    }

    public void testFailingLabels() {
        Node u = Node.createURI(U);
        Node b = Node.createAnon();
        Node l = Node.createLiteral(L);
        Node v = Node.createVariable(N);
        Node a = Node.ANY;
        this.testGetURIFails(a);
        this.testGetURIFails(b);
        this.testGetURIFails(l);
        this.testGetURIFails(v);
        this.testGetLiteralFails(a);
        this.testGetLiteralFails(u);
        this.testGetLiteralFails(b);
        this.testGetLiteralFails(v);
        this.testGetNameFails(a);
        this.testGetNameFails(u);
        this.testGetNameFails(b);
        this.testGetNameFails(l);
        this.testGetBlankNodeIdFails(a);
        this.testGetBlankNodeIdFails(u);
        this.testGetBlankNodeIdFails(l);
        this.testGetBlankNodeIdFails(v);
    }

    public void testGetBlankNodeIdFails(Node n) {
        try {
            n.getBlankNodeId();
            TestNode.fail(n.getClass() + " should fail getName()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetURIFails(Node n) {
        try {
            n.getURI();
            TestNode.fail(n.getClass() + " should fail getURI()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetNameFails(Node n) {
        try {
            n.getName();
            TestNode.fail(n.getClass() + " should fail getName()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetLiteralFails(Node n) {
        try {
            n.getLiteral();
            TestNode.fail(n.getClass() + " should fail getLiteral()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetBlankNodeLabelString() {
        Node n = Node.createAnon();
        TestNode.assertEquals(n.getBlankNodeId().getLabelString(), n.getBlankNodeLabel());
    }

    public void testVariableSupport() {
        TestNode.assertEquals(Node_Variable.variable("xxx"), Node_Variable.variable("xxx"));
        TestNode.assertDiffer(Node_Variable.variable("xxx"), Node_Variable.variable("yyy"));
        TestNode.assertEquals(Node_Variable.variable("aaa"), Node_Variable.variable("aaa"));
        TestNode.assertDiffer(Node_Variable.variable("aaa"), Node_Variable.variable("yyy"));
    }

    public void testCache() {
        TestNode.assertEquals(Node_Variable.variable("xxx"), Node_Variable.variable("xxx"));
        TestNode.assertTrue("remembers URI", Node.createURI(U) == Node.createURI(U));
        TestNode.assertTrue("remembers literal", Node.createLiteral(L) == Node.createLiteral(L));
        TestNode.assertTrue("remembers hyphens", Node.createAnon(A) == Node.createAnon(A));
        TestNode.assertTrue("remembers variables", Node.createVariable(N) == Node.createVariable(N));
        TestNode.assertFalse("is not confused", Node.createVariable(N) == Node.createURI(N));
    }

    public void testCreateBadString() {
        try {
            Node.create(null);
            TestNode.fail("must catch null argument");
        }
        catch (NullPointerException e2) {
        }
        catch (JenaException e3) {
            // empty catch block
        }
        try {
            Node.create("");
            TestNode.fail("must catch empty argument");
        }
        catch (JenaException jenaException) {
            // empty catch block
        }
    }

    public void testCreateAnon() {
        String idA = "_xxx";
        String idB = "_yyy";
        Node a = Node.create(idA);
        Node b = Node.create(idB);
        TestNode.assertTrue("both must be bnodes", a.isBlank() && b.isBlank());
        TestNode.assertEquals(new AnonId(idA), a.getBlankNodeId());
        TestNode.assertEquals(new AnonId(idB), b.getBlankNodeId());
    }

    public void testCreateVariable() {
        String V = "wobbly";
        Node v = Node.create("?" + V);
        TestNode.assertTrue("must be a variable", v.isVariable());
        TestNode.assertEquals("name must be correct", V, v.getName());
    }

    public void testCreateANY() {
        TestNode.assertEquals("?? must denote ANY", Node.ANY, Node.create("??"));
    }

    public void testCreatePlainLiteralSingleQuotes() {
        Node n = Node.create("'xxx'");
        TestNode.assertEquals("xxx", n.getLiteralLexicalForm());
        TestNode.assertEquals("", n.getLiteralLanguage());
        TestNode.assertEquals(null, n.getLiteralDatatypeURI());
    }

    public void testCreatePlainLiteralDoubleQuotes() {
        Node n = Node.create("\"xxx\"");
        TestNode.assertEquals("xxx", n.getLiteralLexicalForm());
        TestNode.assertEquals("", n.getLiteralLanguage());
        TestNode.assertEquals(null, n.getLiteralDatatypeURI());
    }

    public void testCreateLiteralBackslashEscape() {
        this.testStringConversion("xx\\x", "'xx\\\\x'");
        this.testStringConversion("xx\\x\\y", "'xx\\\\x\\\\y'");
        this.testStringConversion("\\xyz\\", "'\\\\xyz\\\\'");
    }

    public void testCreateLiteralQuoteEscapes() {
        this.testStringConversion("x'y", "'x\\'y'");
        this.testStringConversion("x\"y", "'x\\\"y'");
        this.testStringConversion("x'y\"z", "'x\\'y\\\"z'");
    }

    public void testCreateLiteralOtherEscapes() {
        this.testStringConversion(" ", "'\\s'");
        this.testStringConversion("\t", "'\\t'");
        this.testStringConversion("\n", "'\\n'");
    }

    protected void testStringConversion(String wanted, String template) {
        Node n = Node.create(template);
        TestNode.assertEquals(wanted, n.getLiteralLexicalForm());
        TestNode.assertEquals("", n.getLiteralLanguage());
        TestNode.assertEquals(null, n.getLiteralDatatypeURI());
    }

    public void testCreateLanguagedLiteralEN1() {
        Node n = Node.create("'chat'en-UK");
        TestNode.assertEquals("chat", n.getLiteralLexicalForm());
        TestNode.assertEquals("en-UK", n.getLiteralLanguage());
        TestNode.assertEquals(null, n.getLiteralDatatypeURI());
    }

    public void testCreateLanguagedLiteralEN2() {
        Node n1 = Node.create("'chat'en-UK");
        Node n2 = Node.create("'chat'EN-UK");
        TestNode.assertTrue(n1.sameValueAs(n2));
        TestNode.assertFalse(n1.equals(n2));
    }

    public void testCreateLanguagedLiteralXY() {
        Node n = Node.create("\"chat\"xy-AB");
        TestNode.assertEquals("chat", n.getLiteralLexicalForm());
        TestNode.assertEquals("xy-AB", n.getLiteralLanguage());
        TestNode.assertEquals(null, n.getLiteralDatatypeURI());
    }

    public void testCreateTypedLiteralInteger() {
        Node n = Node.create("'42'xsd:integer");
        TestNode.assertEquals("42", n.getLiteralLexicalForm());
        TestNode.assertEquals("", n.getLiteralLanguage());
        TestNode.assertEquals(this.expand("xsd:integer"), n.getLiteralDatatypeURI());
    }

    public void testCreateTypedLiteralBoolean() {
        Node n = Node.create("\"true\"xsd:boolean");
        TestNode.assertEquals("true", n.getLiteralLexicalForm());
        TestNode.assertEquals("", n.getLiteralLanguage());
        TestNode.assertEquals(this.expand("xsd:boolean"), n.getLiteralDatatypeURI());
    }

    public void testGetPlainLiteralLexicalForm() {
        Node n = Node.create("'stuff'");
        TestNode.assertEquals("stuff", n.getLiteralLexicalForm());
    }

    public void testGetNumericLiteralLexicalForm() {
        Node n = Node.create("17");
        TestNode.assertEquals("17", n.getLiteralLexicalForm());
    }

    public void testTypesExpandPrefix() {
        this.testTypeExpandsPrefix("rdf:spoo");
        this.testTypeExpandsPrefix("rdfs:bar");
        this.testTypeExpandsPrefix("owl:henry");
        this.testTypeExpandsPrefix("xsd:bool");
        this.testTypeExpandsPrefix("unknown:spoo");
    }

    private void testTypeExpandsPrefix(String type) {
        Node n = Node.create("'stuff'" + type);
        String wanted = PrefixMapping.Extended.expandPrefix(type);
        TestNode.assertEquals(wanted, n.getLiteralDatatypeURI());
    }

    public void testCreateURI() {
        String uri = "http://www.electric-hedgehog.net/";
        this.testCreateURI(uri);
        this.testCreateURI("rdf:trinket", "http://www.w3.org/1999/02/22-rdf-syntax-ns#trinket");
        this.testCreateURI("rdfs:device", "http://www.w3.org/2000/01/rdf-schema#device");
        this.testCreateURI("dc:creator", DC.getURI() + "creator");
        this.testCreateURI("rss:something", RSS.getURI() + "something");
        this.testCreateURI("vcard:TITLE", VCARD.getURI() + "TITLE");
        this.testCreateURI("owl:wol", OWL.NAMESPACE + "wol");
    }

    public void testCreateURIOtherMap() {
        String myNS = "eh:foo/bar#";
        String suffix = "something";
        PrefixMapping mine = PrefixMapping.Factory.create().setNsPrefix("mine", myNS);
        Node n = Node.create(mine, "mine:" + suffix);
        TestNode.assertEquals(myNS + suffix, n.getURI());
    }

    private void testCreateURI(String inOut) {
        this.testCreateURI(inOut, inOut);
    }

    private void testCreateURI(String in, String wanted) {
        String got = Node.create(in).getURI();
        if (!wanted.equals(got)) {
            if (in.equals(wanted)) {
                TestNode.fail("should preserve " + in);
            } else {
                TestNode.fail("should translate " + in + " to " + wanted + " not " + got);
            }
        }
    }

    public void testCreatePrefixed() {
        PrefixMapping pm = PrefixMapping.Factory.create();
        Node.create(pm, "xyz");
    }

    public void testToStringWithPrefixMapping() {
        PrefixMapping pm = PrefixMapping.Factory.create();
        String prefix = "spoo";
        String ns = "abc:def/ghi#";
        pm.setNsPrefix(prefix, ns);
        String suffix = "bamboozle";
        TestNode.assertEquals(prefix + ":" + suffix, Node.create(ns + suffix).toString(pm));
    }

    public void testNodeHelp() {
        TestNode.assertTrue("node() making URIs", TestNode.node("hello").isURI());
        TestNode.assertTrue("node() making literals", TestNode.node("123").isLiteral());
        TestNode.assertTrue("node() making literals", TestNode.node("'hello'").isLiteral());
        TestNode.assertTrue("node() making hyphens", TestNode.node("_x").isBlank());
        TestNode.assertTrue("node() making variables", TestNode.node("?x").isVariable());
    }

    public void testVisitorPatternNode() {
        NodeVisitor returnNode = new NodeVisitor(){

            public Object visitAny(Node_ANY it) {
                return it;
            }

            public Object visitBlank(Node_Blank it, AnonId id) {
                return it;
            }

            public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
                return it;
            }

            public Object visitURI(Node_URI it, String uri) {
                return it;
            }

            public Object visitVariable(Node_Variable it, String name) {
                return it;
            }
        };
        this.testVisitorPatternNode("sortOfURI", returnNode);
        this.testVisitorPatternNode("?variable", returnNode);
        this.testVisitorPatternNode("_anon", returnNode);
        this.testVisitorPatternNode("11", returnNode);
        this.testVisitorPatternNode("??", returnNode);
    }

    private void testVisitorPatternNode(String ns, NodeVisitor v) {
        Node n = TestNode.node(ns);
        TestNode.assertEquals(n, n.visitWith(v));
    }

    private void visitExamples(NodeVisitor nv) {
        TestNode.node("sortOfURI").visitWith(nv);
        TestNode.node("?variableI").visitWith(nv);
        TestNode.node("_anon").visitWith(nv);
        TestNode.node("11").visitWith(nv);
        TestNode.node("??").visitWith(nv);
    }

    public void testVisitorPatternValue() {
        NodeVisitor checkValue = new NodeVisitor(){

            public Object visitAny(Node_ANY it) {
                return null;
            }

            public Object visitBlank(Node_Blank it, AnonId id) {
                Assert.assertTrue(it.getBlankNodeId() == id);
                return null;
            }

            public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
                Assert.assertTrue(it.getLiteral() == lit);
                return null;
            }

            public Object visitURI(Node_URI it, String uri) {
                Assert.assertTrue(it.getURI() == uri);
                return null;
            }

            public Object visitVariable(Node_Variable it, String name) {
                Assert.assertEquals(it.getName(), name);
                return null;
            }
        };
        this.visitExamples(checkValue);
    }

    public void testVisitorPatternCalled() {
        final String[] strings = new String[]{""};
        NodeVisitor checkCalled = new NodeVisitor(){

            public Object visitAny(Node_ANY it) {
                strings[0] = strings[0] + " any";
                return null;
            }

            public Object visitBlank(Node_Blank it, AnonId id) {
                strings[0] = strings[0] + " blank";
                return null;
            }

            public Object visitLiteral(Node_Literal it, LiteralLabel lit) {
                strings[0] = strings[0] + " literal";
                return null;
            }

            public Object visitURI(Node_URI it, String uri) {
                strings[0] = strings[0] + " uri";
                return null;
            }

            public Object visitVariable(Node_Variable it, String name) {
                strings[0] = strings[0] + " variable";
                return null;
            }
        };
        String desired = " uri variable blank literal any";
        this.visitExamples(checkCalled);
        TestNode.assertEquals("all vists must have been made", desired, strings[0]);
    }

    public void testSimpleMatches() {
        TestNode.assertTrue(Node.create("S").matches(Node.create("S")));
        TestNode.assertFalse("", Node.create("S").matches(Node.create("T")));
        TestNode.assertFalse("", Node.create("S").matches(null));
        TestNode.assertTrue(Node.create("_X").matches(Node.create("_X")));
        TestNode.assertFalse("", Node.create("_X").matches(Node.create("_Y")));
        TestNode.assertFalse("", Node.create("_X").matches(null));
        TestNode.assertTrue(Node.create("10").matches(Node.create("10")));
        TestNode.assertFalse("", Node.create("10").matches(Node.create("11")));
        TestNode.assertFalse("", Node.create("10").matches(null));
        TestNode.assertTrue(Node.ANY.matches(Node.create("S")));
        TestNode.assertTrue(Node.ANY.matches(Node.create("_X")));
        TestNode.assertTrue(Node.ANY.matches(Node.create("10")));
        TestNode.assertFalse("", Node.ANY.matches(null));
    }

    public void testDataMatches() {
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dt1 = tm.getTypeByValue(new Integer(10));
        RDFDatatype dt2 = tm.getTypeByValue(new Short(10));
        Node a = Node.createLiteral("10", "", dt1);
        Node b = Node.createLiteral("10", "", dt2);
        TestNode.assertDiffer("types must make a difference", a, b);
        TestNode.assertTrue("A and B must express the same value", a.sameValueAs(b));
        TestNode.assertTrue("matching literals must respect sameValueAs", a.matches(b));
    }

    public void testLiteralToString() {
        TypeMapper tm = TypeMapper.getInstance();
        RDFDatatype dtInt = tm.getTypeByValue(new Integer(10));
        Node plain = Node.createLiteral("rhubarb", "", false);
        Node english = Node.createLiteral("eccentric", "en_UK", false);
        Node typed = Node.createLiteral("10", "", dtInt);
        TestNode.assertEquals("\"rhubarb\"", plain.toString());
        TestNode.assertEquals("rhubarb", plain.toString(false));
        TestNode.assertEquals("\"eccentric\"@en_UK", english.toString());
        TestNode.assertEquals("10^^http://www.w3.org/2001/XMLSchema#int", typed.toString(false));
    }

    public void testGetIndexingValueURI() {
        Node u = Node.create("eh:/telephone");
        TestNode.assertSame(u, u.getIndexingValue());
    }

    public void testGetIndexingValueBlank() {
        Node b = Node.create("_television");
        TestNode.assertSame(b, b.getIndexingValue());
    }

    public void testGetIndexingValuePlainString() {
        this.testIndexingValueLiteral(Node.create("'literally'"));
    }

    public void testGetIndexingValueLanguagedString() {
        this.testIndexingValueLiteral(Node.create("'chat'fr"));
    }

    public void testGetIndexingValueXSDString() {
        this.testIndexingValueLiteral(Node.create("'string'xsd:string"));
    }

    private void testIndexingValueLiteral(Node s) {
        TestNode.assertEquals(s.getLiteral().getIndexingValue(), s.getIndexingValue());
    }

    public void testGetLiteralValuePlainString() {
        Node s = Node.create("'aString'");
        TestNode.assertSame(s.getLiteral().getValue(), s.getLiteralValue());
    }

    public void testGetLiteralDatatypeNull() {
        TestNode.assertEquals(null, Node.create("'plain'").getLiteralDatatype());
    }

    public void testLiteralIsXML() {
        TestNode.assertFalse(Node.create("'notXML'").getLiteralIsXML());
        TestNode.assertFalse(Node.create("17").getLiteralIsXML());
        TestNode.assertFalse(Node.create("'joke'xsd:Joke").getLiteralIsXML());
        TestNode.assertTrue(Node.createLiteral("lit", "lang", true).getLiteralIsXML());
        TestNode.assertFalse(Node.createLiteral("lit", "lang", false).getLiteralIsXML());
    }

    public void testConcrete() {
        TestNode.assertTrue(Node.create("S").isConcrete());
        TestNode.assertTrue(Node.create("_P").isConcrete());
        TestNode.assertTrue(Node.create("11").isConcrete());
        TestNode.assertTrue(Node.create("'hello'").isConcrete());
        TestNode.assertFalse(Node.create("??").isConcrete());
        TestNode.assertFalse(Node.create("?x").isConcrete());
    }

    public void testNamespace() {
        for (int i = 0; i < someURIs.length; ++i) {
            String uri = someURIs[i];
            int split = Util.splitNamespace(uri);
            Node n = Node.create(uri);
            TestNode.assertEquals("check namespace", uri.substring(0, split), n.getNameSpace());
            TestNode.assertEquals("check localname", uri.substring(split), n.getLocalName());
        }
    }

    public void testHasURI() {
        int i;
        for (i = 0; i < someURIs.length; ++i) {
            this.testHasURI(someURIs[i]);
        }
        for (i = 0; i < someNodes.length; ++i) {
            this.testHasURI(someNodes[i]);
        }
    }

    protected void testHasURI(String uri) {
        Node n = Node.create(uri);
        TestNode.assertTrue(uri, !n.isURI() || n.hasURI(uri));
        TestNode.assertFalse(uri, n.hasURI(uri + "x"));
    }

    private String expand(String s) {
        return PrefixMapping.Extended.expandPrefix(s);
    }
}

