/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.Rational;
import com.hp.hpl.jena.graph.test.RationalType;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.impl.dv.util.HexBin;

public class TestTypedLiterals
extends TestCase {
    private Model m = ModelFactory.createDefaultModel();

    public TestTypedLiterals(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTypedLiterals.class);
    }

    public void testUnknown() {
        String typeURI = "urn:x-hp-dt:unknown";
        String typeURI2 = "urn:x-hp-dt:unknown2";
        boolean originalFlag = JenaParameters.enableSilentAcceptanceOfUnknownDatatypes;
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = true;
        Literal l1 = this.m.createTypedLiteral("foo", typeURI);
        Literal l3 = this.m.createTypedLiteral("15", typeURI);
        Literal l5 = this.m.createTypedLiteral("foo", typeURI2);
        Literal l6 = this.m.createLiteral("foo", "lang1");
        Literal l7 = this.m.createLiteral("foo");
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = originalFlag;
        TestTypedLiterals.assertNotNull(l1);
        TestTypedLiterals.assertNotNull(l3);
        TestTypedLiterals.assertNotNull(l5);
        this.assertDiffer("datatype sensitive", l1, l5);
        this.assertDiffer("value sensitive", l1, l3);
        this.assertDiffer("typed and plain differ", l1, l6);
        try {
            int i = l3.getInt();
            TestTypedLiterals.assertTrue("Allowed int conversion", false);
        }
        catch (DatatypeFormatException e2) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals("Extract value", l1.getValue(), new BaseDatatype.TypedValue("foo", typeURI));
        TestTypedLiterals.assertEquals("Extract xml tag", l1.isWellFormedXML(), false);
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = false;
        boolean foundException = false;
        try {
            Literal l8 = this.m.createTypedLiteral("food", typeURI + "3");
        }
        catch (DatatypeFormatException e2) {
            foundException = true;
        }
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = originalFlag;
        TestTypedLiterals.assertTrue("Detected unknown datatype", foundException);
        Date foo = new Date(123456L);
        LiteralLabel ll = new LiteralLabel(foo);
        TestTypedLiterals.assertEquals(ll.getLexicalForm(), ((Object)foo).toString());
    }

    public void testUserDef() {
        RDFDatatype rtype = RationalType.theRationalType;
        TypeMapper.getInstance().registerDatatype(rtype);
        Literal l1 = this.m.createTypedLiteral("3/5", rtype);
        Literal l3 = this.m.createTypedLiteral("7/5", rtype);
        TestTypedLiterals.assertNotNull(l1);
        TestTypedLiterals.assertNotNull(l3);
        this.assertDiffer("values should be tested!", l1, l3);
        TestTypedLiterals.assertSame("Datatype incorrect", l1.getDatatype(), rtype);
        TestTypedLiterals.assertEquals("Datatype uri incorrect", l1.getDatatypeURI(), "urn:x-hp-dt:rational");
        Object val = l1.getValue();
        TestTypedLiterals.assertTrue("Value space check", val instanceof Rational);
        TestTypedLiterals.assertTrue("Value check", ((Rational)val).getNumerator() == 3);
        TestTypedLiterals.assertTrue("Value check", ((Rational)val).getDenominator() == 5);
        try {
            int i = l1.getInt();
            TestTypedLiterals.assertTrue("Allowed int conversion", false);
        }
        catch (DatatypeFormatException e2) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals("Extract xml tag", l1.isWellFormedXML(), false);
    }

    public void testXMLLiteral() {
        Literal ll = this.m.createLiteral("<bad", true);
        TestTypedLiterals.assertTrue("Error checking must be off.", ((EnhNode)((Object)ll)).asNode().getLiteralIsXML());
        ll = this.m.createTypedLiteral("<bad/>", XMLLiteralType.theXMLLiteralType);
        TestTypedLiterals.assertFalse("Error checking must be on.", ((EnhNode)((Object)ll)).asNode().getLiteralIsXML());
        ll = this.m.createTypedLiteral("<good></good>", XMLLiteralType.theXMLLiteralType);
        TestTypedLiterals.assertTrue("Well-formed XMLLiteral.", ((EnhNode)((Object)ll)).asNode().getLiteralIsXML());
    }

    public void testXSDbasics() {
        String xsdIntURI = "http://www.w3.org/2001/XMLSchema#int";
        Literal l1 = this.m.createTypedLiteral(42);
        Literal l2 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDint);
        Literal l4 = this.m.createTypedLiteral("63");
        this.assertSameValueAs("Default map failed", l1, l2);
        TestTypedLiterals.assertEquals("Value wrong", l1.getValue(), new Integer(42));
        TestTypedLiterals.assertEquals("class wrong", l1.getValue().getClass(), Integer.class);
        TestTypedLiterals.assertEquals("Value accessor problem", l1.getInt(), 42);
        TestTypedLiterals.assertEquals("wrong type name", l2.getDatatypeURI(), xsdIntURI);
        TestTypedLiterals.assertEquals("wrong type", l2.getDatatype(), XSDDatatype.XSDint);
        this.assertDiffer("Not value sensitive", l1, l4);
        this.checkIllegalLiteral("zap", XSDDatatype.XSDint);
        this.checkIllegalLiteral("42.1", XSDDatatype.XSDint);
        Literal l5 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertSameValueAs("type coercion", l2, l5);
        l1 = this.m.createTypedLiteral(42.42);
        l2 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDfloat);
        Literal l3 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDdouble);
        TestTypedLiterals.assertEquals("class wrong", l1.getValue().getClass(), Double.class);
        this.assertFloatEquals("value wrong", ((Double)l1.getValue()).floatValue(), 42.42);
        TestTypedLiterals.assertEquals("class wrong", l2.getValue().getClass(), Float.class);
        this.assertFloatEquals("value wrong", ((Float)l2.getValue()).floatValue(), 42.42);
        this.assertFloatEquals("Value accessor problem", l1.getFloat(), 42.42);
        TestTypedLiterals.assertEquals("wrong type", l2.getDatatype(), XSDDatatype.XSDfloat);
        this.assertSameValueAs("equality fn", l1, l3);
        this.checkLegalLiteral("12345", XSDDatatype.XSDlong, Integer.class, new Integer(12345));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDlong, Integer.class, new Integer(-12345));
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDlong);
        this.checkLegalLiteral("1234", XSDDatatype.XSDshort, Integer.class, new Integer(1234));
        this.checkLegalLiteral("-1234", XSDDatatype.XSDshort, Integer.class, new Integer(-1234));
        this.checkLegalLiteral("32767", XSDDatatype.XSDshort, Integer.class, new Integer(Short.MAX_VALUE));
        this.checkLegalLiteral("-32768", XSDDatatype.XSDshort, Integer.class, new Integer(Short.MIN_VALUE));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDshort);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDshort);
        this.checkLegalLiteral("42", XSDDatatype.XSDbyte, Integer.class, new Integer(42));
        this.checkLegalLiteral("-42", XSDDatatype.XSDbyte, Integer.class, new Integer(-42));
        this.checkLegalLiteral("127", XSDDatatype.XSDbyte, Integer.class, new Integer(127));
        this.checkLegalLiteral("-128", XSDDatatype.XSDbyte, Integer.class, new Integer(-128));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("128", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDbyte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedLong, Integer.class, new Integer(12345));
        this.checkLegalLiteral("+12345", XSDDatatype.XSDunsignedLong, Integer.class, new Integer(12345));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDunsignedLong, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedLong);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedInt, Integer.class, new Integer(12345));
        this.checkLegalLiteral("2147483648", XSDDatatype.XSDunsignedInt, Long.class, new Long(0x80000000L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedInt);
        this.checkLegalLiteral("1234", XSDDatatype.XSDunsignedShort, Integer.class, new Integer(1234));
        this.checkLegalLiteral("32679", XSDDatatype.XSDunsignedShort, Integer.class, new Integer(32679));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedShort);
        this.checkLegalLiteral("123", XSDDatatype.XSDunsignedByte, Integer.class, new Integer(123));
        this.checkLegalLiteral("129", XSDDatatype.XSDunsignedByte, Integer.class, new Integer(129));
        this.checkIllegalLiteral("-123", XSDDatatype.XSDunsignedByte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDinteger, Integer.class, new Integer(12345));
        this.checkLegalLiteral("0", XSDDatatype.XSDinteger, Integer.class, new Integer(0));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDinteger, Integer.class, new Integer(-12345));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDinteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDpositiveInteger, Integer.class, new Integer(12345));
        this.checkIllegalLiteral("0", XSDDatatype.XSDpositiveInteger);
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDpositiveInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDpositiveInteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDnonNegativeInteger, Integer.class, new Integer(12345));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonNegativeInteger, Integer.class, new Integer(0));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDnonNegativeInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDnonNegativeInteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnegativeInteger, Integer.class, new Integer(-12345));
        this.checkIllegalLiteral("0", XSDDatatype.XSDnegativeInteger);
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnegativeInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnegativeInteger, BigInteger.class, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnonPositiveInteger, Integer.class, new Integer(-12345));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonPositiveInteger, Integer.class, new Integer(0));
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnonPositiveInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnonPositiveInteger, BigInteger.class, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDdecimal, Integer.class, new Integer("12345"));
        this.checkLegalLiteral("0.0", XSDDatatype.XSDdecimal, Integer.class, new Integer("0"));
        this.checkLegalLiteral("42.45", XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("42.45"));
        this.checkLegalLiteral("9223372036854775808.1234", XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("9223372036854775808.1234"));
        this.checkLegalLiteral("123.4", XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("123.4"));
        this.checkIllegalLiteral("123,4", XSDDatatype.XSDdecimal);
        this.checkLegalLiteral("true", XSDDatatype.XSDboolean, Boolean.class, new Boolean(true));
        this.checkLegalLiteral("false", XSDDatatype.XSDboolean, Boolean.class, new Boolean(false));
        l1 = this.m.createTypedLiteral(true);
        TestTypedLiterals.assertEquals("boolean mapping", XSDDatatype.XSDboolean, l1.getDatatype());
        this.checkLegalLiteral("hello world", XSDDatatype.XSDstring, String.class, "hello world");
        l1 = this.m.createTypedLiteral("foo bar");
        TestTypedLiterals.assertEquals("string mapping", XSDDatatype.XSDstring, l1.getDatatype());
    }

    public void testMiscEquality() {
        Literal l1 = this.m.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal l3 = this.m.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("Int lex form", l1, l3);
        l1 = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDint);
        l3 = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertSameValueAs("numeric comparisons", l1, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverloads() {
        boolean old = JenaParameters.enableEagerLiteralValidation;
        try {
            JenaParameters.enableEagerLiteralValidation = true;
            boolean test1 = false;
            try {
                Literal l1 = this.m.createTypedLiteral("foo", "http://www.w3.org/2001/XMLSchema#integer");
            }
            catch (DatatypeFormatException e1) {
                test1 = true;
            }
            TestTypedLiterals.assertTrue("detected illegal string, direct", test1);
            boolean test2 = false;
            try {
                String foo = "foo";
                Literal l1 = this.m.createTypedLiteral((Object)foo, "http://www.w3.org/2001/XMLSchema#integer");
            }
            catch (DatatypeFormatException e2) {
                test2 = true;
            }
            TestTypedLiterals.assertTrue("detected illegal string, overloaded", test2);
            GregorianCalendar testCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            testCal.set(1999, 4, 30, 15, 9, 32);
            testCal.set(14, 0);
            Literal lc = this.m.createTypedLiteral((Object)testCal);
            TestTypedLiterals.assertEquals("calendar overloading test", this.m.createTypedLiteral("1999-05-30T15:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime), lc);
        }
        finally {
            JenaParameters.enableEagerLiteralValidation = old;
        }
    }

    public void testPlainSameValueAs() {
        Literal lString = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDstring);
        Literal lPlain = this.m.createTypedLiteral("10", (RDFDatatype)null);
        Literal lPlain3 = this.m.createTypedLiteral("10", (String)null);
        Literal lPlain2 = this.m.createLiteral("10");
        Literal lInt = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSameValueAs("Null type = plain literal", lPlain, lPlain2);
        this.assertSameValueAs("Null type = plain literal", lPlain, lPlain3);
        this.assertSameValueAs("Null type = plain literal", lPlain2, lPlain3);
        TestTypedLiterals.assertTrue("null type", lPlain3.getDatatype() == null);
        this.assertDiffer("String != int", lString, lInt);
        this.assertDiffer("Plain != int", lPlain, lInt);
        this.assertDiffer("Plain != int", lPlain2, lInt);
        if (JenaParameters.enablePlainLiteralSameAsString) {
            this.assertSameValueAs("String != plain??", lString, lPlain);
            this.assertSameValueAs("String != plain??", lString, lPlain2);
        } else {
            this.assertDiffer("String != plain??", lString, lPlain);
            this.assertDiffer("String != plain??", lString, lPlain2);
        }
    }

    public void testNumberSameValueAs() {
        Literal lDouble = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDdouble);
        Literal lDouble2 = this.m.createTypedLiteral("5.5", (RDFDatatype)XSDDatatype.XSDdouble);
        Literal lFloat = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDfloat);
        Literal lint = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDint);
        Literal linteger = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDinteger);
        Literal lbyte = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDbyte);
        this.assertSameValueAs("integer subclasses equal", lint, linteger);
        this.assertSameValueAs("integer subclasses equal", lint, lbyte);
        this.assertSameValueAs("integer subclasses equal", linteger, lbyte);
        this.assertDiffer("float/double/int distinct", lDouble, lDouble2);
        this.assertDiffer("float/double/int distinct", lDouble, lFloat);
        this.assertDiffer("float/double/int distinct", lDouble, lint);
        this.assertDiffer("float/double/int distinct", lDouble, linteger);
        this.assertDiffer("float/double/int distinct", lDouble2, lint);
        this.assertDiffer("float/double/int distinct", lDouble2, lbyte);
        this.assertDiffer("float/double/int distinct", lint, lDouble);
        this.assertDiffer("float/double/int distinct", lbyte, lDouble);
        this.assertDiffer("float/double/int distinct", lint, lDouble2);
        this.assertDiffer("float/double/int distinct", lbyte, lDouble2);
    }

    public void testUserDefined() throws IOException {
        String uri = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String filename = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper tm = TypeMapper.getInstance();
        List typenames = XSDDatatype.loadUserDefined(uri, new FileReader(filename), null, tm);
        this.assertIteratorValues(typenames.iterator(), new Object[]{uri + "#XSDEnumerationHeight", uri + "#over12", uri + "#over17", uri + "#over59", uri + "#clothingsize"});
        RDFDatatype heightType = tm.getSafeTypeByName(uri + "#XSDEnumerationHeight");
        this.checkLegalLiteral("short", heightType, String.class, "short");
        this.checkLegalLiteral("tall", heightType, String.class, "tall");
        this.checkIllegalLiteral("shortish", heightType);
        RDFDatatype over12Type = tm.getSafeTypeByName(uri + "#over12");
        this.checkLegalLiteral("15", over12Type, Integer.class, new Integer(15));
        this.checkIllegalLiteral("12", over12Type);
        RDFDatatype clothingsize = tm.getSafeTypeByName(uri + "#clothingsize");
        this.checkLegalLiteral("42", clothingsize, Integer.class, new Integer(42));
        this.checkLegalLiteral("short", clothingsize, String.class, "short");
        LiteralLabel iOver12 = this.m.createTypedLiteral("13", over12Type).asNode().getLiteral();
        LiteralLabel iDecimal14 = this.m.createTypedLiteral("14", (RDFDatatype)XSDDatatype.XSDdecimal).asNode().getLiteral();
        LiteralLabel iDecimal10 = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDdecimal).asNode().getLiteral();
        LiteralLabel iString = this.m.createTypedLiteral("15", (RDFDatatype)XSDDatatype.XSDstring).asNode().getLiteral();
        LiteralLabel iPlain = this.m.createLiteral("foo").asNode().getLiteral();
        TestTypedLiterals.assertTrue(over12Type.isValidLiteral(iOver12));
        TestTypedLiterals.assertTrue(over12Type.isValidLiteral(iDecimal14));
        TestTypedLiterals.assertTrue(!over12Type.isValidLiteral(iDecimal10));
        TestTypedLiterals.assertTrue(!over12Type.isValidLiteral(iString));
        TestTypedLiterals.assertTrue(!over12Type.isValidLiteral(iPlain));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDdecimal.isValidLiteral(iOver12));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDdecimal.isValidLiteral(iDecimal14));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDdecimal.isValidLiteral(iDecimal10));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDdecimal.isValidLiteral(iString));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDdecimal.isValidLiteral(iPlain));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDstring.isValidLiteral(iString));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDstring.isValidLiteral(iPlain));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDstring.isValidLiteral(iOver12));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDstring.isValidLiteral(iDecimal10));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDstring.isValidLiteral(iDecimal14));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateTime() {
        Literal l1 = this.m.createTypedLiteral("P1Y2M3DT5H6M7.50S", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals("duration data type", XSDDatatype.XSDduration, l1.getDatatype());
        TestTypedLiterals.assertEquals("duration java type", XSDDuration.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals("duration value", 1, ((XSDDuration)l1.getValue()).getYears());
        TestTypedLiterals.assertEquals("duration value", 2, ((XSDDuration)l1.getValue()).getMonths());
        TestTypedLiterals.assertEquals("duration value", 3, ((XSDDuration)l1.getValue()).getDays());
        TestTypedLiterals.assertEquals("duration value", 5, ((XSDDuration)l1.getValue()).getHours());
        TestTypedLiterals.assertEquals("duration value", 6, ((XSDDuration)l1.getValue()).getMinutes());
        TestTypedLiterals.assertEquals("duration value", 7, ((XSDDuration)l1.getValue()).getFullSeconds());
        TestTypedLiterals.assertEquals("duration value", BigDecimal.valueOf(75L, 1), ((XSDDuration)l1.getValue()).getBigSeconds());
        this.assertFloatEquals("duration value", 18367.5, ((XSDDuration)l1.getValue()).getTimePart());
        TestTypedLiterals.assertEquals("serialization", "P1Y2M3DT5H6M7.5S", l1.getValue().toString());
        TestTypedLiterals.assertTrue("equality test", l1.sameValueAs(this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration)));
        TestTypedLiterals.assertTrue("inequality test", l1 != this.m.createTypedLiteral("P1Y2M2DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration));
        l1 = this.m.createTypedLiteral("P1Y2M3DT5H0M", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals("serialization", "P1Y2M3DT5H", l1.getValue().toString());
        l1 = this.m.createTypedLiteral("P1Y", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals("duration data type", XSDDatatype.XSDduration, l1.getDatatype());
        TestTypedLiterals.assertEquals("duration java type", XSDDuration.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals("duration value", 1, ((XSDDuration)l1.getValue()).getYears());
        TestTypedLiterals.assertEquals("serialization", "P1Y", l1.getValue().toString());
        TestTypedLiterals.assertTrue("equality test", l1.sameValueAs(this.m.createTypedLiteral("P1Y", (RDFDatatype)XSDDatatype.XSDduration)));
        TestTypedLiterals.assertTrue("inequality test", l1 != this.m.createTypedLiteral("P1Y", (RDFDatatype)XSDDatatype.XSDduration));
        l1 = this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime);
        XSDDateTime xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDdateTime, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals("dateTime value", 1999, xdt.getYears());
        TestTypedLiterals.assertEquals("dateTime value", 5, xdt.getMonths());
        TestTypedLiterals.assertEquals("dateTime value", 31, xdt.getDays());
        TestTypedLiterals.assertEquals("dateTime value", 2, xdt.getHours());
        TestTypedLiterals.assertEquals("dateTime value", 9, xdt.getMinutes());
        TestTypedLiterals.assertEquals("dateTime value", 32, xdt.getFullSeconds());
        TestTypedLiterals.assertEquals("serialization", "1999-05-31T02:09:32Z", l1.getValue().toString());
        Calendar cal = xdt.asCalendar();
        GregorianCalendar testCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal.set(1999, 4, 31, 2, 9, 32);
        testCal.set(14, 0);
        TestTypedLiterals.assertEquals("calendar value", cal, testCal);
        TestTypedLiterals.assertEquals("equality test", l1, this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        TestTypedLiterals.assertTrue("inequality test", l1 != this.m.createTypedLiteral("1999-04-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        GregorianCalendar testCal2 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal2.set(1999, 4, 30, 15, 9, 32);
        testCal2.set(14, 0);
        Literal lc = this.m.createTypedLiteral(testCal2);
        TestTypedLiterals.assertEquals("calendar 24 hour test", this.m.createTypedLiteral("1999-05-30T15:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime), lc);
        TestTypedLiterals.assertEquals("calendar value", cal, testCal);
        TestTypedLiterals.assertEquals("equality test", l1, this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        GregorianCalendar testCal3 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal3.clear();
        testCal3.set(1999, 0, 30, 15, 9, 32);
        lc = this.m.createTypedLiteral(testCal3);
        TestTypedLiterals.assertEquals("1999-01-30T15:09:32Z", lc.getLexicalForm());
        String urib = "rdf://test.com#";
        String uri1 = urib + "1";
        String urip = urib + "prop";
        String testN3 = "<" + uri1 + "> <" + urip + "> \"" + lc.getLexicalForm() + "\"^^<" + lc.getDatatypeURI() + "> .";
        StringReader sr = new StringReader(testN3);
        this.m.read(sr, urib, "N3");
        TestTypedLiterals.assertTrue(this.m.contains(this.m.getResource(uri1), this.m.getProperty(urip)));
        Resource r1 = this.m.getResource(uri1);
        Property p = this.m.getProperty(urip);
        XSDDateTime returnedDateTime = (XSDDateTime)r1.getProperty(p).getLiteral().getValue();
        TestTypedLiterals.assertEquals("deserialized calendar value", testCal3, returnedDateTime.asCalendar());
        GregorianCalendar testCal4 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal4.set(1999, 4, 30, 15, 9, 32);
        testCal4.set(14, 25);
        this.doDateTimeTest(testCal4, "1999-05-30T15:09:32.025Z", 32.025);
        testCal4.set(14, 250);
        this.doDateTimeTest(testCal4, "1999-05-30T15:09:32.25Z", 32.25);
        testCal4.set(14, 2);
        this.doDateTimeTest(testCal4, "1999-05-30T15:09:32.002Z", 32.002);
        boolean ok = false;
        boolean old = JenaParameters.enableEagerLiteralValidation;
        try {
            JenaParameters.enableEagerLiteralValidation = true;
            l1 = this.m.createTypedLiteral((Object)new java.util.Date(12345656L), (RDFDatatype)XSDDatatype.XSDdateTime);
        }
        catch (DatatypeFormatException e2) {
            ok = true;
        }
        finally {
            JenaParameters.enableEagerLiteralValidation = old;
        }
        TestTypedLiterals.assertTrue("Early detection of invalid literals", ok);
        l1 = this.m.createTypedLiteral("1999-05-31", (RDFDatatype)XSDDatatype.XSDdate);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDdate, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 1999, xdt.getYears());
        TestTypedLiterals.assertEquals("dateTime value", 5, xdt.getMonths());
        TestTypedLiterals.assertEquals("dateTime value", 31, xdt.getDays());
        try {
            xdt.getHours();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e3) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("12:56:32", (RDFDatatype)XSDDatatype.XSDtime);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDtime, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 12, xdt.getHours());
        TestTypedLiterals.assertEquals("dateTime value", 56, xdt.getMinutes());
        TestTypedLiterals.assertEquals("dateTime value", 32, xdt.getFullSeconds());
        try {
            xdt.getDays();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e4) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("1999-05", (RDFDatatype)XSDDatatype.XSDgYearMonth);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDgYearMonth, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 1999, xdt.getYears());
        TestTypedLiterals.assertEquals("dateTime value", 5, xdt.getMonths());
        try {
            xdt.getDays();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e5) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("1999", (RDFDatatype)XSDDatatype.XSDgYear);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDgYear, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 1999, xdt.getYears());
        try {
            xdt.getMonths();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e6) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("--05--", (RDFDatatype)XSDDatatype.XSDgMonth);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDgMonth, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 5, xdt.getMonths());
        try {
            xdt.getYears();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e7) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("--05-25", (RDFDatatype)XSDDatatype.XSDgMonthDay);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDgMonthDay, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 5, xdt.getMonths());
        TestTypedLiterals.assertEquals("dateTime value", 25, xdt.getDays());
        try {
            xdt.getYears();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e8) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("---25", (RDFDatatype)XSDDatatype.XSDgDay);
        TestTypedLiterals.assertEquals("dateTime data type", XSDDatatype.XSDgDay, l1.getDatatype());
        TestTypedLiterals.assertEquals("dateTime java type", XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals("dateTime value", 25, xdt.getDays());
        try {
            xdt.getMonths();
            TestTypedLiterals.assertTrue("Failed to prevent illegal access", false);
        }
        catch (IllegalDateTimeFieldException e9) {
            // empty catch block
        }
        GregorianCalendar ncal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        ncal.set(2003, 11, 8, 10, 50, 42);
        ncal.set(14, 0);
        l1 = this.m.createTypedLiteral(ncal);
        TestTypedLiterals.assertEquals("DateTime from date", XSDDatatype.XSDdateTime, l1.getDatatype());
        TestTypedLiterals.assertEquals("DateTime from date", XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals("DateTime from date", "2003-12-08T10:50:42Z", l1.getValue().toString());
        SimpleTimeZone pdt = new SimpleTimeZone(-28800000, "America/Los_Angeles");
        pdt.setStartRule(3, 1, 1, 0x6DDD00);
        pdt.setEndRule(9, -1, 1, 0x6DDD00);
        ncal = new GregorianCalendar(pdt);
        ncal.set(2004, 2, 21, 12, 50, 42);
        ncal.set(14, 0);
        l1 = this.m.createTypedLiteral(ncal);
        TestTypedLiterals.assertEquals("DateTime from date", XSDDatatype.XSDdateTime, l1.getDatatype());
        TestTypedLiterals.assertEquals("DateTime from date", XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals("DateTime from date", "2004-03-21T20:50:42Z", l1.getValue().toString());
        ncal = new GregorianCalendar(pdt);
        ncal.set(2004, 3, 21, 12, 50, 42);
        ncal.set(14, 0);
        l1 = this.m.createTypedLiteral(ncal);
        TestTypedLiterals.assertEquals("DateTime from date", XSDDatatype.XSDdateTime, l1.getDatatype());
        TestTypedLiterals.assertEquals("DateTime from date", XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals("DateTime from date", "2004-04-21T19:50:42Z", l1.getValue().toString());
    }

    private void doDateTimeTest(Calendar cal, String lex, double time) {
        Literal lc4 = this.m.createTypedLiteral(cal);
        TestTypedLiterals.assertEquals("serialization", lex, lc4.getValue().toString());
        TestTypedLiterals.assertEquals("calendar ms test", this.m.createTypedLiteral(lex, (RDFDatatype)XSDDatatype.XSDdateTime), lc4);
        XSDDateTime dt4 = (XSDDateTime)lc4.getValue();
        TestTypedLiterals.assertTrue("Fraction time check", Math.abs(dt4.getSeconds() - time) < 1.0E-4);
        TestTypedLiterals.assertEquals(dt4.asCalendar(), cal);
    }

    public void testTypedContains() {
        Model model = ModelFactory.createDefaultModel();
        Property p = model.createProperty("urn:x-eg/p");
        Literal l1 = model.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal l2 = model.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("sameas test", l1, l2);
        Resource a = model.createResource("urn:x-eg/a");
        a.addProperty(p, l1);
        TestTypedLiterals.assertTrue(model.getGraph().contains(a.asNode(), p.asNode(), l1.asNode()));
        TestTypedLiterals.assertTrue(model.getGraph().contains(a.asNode(), p.asNode(), l2.asNode()));
    }

    public void testTypedQueries() {
        Model model = ModelFactory.createDefaultModel();
        Property p = model.createProperty("urn:x-eg/p");
        Literal l1 = model.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal l2 = model.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("sameas test", l1, l2);
        Resource a = model.createResource("urn:x-eg/a");
        a.addProperty(p, l1);
        TestTypedLiterals.assertTrue(model.getGraph().find(null, p.asNode(), l1.asNode()).hasNext());
        TestTypedLiterals.assertTrue(model.getGraph().find(null, p.asNode(), l2.asNode()).hasNext());
        TestTypedLiterals.assertTrue(model.getGraph().find(a.asNode(), p.asNode(), l2.asNode()).hasNext());
        TestTypedLiterals.assertTrue(model.getGraph().contains(a.asNode(), p.asNode(), l2.asNode()));
        Query q = new Query();
        q.addMatch(a.asNode(), p.asNode(), l2.asNode());
        ExtendedIterator qi = model.getGraph().queryHandler().prepareBindings(q, new Node[0]).executeBindings();
        TestTypedLiterals.assertTrue(qi.hasNext());
        TestTypedLiterals.assertTrue(model.listStatements(a, p, l2).hasNext());
    }

    public void testIsValidLiteral() {
        Literal l = this.m.createTypedLiteral("1000", (RDFDatatype)XSDDatatype.XSDinteger);
        LiteralLabel ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue(XSDDatatype.XSDlong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDint.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDshort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDunsignedInt.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDunsignedLong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDunsignedShort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDpositiveInteger.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDdecimal.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDstring.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDbyte.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDnegativeInteger.isValidLiteral(ll));
        l = this.m.createTypedLiteral("-2", (RDFDatatype)XSDDatatype.XSDinteger);
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue(XSDDatatype.XSDlong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDint.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDshort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDunsignedInt.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDunsignedLong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDunsignedShort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDdecimal.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDpositiveInteger.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDstring.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDbyte.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDnegativeInteger.isValidLiteral(ll));
        l = this.m.createTypedLiteral("4.5", (RDFDatatype)XSDDatatype.XSDfloat);
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDdouble.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDdecimal.isValidLiteral(ll));
        Literal l2 = this.m.createTypedLiteral("foo", (RDFDatatype)XSDDatatype.XSDstring);
        TestTypedLiterals.assertTrue(XSDDatatype.XSDstring.isValidLiteral(l2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDnormalizedString.isValidLiteral(l2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDint.isValidLiteral(l2.asNode().getLiteral()));
        l = this.m.createTypedLiteral("foo bar");
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue(XSDDatatype.XSDstring.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDint.isValidLiteral(ll));
        l = this.m.createTypedLiteral("12");
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue(XSDDatatype.XSDstring.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDint.isValidLiteral(ll));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDnonNegativeInteger.isValidValue(new Integer(10)));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDnonNegativeInteger.isValidValue(new Integer(10)));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDnonNegativeInteger.isValidValue(new Integer(-10)));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDnonNegativeInteger.isValidValue("10"));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDfloat.isValidValue(new Float("2.3")));
        TestTypedLiterals.assertTrue(XSDDatatype.XSDdouble.isValidValue(new Double("2.3")));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDfloat.isValidValue(new Integer("2")));
        TestTypedLiterals.assertTrue(!XSDDatatype.XSDfloat.isValidValue(new Double("2.3")));
    }

    public void testBinary() {
        byte[] data = new byte[]{12, 42, 99};
        Literal l = this.m.createTypedLiteral(data);
        LiteralLabel ll = l.asNode().getLiteral();
        TestTypedLiterals.assertEquals("binary test 1", ll.getDatatype(), XSDDatatype.XSDbase64Binary);
        TestTypedLiterals.assertEquals("binary test 2", "DCpj", ll.getLexicalForm());
        LiteralLabel l2 = this.m.createTypedLiteral(ll.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDbase64Binary).asNode().getLiteral();
        Object data2 = l2.getValue();
        TestTypedLiterals.assertTrue("binary test 3", data2 instanceof byte[]);
        byte[] data2b = (byte[])data2;
        TestTypedLiterals.assertEquals("binary test 4", (int)data2b[0], 12);
        TestTypedLiterals.assertEquals("binary test 5", (int)data2b[1], 42);
        TestTypedLiterals.assertEquals("binary test 6", (int)data2b[2], 99);
        TestTypedLiterals.assertEquals(l2, ll);
        l2 = this.m.createTypedLiteral("DCpj", (RDFDatatype)XSDDatatype.XSDbase64Binary).asNode().getLiteral();
        data2 = l2.getValue();
        TestTypedLiterals.assertTrue("binary test 3", data2 instanceof byte[]);
        data2b = (byte[])data2;
        TestTypedLiterals.assertEquals("binary test 4", (int)data2b[0], 12);
        TestTypedLiterals.assertEquals("binary test 5", (int)data2b[1], 42);
        TestTypedLiterals.assertEquals("binary test 6", (int)data2b[2], 99);
        l = this.m.createTypedLiteral((Object)data, (RDFDatatype)XSDDatatype.XSDhexBinary);
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertEquals("binary test 1b", ll.getDatatype(), XSDDatatype.XSDhexBinary);
        TestTypedLiterals.assertEquals("binary test 2b", HexBin.encode(data), ll.getLexicalForm());
        l2 = this.m.createTypedLiteral(ll.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDhexBinary).asNode().getLiteral();
        data2 = l2.getValue();
        TestTypedLiterals.assertTrue("binary test 3b", data2 instanceof byte[]);
        data2b = (byte[])data2;
        TestTypedLiterals.assertEquals("binary test 4b", (int)data2b[0], 12);
        TestTypedLiterals.assertEquals("binary test 5b", (int)data2b[1], 42);
        TestTypedLiterals.assertEquals("binary test 6b", (int)data2b[2], 99);
        TestTypedLiterals.assertEquals(l2, ll);
        Literal la = this.m.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        Literal lb = this.m.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        TestTypedLiterals.assertTrue("equality test", la.sameValueAs(lb));
        data = new byte[]{15, -73};
        l = this.m.createTypedLiteral((Object)data, (RDFDatatype)XSDDatatype.XSDhexBinary);
        TestTypedLiterals.assertEquals("hexBinary encoding", "0FB7", l.getLexicalForm());
    }

    public void XXtestBinaryBug() throws IOException {
        Model orig = ModelFactory.createDefaultModel();
        Resource r = orig.createResource("http://jena.hpl.hp.com/test#r");
        Property p = orig.createProperty("http://jena.hpl.hp.com/test#p");
        Literal l = orig.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        orig.add(r, p, l);
        for (int i = 0; i < 150; ++i) {
            l = orig.createTypedLiteral(new byte[]{(byte)i, (byte)i, (byte)i});
            orig.add(orig.createResource("urn:x-hp:" + i), p, l);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        orig.write(out, "RDF/XML-ABBREV");
        out.close();
        ByteArrayInputStream ins = new ByteArrayInputStream(out.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        m2.read(ins, null);
        ((InputStream)ins).close();
        TestTypedLiterals.assertTrue(orig.isIsomorphicWith(m2));
    }

    public void testDateTimeBug() {
        String XSDDateURI = XSD.date.getURI();
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype dt = typeMapper.getSafeTypeByName(XSDDateURI);
        Object obj = dt.parse("2003-05-21");
        Literal literal = this.m.createTypedLiteral(obj, dt);
        String serialization = literal.toString();
        Object value2 = dt.parse(obj.toString());
        TestTypedLiterals.assertEquals(obj, value2);
        XSDDatatype dateType = XSDDatatype.XSDdate;
        Literal l = this.m.createTypedLiteral("2003-05-21", (RDFDatatype)dateType);
        this.checkSerialization("2003-05-21", XSDDatatype.XSDdate);
        this.checkSerialization("2003-05-21T12:56:10Z", XSDDatatype.XSDdateTime);
        this.checkSerialization("2003-05", XSDDatatype.XSDgYearMonth);
        this.checkSerialization("2003", XSDDatatype.XSDgYear);
        this.checkSerialization("--05", XSDDatatype.XSDgMonth);
        this.checkSerialization("--05-12", XSDDatatype.XSDgMonthDay);
        this.checkSerialization("---12", XSDDatatype.XSDgDay);
    }

    public void testFlags() {
        Literal l;
        boolean originalFlag = JenaParameters.enableEagerLiteralValidation;
        JenaParameters.enableEagerLiteralValidation = true;
        boolean foundException = false;
        try {
            l = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException e1) {
            foundException = true;
        }
        JenaParameters.enableEagerLiteralValidation = originalFlag;
        TestTypedLiterals.assertTrue("Early datatype format exception", foundException);
        JenaParameters.enableEagerLiteralValidation = false;
        foundException = false;
        l = null;
        try {
            l = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException e1) {
            JenaParameters.enableEagerLiteralValidation = originalFlag;
            TestTypedLiterals.assertTrue("Delayed datatype format validation", false);
        }
        try {
            l.getValue();
        }
        catch (DatatypeFormatException e2) {
            foundException = true;
        }
        JenaParameters.enableEagerLiteralValidation = originalFlag;
        TestTypedLiterals.assertTrue("Early datatype format exception", foundException);
        originalFlag = JenaParameters.enablePlainLiteralSameAsString;
        Literal l1 = this.m.createLiteral("test string");
        Literal l2 = this.m.createTypedLiteral("test string", (RDFDatatype)XSDDatatype.XSDstring);
        JenaParameters.enablePlainLiteralSameAsString = true;
        boolean ok1 = l1.sameValueAs(l2);
        JenaParameters.enablePlainLiteralSameAsString = false;
        boolean ok2 = !l1.sameValueAs(l2);
        JenaParameters.enablePlainLiteralSameAsString = originalFlag;
        TestTypedLiterals.assertTrue(ok1);
        TestTypedLiterals.assertTrue(ok2);
    }

    public void testLexicalDistinction() {
        Literal l1 = this.m.createTypedLiteral("3.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal l2 = this.m.createTypedLiteral("3.00", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal l3 = this.m.createTypedLiteral("3.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        this.assertSameValueAs("lexical form does not affect value", l1, l2);
        this.assertSameValueAs("lexical form does not affect value", l3, l2);
        TestTypedLiterals.assertTrue("lexical form affects equality", !((Object)l1).equals(l2));
        TestTypedLiterals.assertTrue("lexical form affects equality", ((Object)l1).equals(l3));
        l1 = this.m.createTypedLiteral("3", (RDFDatatype)XSDDatatype.XSDint);
        l2 = this.m.createTypedLiteral(" 3 ", (RDFDatatype)XSDDatatype.XSDint);
        l3 = this.m.createTypedLiteral("3", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSameValueAs("lexical form does not affect value", l1, l2);
        this.assertSameValueAs("lexical form does not affect value", l3, l2);
        TestTypedLiterals.assertTrue("lexical form affects equality", !((Object)l1).equals(l2));
        TestTypedLiterals.assertTrue("lexical form affects equality", ((Object)l1).equals(l3));
    }

    public void testRoundTrip() {
        this.doTestRoundTrip("13:20:00.000", XSDDatatype.XSDtime, false);
        this.doTestRoundTrip("GpM7", XSDDatatype.XSDbase64Binary, true);
        this.doTestRoundTrip("0FB7", XSDDatatype.XSDhexBinary, true);
        this.doTestValueRoundTrip("2005-06-27", XSDDatatype.XSDdate, true);
        this.doTestValueRoundTrip("2005", XSDDatatype.XSDgYear, true);
        this.doTestValueRoundTrip("2005-06", XSDDatatype.XSDgYearMonth, true);
        this.doTestValueRoundTrip("13:20:00.000", XSDDatatype.XSDtime, true);
    }

    public void doTestRoundTrip(String lex, RDFDatatype dt, boolean testeq) {
        LiteralLabel ll = LiteralLabel.createLiteralLabel(lex, "", dt);
        String lex2 = dt.unparse(ll.getValue());
        if (testeq) {
            TestTypedLiterals.assertEquals(lex, lex2);
        }
        LiteralLabel ll2 = LiteralLabel.createLiteralLabel(lex2, "", dt);
        TestTypedLiterals.assertTrue(ll2.isWellFormed());
    }

    public void doTestValueRoundTrip(String lex, RDFDatatype dt, boolean testType) {
        Literal l1 = this.m.createTypedLiteral(lex, dt);
        Object o1 = l1.getValue();
        Literal l2 = this.m.createTypedLiteral(o1);
        TestTypedLiterals.assertTrue("value round trip", l1.sameValueAs(l2));
        Object o2 = l2.getValue();
        TestTypedLiterals.assertTrue("value round trip2", o1.equals(o2));
        if (testType) {
            TestTypedLiterals.assertEquals("Datatype round trip", dt, l2.getDatatype());
        }
    }

    public void testDateOverride() {
        GregorianCalendar date2 = new GregorianCalendar(2007, 3, 4);
        ((Calendar)date2).setTimeZone(TimeZone.getTimeZone("GMT+0"));
        XSDDateTime xsdDate = new XSDDateTime(date2);
        Literal l1 = this.m.createTypedLiteral((Object)xsdDate, (RDFDatatype)XSDDatatype.XSDdate);
        TestTypedLiterals.assertEquals(XSDDatatype.XSDdate, l1.getDatatype());
        TestTypedLiterals.assertEquals("2007-04-04", l1.getLexicalForm());
    }

    private void assertDiffer(String title, Literal x, Literal y) {
        TestTypedLiterals.assertTrue(title, !x.sameValueAs(y));
    }

    private void assertSameValueAs(String title, Literal x, Literal y) {
        TestTypedLiterals.assertTrue(title, x.sameValueAs(y));
    }

    private void assertFloatEquals(String title, double x, double y) {
        TestTypedLiterals.assertTrue(title, Math.abs(x - y) < 0.001);
    }

    public void checkIllegalLiteral(String lex, RDFDatatype dtype) {
        try {
            Literal l = this.m.createTypedLiteral(lex, dtype);
            l.getValue();
            TestTypedLiterals.assertTrue("Failed to catch '" + lex + "' as an illegal " + dtype, false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
    }

    public void checkLegalLiteral(String lex, RDFDatatype dtype, Class jtype, Object value) {
        Literal l = this.m.createTypedLiteral(lex, dtype);
        TestTypedLiterals.assertEquals(l.getValue().getClass(), jtype);
        TestTypedLiterals.assertEquals(l.getValue(), value);
        TestTypedLiterals.assertEquals(l.getDatatype(), dtype);
    }

    public void checkSerialization(String lex, RDFDatatype dtype) {
        Literal l = this.m.createTypedLiteral(lex, dtype);
        TestTypedLiterals.assertEquals(l.getValue().toString(), lex);
    }

    public void assertIteratorValues(Iterator it, Object[] vals) {
        int i;
        boolean[] found = new boolean[vals.length];
        for (i = 0; i < vals.length; ++i) {
            found[i] = false;
        }
        while (it.hasNext()) {
            Object n = it.next();
            boolean gotit = false;
            for (int i2 = 0; i2 < vals.length; ++i2) {
                if (!n.equals(vals[i2])) continue;
                gotit = true;
                found[i2] = true;
            }
            TestTypedLiterals.assertTrue(gotit);
        }
        for (i = 0; i < vals.length; ++i) {
            TestTypedLiterals.assertTrue(found[i]);
        }
    }
}

