/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.MixedGraphMemStore;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class MixedGraphMem
extends GraphMemBase
implements Graph {
    protected MixedGraphMemStore store = new MixedGraphMemStore(this);

    public MixedGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public MixedGraphMem(ReificationStyle style) {
        super(style);
    }

    protected TripleStore createTripleStore() {
        return null;
    }

    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.store.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.store.remove(t);
        }
    }

    public int graphBaseSize() {
        return this.store.size();
    }

    public boolean graphBaseContains(Triple t) {
        return this.isSafeForEquality(t) ? this.store.contains(t) : this.containsByFind(t);
    }

    protected void destroy() {
        this.store = null;
    }

    public boolean isEmpty() {
        this.checkOpen();
        return this.store.isEmpty();
    }

    public void clear() {
        this.store.clear();
    }

    public ExtendedIterator graphBaseFind(TripleMatch m) {
        Triple t = m.asTriple();
        Node S = t.getSubject();
        Node P = t.getPredicate();
        Node O = t.getObject();
        return S.isConcrete() ? this.store.iterator(S, t) : (P.isConcrete() ? this.store.iterator(P, t) : (O.isURI() || O.isBlank() ? this.store.iterator(O, t) : this.store.iterator(m.asTriple())));
    }
}

