/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.RelURI;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRelURI
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestRelURI.class);
        ts.setName("TestURI");
        return ts;
    }

    public void testCodec01() {
        this.execCodecTest("");
    }

    public void testCodec02() {
        this.execCodecTest("a");
    }

    public void testCodec03() {
        this.execCodecTest("a_");
    }

    public void testCodec04() {
        this.execCodecTest("_a");
    }

    public void testCodec05() {
        this.execCodecTest(" ");
    }

    public void testCodec06() {
        this.execCodecTest("a b");
    }

    public void testCodec07() {
        this.execCodecTest("a ");
    }

    public void testCodec08() {
        this.execCodecTest(" a");
    }

    public void testCodec09() {
        this.execCodecTest("__");
    }

    public void testCodec10() {
        this.execCodecTest("_20");
    }

    public void testCodec11() {
        this.execCodecTest("ab_20xy");
    }

    public void testCodec12() {
        this.execCodecTest("ab_5F20xy");
    }

    public void testCodec13() {
        this.execCodecTest("ab_5Fxy");
    }

    private void execCodecTest(String s) {
        String a = RelURI.CodecHex.encode(s);
        String b = RelURI.CodecHex.decode(a);
        TestRelURI.assertEquals("Input: (" + s + ") Encoded: (" + a + ") Decoded: (" + b + ")", s, b);
    }
}

