/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.impl.test.DAMLTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestSuite;

public class TestDAMLClass
extends DAMLTestBase {
    public static TestSuite suite() {
        return new TestDAMLClass("TestDAMLClass");
    }

    public TestDAMLClass(String name) {
        super(name);
    }

    public DAMLTestBase.OntTestCase[] getTests() {
        return new DAMLTestBase.OntTestCase[]{new DAMLTestBase.OntTestCase("DAMLClass.prop_subClassOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                1.assertEquals("prop_subClassOf property", RDFS.subClassOf, A.prop_subClassOf().getProperty());
                1.assertEquals("sub-class cardinality", 2, A.prop_subClassOf().count());
                A.prop_subClassOf().add(B);
                this.iteratorTest(A.prop_subClassOf().getAll(), new Object[]{A, B, DAML_OIL.Thing});
                1.assertEquals("sub-class cardinality", 3, A.prop_subClassOf().count());
                A.prop_subClassOf().add(C);
                1.assertEquals("sub-class cardinality", 4, A.prop_subClassOf().count());
                this.iteratorTest(A.prop_subClassOf().getAll(), new Object[]{A, B, C, DAML_OIL.Thing});
                A.prop_subClassOf().remove(C);
                1.assertEquals("sub-class cardinality", 3, A.prop_subClassOf().count());
                this.iteratorTest(A.prop_subClassOf().getAll(), new Object[]{A, B, DAML_OIL.Thing});
                1.assertTrue("hasValue", A.prop_subClassOf().hasValue(B));
                1.assertTrue("hasValue", !A.prop_subClassOf().hasValue(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_disjointWith"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                2.assertEquals("prop_disjointwith property", DAML_OIL.disjointWith, A.prop_disjointWith().getProperty());
                2.assertEquals("disjointWith cardinality", 0, A.prop_disjointWith().count());
                A.prop_disjointWith().add(B);
                2.assertEquals("disjointwith cardinality", 1, A.prop_disjointWith().count());
                A.prop_disjointWith().add(C);
                2.assertEquals("disjointWith cardinality", 2, A.prop_disjointWith().count());
                this.iteratorTest(A.prop_disjointWith().getAll(), new Object[]{B, C});
                A.prop_disjointWith().remove(C);
                2.assertEquals("disjointwith cardinality", 1, A.prop_disjointWith().count());
                this.iteratorTest(A.prop_disjointWith().getAll(), new Object[]{B});
                2.assertTrue("hasValue", A.prop_disjointWith().hasValue(B));
                2.assertTrue("hasValue", !A.prop_disjointWith().hasValue(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_sameClassAs"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                3.assertEquals("prop_sameClassAs property", DAML_OIL.sameClassAs, A.prop_sameClassAs().getProperty());
                3.assertEquals("sameClassAs cardinality", 0, A.prop_sameClassAs().count());
                A.prop_sameClassAs().add(B);
                3.assertEquals("sameClassAs cardinality", 1, A.prop_sameClassAs().count());
                A.prop_sameClassAs().add(C);
                3.assertEquals("sameClassAs cardinality", 2, A.prop_sameClassAs().count());
                this.iteratorTest(A.prop_sameClassAs().getAll(), new Object[]{B, C});
                A.prop_sameClassAs().remove(C);
                3.assertEquals("sameClassAs cardinality", 1, A.prop_sameClassAs().count());
                this.iteratorTest(A.prop_sameClassAs().getAll(), new Object[]{B});
                3.assertTrue("hasValue", A.prop_sameClassAs().hasValue(B));
                3.assertTrue("hasValue", !A.prop_sameClassAs().hasValue(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.prop_complementOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                4.assertEquals("prop_complementOf property", DAML_OIL.complementOf, A.prop_complementOf().getProperty());
                4.assertEquals("complementOf cardinality", 0, A.prop_complementOf().count());
                A.prop_complementOf().add(B);
                4.assertEquals("complementOf cardinality", 1, A.prop_complementOf().count());
                A.prop_complementOf().add(C);
                4.assertEquals("complementOf cardinality", 2, A.prop_complementOf().count());
                this.iteratorTest(A.prop_complementOf().getAll(), new Object[]{B, C});
                A.prop_complementOf().remove(C);
                4.assertEquals("complementOf cardinality", 1, A.prop_complementOf().count());
                this.iteratorTest(A.prop_complementOf().getAll(), new Object[]{B});
                4.assertTrue("hasValue", A.prop_complementOf().hasValue(B));
                4.assertTrue("hasValue", !A.prop_complementOf().hasValue(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSubClasses"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                C.prop_subClassOf().add(B);
                B.prop_subClassOf().add(A);
                5.assertEquals("subClassOf A", B, A.getSubClass());
                this.iteratorTest(A.getSubClasses(), new Object[]{B, C});
                this.iteratorTest(A.getSubClasses(false), new Object[]{B});
                this.iteratorTest(A.getSubClasses(true), new Object[]{B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSuperClasses"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.prop_subClassOf().add(B);
                B.prop_subClassOf().add(C);
                this.iteratorTest(A.getSuperClasses(), new Object[]{B, C, DAML_OIL.Thing});
                this.iteratorTest(A.getSuperClasses(false), new Object[]{B});
                this.iteratorTest(A.getSuperClasses(true), new Object[]{B, C, DAML_OIL.Thing});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getSameClasses"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                A.prop_sameClassAs().add(B);
                B.prop_sameClassAs().add(C);
                this.iteratorTest(A.getSameClasses(), new Object[]{B});
                A.prop_sameClassAs().add(C);
                this.iteratorTest(A.getSameClasses(), new Object[]{B, C});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getInstances"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLInstance a = m.createDAMLInstance(A, "http://jena.hpl.hp.com/testing/ontology#a");
                DAMLInstance b = m.createDAMLInstance(A, "http://jena.hpl.hp.com/testing/ontology#b");
                DAMLInstance c = m.createDAMLInstance(A, "http://jena.hpl.hp.com/testing/ontology#c");
                this.iteratorTest(A.getInstances(), new Object[]{a, b, c});
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.disjointUnionOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                9.assertEquals("prop_disjointUnionOf property", DAML_OIL.disjointUnionOf, A.prop_disjointUnionOf().getProperty());
                9.assertEquals("disjointUnionOf cardinality", 0, A.prop_disjointUnionOf().count());
                A.prop_disjointUnionOf().add(m.createDAMLList(new RDFNode[]{B, C}));
                9.assertEquals("disjointUnionOf cardinality", 1, A.prop_disjointUnionOf().count());
                this.iteratorTest(A.prop_disjointUnionOf().getList().getAll(), new Object[]{B, C});
                A.prop_disjointUnionOf().getList().add(D);
                this.iteratorTest(A.prop_disjointUnionOf().getList().getAll(), new Object[]{B, C, D});
                9.assertTrue("contains", A.prop_disjointUnionOf().getList().contains(D));
                9.assertTrue("contains", A.prop_disjointUnionOf().getList().contains(B));
                9.assertTrue("contains", A.prop_disjointUnionOf().getList().contains(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.unionOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                10.assertEquals("prop_unionOf property", DAML_OIL.unionOf, A.prop_unionOf().getProperty());
                10.assertEquals("unionOf cardinality", 0, A.prop_unionOf().count());
                A.prop_unionOf().add(m.createDAMLList(new RDFNode[]{B, C}));
                10.assertEquals("unionOf cardinality", 1, A.prop_unionOf().count());
                this.iteratorTest(A.prop_unionOf().getList().getAll(), new Object[]{B, C});
                A.prop_unionOf().getList().add(D);
                this.iteratorTest(A.prop_unionOf().getList().getAll(), new Object[]{B, C, D});
                10.assertTrue("contains", A.prop_unionOf().getList().contains(D));
                10.assertTrue("contains", A.prop_unionOf().getList().contains(B));
                10.assertTrue("contains", A.prop_unionOf().getList().contains(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.intersectionOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                11.assertEquals("prop_intersectionOf property", DAML_OIL.intersectionOf, A.prop_intersectionOf().getProperty());
                11.assertEquals("intersectionOf cardinality", 0, A.prop_intersectionOf().count());
                A.prop_intersectionOf().add(m.createDAMLList(new RDFNode[]{B, C}));
                11.assertEquals("intersectionOf cardinality", 1, A.prop_intersectionOf().count());
                this.iteratorTest(A.prop_intersectionOf().getList().getAll(), new Object[]{B, C});
                A.prop_intersectionOf().getList().add(D);
                this.iteratorTest(A.prop_intersectionOf().getList().getAll(), new Object[]{B, C, D});
                11.assertTrue("contains", A.prop_intersectionOf().getList().contains(D));
                11.assertTrue("contains", A.prop_intersectionOf().getList().contains(B));
                11.assertTrue("contains", A.prop_intersectionOf().getList().contains(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.oneOf"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                DAMLClass C = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#C");
                DAMLClass D = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#D");
                12.assertEquals("prop_oneOf property", DAML_OIL.oneOf, A.prop_oneOf().getProperty());
                12.assertEquals("oneOf cardinality", 0, A.prop_oneOf().count());
                A.prop_oneOf().add(m.createDAMLList(new RDFNode[]{B, C}));
                12.assertEquals("oneOf cardinality", 1, A.prop_oneOf().count());
                this.iteratorTest(A.prop_oneOf().getList().getAll(), new Object[]{B, C});
                A.prop_oneOf().getList().add(D);
                this.iteratorTest(A.prop_oneOf().getList().getAll(), new Object[]{B, C, D});
                12.assertTrue("contains", A.prop_oneOf().getList().contains(D));
                12.assertTrue("contains", A.prop_oneOf().getList().contains(B));
                12.assertTrue("contains", A.prop_oneOf().getList().contains(C));
            }
        }, new DAMLTestBase.OntTestCase("DAMLClass.getDefinedProperties"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLClass A = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                B.prop_subClassOf().add(A);
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                DAMLObjectProperty q = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                DAMLObjectProperty r = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.prop_domain().add(B);
                q.prop_domain().add(B);
                r.prop_domain().add(A);
                this.iteratorTest(A.getDefinedProperties(), new Object[]{r});
                this.iteratorTest(B.getDefinedProperties(), new Object[]{p, q, r});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_onProperty"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLObjectProperty p = m.createDAMLObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                14.assertEquals("prop_onProperty property", DAML_OIL.onProperty, A.prop_onProperty().getProperty());
                14.assertEquals("onProperty cardinality", 0, A.prop_onProperty().count());
                A.prop_onProperty().add(p);
                14.assertEquals("onProperty cardinality", 1, A.prop_onProperty().count());
                this.iteratorTest(A.prop_onProperty().getAll(), new Object[]{p});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_toClass"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                15.assertEquals("prop_toClass property", DAML_OIL.toClass, A.prop_toClass().getProperty());
                15.assertEquals("toClass cardinality", 0, A.prop_toClass().count());
                A.prop_toClass().add(B);
                15.assertEquals("toClass cardinality", 1, A.prop_toClass().count());
                this.iteratorTest(A.prop_toClass().getAll(), new Object[]{B});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_hasClass"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                DAMLClass B = m.createDAMLClass("http://jena.hpl.hp.com/testing/ontology#B");
                16.assertEquals("prop_hasClass property", DAML_OIL.hasClass, A.prop_hasClass().getProperty());
                16.assertEquals("hasClass cardinality", 0, A.prop_hasClass().count());
                A.prop_hasClass().add(B);
                16.assertEquals("hasClass cardinality", 1, A.prop_hasClass().count());
                this.iteratorTest(A.prop_hasClass().getAll(), new Object[]{B});
            }
        }, new DAMLTestBase.OntTestCase("DAMLRestriction.prop_cardinality"){

            public void doTest(DAMLModel m) throws Exception {
                DAMLRestriction A = m.createDAMLRestriction("http://jena.hpl.hp.com/testing/ontology#A");
                17.assertEquals("prop_cardinality property", DAML_OIL.cardinality, A.prop_cardinality().getProperty());
                17.assertEquals("cardinality cardinality", 0, A.prop_cardinality().count());
                A.prop_cardinality().addInt(1);
                17.assertEquals("cardinality cardinality", 1, A.prop_cardinality().count());
                17.assertEquals("cardinality", 1, A.prop_cardinality().getInt());
            }
        }};
    }
}

