/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OWLDLProfile;
import com.hp.hpl.jena.ontology.impl.OWLLiteProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.ontology.impl.test.TestOntDocumentManager;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestOntModel
extends ModelTestBase {
    public static final String BASE = "http://www.hp.com/test";
    public static final String NS = "http://www.hp.com/test#";
    public static final String DOC = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\"   xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">  <owl:Class rdf:about=\"http://www.hp.com/test#D\">    <rdfs:subClassOf>      <owl:Class rdf:about=\"http://www.hp.com/test#B\"/>    </rdfs:subClassOf>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#B\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#A\"       rdf:type=\"http://www.w3.org/2002/07/owl#Class\"/>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#C\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#B\"/>  </owl:Class>  <owl:ObjectProperty rdf:about=\"http://www.hp.com/test#p\">    <rdfs:domain rdf:resource=\"http://www.hp.com/test#A\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#B\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#C\"/>  </owl:ObjectProperty></rdf:RDF>";

    public TestOntModel(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testWriteOutputStream() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass A = m.createClass("http://www.hp.com/test#A");
        OntClass B = m.createClass("http://www.hp.com/test#B");
        OntClass C = m.createClass("http://www.hp.com/test#C");
        OntClass D = m.createClass("http://www.hp.com/test#D");
        A.addSubClass(B);
        B.addSubClass(C);
        B.addSubClass(D);
        ObjectProperty p = m.createObjectProperty("http://www.hp.com/test#p");
        p.addDomain(A);
        p.addRange(B);
        p.addRange(C);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write(out);
        String s = out.toString();
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        Model mIn1 = ModelFactory.createDefaultModel();
        mIn1.read(in, BASE);
        Model mIn2 = ModelFactory.createDefaultModel();
        mIn2.read(new ByteArrayInputStream(DOC.getBytes()), BASE);
        TestOntModel.assertTrue("InputStream write/read cycle failed (1)", mIn1.isIsomorphicWith(m.getBaseModel()));
        TestOntModel.assertTrue("InputStream write/read cycle failed (2)", mIn2.isIsomorphicWith(m.getBaseModel()));
    }

    public void testGetBaseModelPrefixes() {
        OntModel om = ModelFactory.createOntologyModel();
        om.setNsPrefix("bill", "http://bill.and.ben/flowerpot#");
        om.setNsPrefix("grue", "ftp://grue.and.bleen/2000#");
        TestOntModel.assertEquals(om.getNsPrefixMap(), om.getBaseModel().getNsPrefixMap());
    }

    public void testPrefixDefaulting() {
        Model base = ModelFactory.createDefaultModel();
        base.setNsPrefix("hedgehog", "http://hedgehog.hog/");
        base.setNsPrefix("daml", "not:the-DAML-URI/");
        base.setNsPrefix("mine", RDF.getURI());
        OntModelImpl m = new OntModelImpl(OntModelSpec.RDFS_MEM, base);
        PrefixMapping given = m.getDocumentManager().getDeclaredPrefixMapping();
        TestOntModel.assertEquals("http://hedgehog.hog/", m.getNsPrefixURI("hedgehog"));
        TestOntModel.assertEquals("not:the-DAML-URI/", m.getNsPrefixURI("daml"));
        TestOntModel.assertEquals(RDF.getURI(), m.getNsPrefixURI("mine"));
        TestOntModel.assertEquals(null, m.getNsPrefixURI("rdf"));
        TestOntModel.assertEquals(given.getNsPrefixURI("rdfs"), m.getNsPrefixURI("rdfs"));
    }

    public void testWritesPrefixes() {
        OntModel om = ModelFactory.createOntologyModel();
        om.setNsPrefix("spoo", "http://spoo.spoo.com/spoo#");
        om.add(TestOntModel.statement(om, "ping http://spoo.spoo.com/spoo#pang pilly"));
        om.add(TestOntModel.statement(om, "gg http://www.daml.org/2001/03/daml+oil#hh ii"));
        StringWriter sw = new StringWriter();
        om.write(sw);
        String s = sw.getBuffer().toString();
        TestOntModel.assertTrue(s.indexOf("xmlns:spoo=\"http://spoo.spoo.com/spoo#\"") > 0);
        TestOntModel.assertTrue(s.indexOf("xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"") > 0);
    }

    public void testWriteWriter() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass A = m.createClass("http://www.hp.com/test#A");
        OntClass B = m.createClass("http://www.hp.com/test#B");
        OntClass C = m.createClass("http://www.hp.com/test#C");
        OntClass D = m.createClass("http://www.hp.com/test#D");
        A.addSubClass(B);
        B.addSubClass(C);
        B.addSubClass(D);
        ObjectProperty p = m.createObjectProperty("http://www.hp.com/test#p");
        p.addDomain(A);
        p.addRange(B);
        p.addRange(C);
        StringWriter out = new StringWriter();
        m.write(out);
        String s = out.toString();
        Model mIn1 = ModelFactory.createDefaultModel();
        mIn1.read(new StringReader(s), BASE);
        Model mIn2 = ModelFactory.createDefaultModel();
        mIn2.read(new StringReader(DOC), BASE);
        TestOntModel.assertTrue("Writer write/read cycle failed (1)", mIn1.isIsomorphicWith(m.getBaseModel()));
        TestOntModel.assertTrue("Writer write/read cycle failed (2)", mIn2.isIsomorphicWith(m.getBaseModel()));
    }

    public void testGetOntology() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        Ontology s = m.createOntology("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getOntology("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getOntology("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getOntology("http://www.hp.com/test#r"));
    }

    public void testGetIndividual() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        Individual s = m.createIndividual("http://www.hp.com/test#s", c);
        TestOntModel.assertEquals("Result of get s", s, m.getIndividual("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getIndividual("http://www.hp.com/test#q"));
    }

    public void testGetOntProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        OntProperty s = m.createOntProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getOntProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getOntProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getOntProperty("http://www.hp.com/test#r"));
    }

    public void testGetObjectProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        ObjectProperty s = m.createObjectProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getObjectProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getObjectProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getObjectProperty("http://www.hp.com/test#r"));
    }

    public void testGetTransitiveProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        TransitiveProperty s = m.createTransitiveProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getTransitiveProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getTransitiveProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getTransitiveProperty("http://www.hp.com/test#r"));
    }

    public void testGetSymmetricProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        SymmetricProperty s = m.createSymmetricProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getSymmetricProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getSymmetricProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getSymmetricProperty("http://www.hp.com/test#r"));
    }

    public void testGetInverseFunctionalProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        InverseFunctionalProperty s = m.createInverseFunctionalProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getInverseFunctionalProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getInverseFunctionalProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getInverseFunctionalProperty("http://www.hp.com/test#r"));
    }

    public void testGetDatatypeProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        DatatypeProperty s = m.createDatatypeProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getDatatypeProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getDatatypeProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getDatatypeProperty("http://www.hp.com/test#r"));
    }

    public void testGetAnnotationProperty() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        AnnotationProperty s = m.createAnnotationProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getAnnotationProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getAnnotationProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getAnnotationProperty("http://www.hp.com/test#r"));
    }

    public void testGetOntResource() {
        OntModel m = ModelFactory.createOntologyModel();
        OntResource r0 = m.getOntResource("http://www.hp.com/test#a");
        TestOntModel.assertNull(r0);
        OntResource r1 = m.createOntResource("http://www.hp.com/test#aaa");
        TestOntModel.assertInstanceOf(OntResource.class, r1);
        Resource r2a = m.getResource("http://www.hp.com/test#a");
        Resource r2b = m.getResource("http://www.hp.com/test#b");
        Property p = m.getProperty("http://www.hp.com/test#p");
        m.add(r2a, p, r2b);
        r0 = m.getOntResource("http://www.hp.com/test#a");
        TestOntModel.assertInstanceOf(OntResource.class, r0);
        OntResource r3 = m.getOntResource(r2b);
        TestOntModel.assertInstanceOf(OntResource.class, r3);
    }

    public void testGetOntClass() {
        OntModel m = ModelFactory.createOntologyModel();
        Resource r = m.getResource("http://www.hp.com/test#r");
        Resource r0 = m.getResource("http://www.hp.com/test#r0");
        m.add(r, RDF.type, r0);
        OntClass s = m.createClass("http://www.hp.com/test#s");
        TestOntModel.assertEquals("Result of get s", s, m.getOntClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getOntClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getOntClass("http://www.hp.com/test#r"));
    }

    public void testGetComplementClass() {
        OntModel m = ModelFactory.createOntologyModel();
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        ComplementClass s = m.createComplementClass("http://www.hp.com/test#s", c);
        TestOntModel.assertEquals("Result of get s", s, m.getComplementClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getComplementClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getComplementClass("http://www.hp.com/test#r"));
    }

    public void testGetEnumeratedClass() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFList l = m.createList();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        EnumeratedClass s = m.createEnumeratedClass("http://www.hp.com/test#s", l);
        TestOntModel.assertEquals("Result of get s", s, m.getEnumeratedClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getEnumeratedClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getEnumeratedClass("http://www.hp.com/test#r"));
    }

    public void testGetUnionClass() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFList l = m.createList();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        UnionClass s = m.createUnionClass("http://www.hp.com/test#s", l);
        TestOntModel.assertEquals("Result of get s", s, m.getUnionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getUnionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getUnionClass("http://www.hp.com/test#r"));
    }

    public void testGetIntersectionClass() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFList l = m.createList();
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        IntersectionClass s = m.createIntersectionClass("http://www.hp.com/test#s", l);
        TestOntModel.assertEquals("Result of get s", s, m.getIntersectionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getIntersectionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getIntersectionClass("http://www.hp.com/test#r"));
    }

    public void testGetRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        Restriction s = m.createRestriction("http://www.hp.com/test#s", p);
        TestOntModel.assertEquals("Result of get s", s, m.getRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getRestriction("http://www.hp.com/test#r"));
    }

    public void testGetHasValueRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        HasValueRestriction s = m.createHasValueRestriction("http://www.hp.com/test#s", p, c);
        TestOntModel.assertEquals("Result of get s", s, m.getHasValueRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getHasValueRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getHasValueRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSomeValuesFromRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        SomeValuesFromRestriction s = m.createSomeValuesFromRestriction("http://www.hp.com/test#s", p, c);
        TestOntModel.assertEquals("Result of get s", s, m.getSomeValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getSomeValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getSomeValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetAllValuesFromRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        OntClass c = m.createClass("http://www.hp.com/test#c");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        AllValuesFromRestriction s = m.createAllValuesFromRestriction("http://www.hp.com/test#s", p, c);
        TestOntModel.assertEquals("Result of get s", s, m.getAllValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getAllValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getAllValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetCardinalityRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        CardinalityRestriction s = m.createCardinalityRestriction("http://www.hp.com/test#s", p, 1);
        TestOntModel.assertEquals("Result of get s", s, m.getCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMinCardinalityRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        MinCardinalityRestriction s = m.createMinCardinalityRestriction("http://www.hp.com/test#s", p, 1);
        TestOntModel.assertEquals("Result of get s", s, m.getMinCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getMinCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getMinCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMaxCardinalityRestriction() {
        OntModel m = ModelFactory.createOntologyModel();
        Property p = m.createProperty("http://www.hp.com/test#p");
        Resource r = m.getResource("http://www.hp.com/test#r");
        m.add(r, RDF.type, r);
        MaxCardinalityRestriction s = m.createMaxCardinalityRestriction("http://www.hp.com/test#s", p, 1);
        TestOntModel.assertEquals("Result of get s", s, m.getMaxCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull("result of get q", m.getMaxCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull("result of get r", m.getMaxCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSubgraphs() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals("Marker count not correct", 4, TestOntDocumentManager.countMarkers(m));
        List subs = m.getSubGraphs();
        TestOntModel.assertEquals("n subgraphs should be ", 3, subs.size());
        boolean isGraph = true;
        Iterator i = subs.iterator();
        while (i.hasNext()) {
            Object x = i.next();
            if (x instanceof Graph) continue;
            isGraph = false;
        }
        TestOntModel.assertTrue("All sub-graphs should be graphs", isGraph);
    }

    public void testListImportURIs() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        Set c = m.listImportedOntologyURIs();
        TestOntModel.assertEquals("Should be two non-closed import URI's", 2, c.size());
        TestOntModel.assertTrue("b should be imported ", c.contains("file:testing/ontology/testImport6/b.owl"));
        TestOntModel.assertFalse("c should not be imported ", c.contains("file:testing/ontology/testImport6/c.owl"));
        TestOntModel.assertTrue("d should be imported ", c.contains("file:testing/ontology/testImport6/d.owl"));
        c = m.listImportedOntologyURIs(true);
        TestOntModel.assertEquals("Should be two non-closed import URI's", 3, c.size());
        TestOntModel.assertTrue("b should be imported ", c.contains("file:testing/ontology/testImport6/b.owl"));
        TestOntModel.assertTrue("c should be imported ", c.contains("file:testing/ontology/testImport6/c.owl"));
        TestOntModel.assertTrue("d should be imported ", c.contains("file:testing/ontology/testImport6/d.owl"));
    }

    public void testListImportedModels() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals("Marker count not correct", 4, TestOntDocumentManager.countMarkers(m));
        ArrayList importModels = new ArrayList();
        ExtendedIterator j = m.listImportedModels();
        while (j.hasNext()) {
            importModels.add(j.next());
        }
        TestOntModel.assertEquals("n import models should be ", 3, importModels.size());
        boolean isOntModel = true;
        int nImports = 0;
        Iterator i = importModels.iterator();
        while (i.hasNext()) {
            Object x = i.next();
            if (!(x instanceof OntModel)) {
                isOntModel = false;
                continue;
            }
            OntModel mi = (OntModel)x;
            nImports += mi.listImportedOntologyURIs().size();
        }
        TestOntModel.assertTrue("All import models should be OntModels", isOntModel);
        TestOntModel.assertEquals("Wrong number of sub-model imports", 2, nImports);
    }

    public void testListSubModels0() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals("Marker count not correct", 4, TestOntDocumentManager.countMarkers(m));
        ArrayList importModels = new ArrayList();
        ExtendedIterator j = m.listSubModels();
        while (j.hasNext()) {
            importModels.add(j.next());
        }
        TestOntModel.assertEquals("n import models should be ", 3, importModels.size());
        boolean isOntModel = true;
        int nImports = 0;
        Iterator i = importModels.iterator();
        while (i.hasNext()) {
            Object x = i.next();
            if (!(x instanceof OntModel)) {
                isOntModel = false;
                continue;
            }
            nImports += ((OntModel)x).countSubModels();
        }
        TestOntModel.assertTrue("All import models should be OntModels", isOntModel);
        TestOntModel.assertEquals("Wrong number of sub-model imports", 0, nImports);
    }

    public void testListSubModels1() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals("Marker count not correct", 4, TestOntDocumentManager.countMarkers(m));
        ArrayList importModels = new ArrayList();
        ExtendedIterator j = m.listSubModels(true);
        while (j.hasNext()) {
            importModels.add(j.next());
        }
        TestOntModel.assertEquals("n import models should be ", 3, importModels.size());
        boolean isOntModel = true;
        int nImports = 0;
        Iterator i = importModels.iterator();
        while (i.hasNext()) {
            Object x = i.next();
            if (!(x instanceof OntModel)) {
                isOntModel = false;
                continue;
            }
            nImports += ((OntModel)x).countSubModels();
        }
        TestOntModel.assertTrue("All import models should be OntModels", isOntModel);
        TestOntModel.assertEquals("Wrong number of sub-model imports", 2, nImports);
    }

    public void testGetImportedModel() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/testImport6/a.owl");
        OntModel m0 = m.getImportedModel("file:testing/ontology/testImport6/b.owl");
        OntModel m1 = m.getImportedModel("file:testing/ontology/testImport6/c.owl");
        OntModel m2 = m.getImportedModel("file:testing/ontology/testImport6/d.owl");
        OntModel m3 = m.getImportedModel("file:testing/ontology/testImport6/b.owl").getImportedModel("file:testing/ontology/testImport6/c.owl");
        OntModel m4 = m.getImportedModel("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertNotNull("Import model b should not be null", m0);
        TestOntModel.assertNotNull("Import model c should not be null", m1);
        TestOntModel.assertNotNull("Import model d should not be null", m2);
        TestOntModel.assertNotNull("Import model b-c should not be null", m3);
        TestOntModel.assertNull("Import model a should be null", m4);
    }

    public void testProfiles() {
        List<Class> notInDL = Arrays.asList(new Class[0]);
        List<Class> notInLite = Arrays.asList(DataRange.class, HasValueRestriction.class);
        Map fullProfileMap = new OWLProfileExt().getSupportsMap();
        Map dlProfileMap = new OWLDLProfileExt().getSupportsMap();
        Map liteProfileMap = new OWLLiteProfileExt().getSupportsMap();
        Iterator i = fullProfileMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry kv = i.next();
            Class c = (Class)kv.getKey();
            TestOntModel.assertTrue("Key in OWL DL profile: " + c.getName(), dlProfileMap.containsKey(c) || notInDL.contains(c));
            TestOntModel.assertTrue("Key in OWL lite profile: " + c.getName(), liteProfileMap.containsKey(c) || notInLite.contains(c));
        }
    }

    public void testBulkAddWorks() {
        OntModel om1 = ModelFactory.createOntologyModel();
        OntModel om2 = ModelFactory.createOntologyModel();
        om1.add(om2);
    }

    public void testRead() {
        String base0 = "http://example.com/test0";
        String ns0 = base0 + "#";
        String base1 = "http://example.com/test1";
        String ns1 = base1 + "#";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        m.getDocumentManager().reset();
        m.getDocumentManager().addAltEntry(base0, "file:testing/ontology/relativenames.rdf");
        m.read(base0, "RDF/XML");
        TestOntModel.assertNotNull("Should be a class ns0:A", m.getOntClass(ns0 + "A"));
        TestOntModel.assertNull("Should not be a class ns1:A", m.getOntClass(ns1 + "A"));
        m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        m.getDocumentManager().reset();
        m.getDocumentManager().addAltEntry(base0, "file:testing/ontology/relativenames.rdf");
        m.read(base0, base1, "RDF/XML");
        TestOntModel.assertNull("Should not be a class ns0:A", m.getOntClass(ns0 + "A"));
        TestOntModel.assertNotNull("Should be a class ns1:A", m.getOntClass(ns1 + "A"));
    }

    public void testListDataRange() {
        String base = "http://jena.hpl.hp.com/test#";
        String doc = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF   xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'   xmlns:owl='http://www.w3.org/2002/07/owl#'>  <owl:DataRange>    <owl:oneOf>      <rdf:List>        <rdf:first rdf:datatype='&xsd;integer'>0</rdf:first>        <rdf:rest rdf:resource='&rdf;nil' />      </rdf:List>    </owl:oneOf>  </owl:DataRange></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        m.read(new StringReader(doc), base);
        ExtendedIterator i = m.listDataRanges();
        TestOntModel.assertTrue("Should be at least one DataRange", i.hasNext());
        Object dr = i.next();
        TestOntModel.assertInstanceOf(DataRange.class, dr);
        TestOntModel.assertFalse("Should no more DataRange", i.hasNext());
    }

    public void testListHierarchyRoots0() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        TestOntModel.assertFalse(m.listHierarchyRootClasses().hasNext());
        m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM);
        TestOntModel.assertFalse(m.listHierarchyRootClasses().hasNext());
    }

    public void testListHierarchyRoots1() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. ";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        m.read(new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a});
    }

    public void testListHierarchyRoots2() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. ";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read(new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a});
    }

    public void testListHierarchyRoots3() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. :B a owl:Class ; rdfs:subClassOf :A . ";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_MINI_RULE_INF, null);
        m.read(new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a});
    }

    public void testListHierarchyRoots4() {
        String doc = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a rdfs:Class. :C a rdfs:Class. :B a rdfs:Class ; rdfs:subClassOf :A . ";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_RDFS_INF, null);
        m.read(new StringReader(doc), NS, "N3");
        OntClass a = m.getOntClass("http://www.hp.com/test#A");
        OntClass c = m.getOntClass("http://www.hp.com/test#C");
        TestUtil.assertIteratorValues(this, m.listHierarchyRootClasses(), new Object[]{a, c});
    }

    public void testLoadImports0() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.add(a, m.getProfile().IMPORTS(), b);
        TestOntModel.assertEquals("Marker count not correct", 0, TestOntDocumentManager.countMarkers(m));
        TestOntModel.assertFalse("c should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertFalse("b should not be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.loadImports();
        TestOntModel.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(m));
        TestOntModel.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    public void testLoadImports1() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        Resource a = m.getResource("file:testing/ontology/testImport3/a.owl");
        Resource b = m.getResource("file:testing/ontology/testImport3/b.owl");
        m.setDynamicImports(true);
        m.add(a, m.getProfile().IMPORTS(), b);
        TestOntModel.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(m));
        TestOntModel.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
        m.loadImports();
        TestOntModel.assertEquals("Marker count not correct", 2, TestOntDocumentManager.countMarkers(m));
        TestOntModel.assertTrue("c should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/c.owl"));
        TestOntModel.assertTrue("b should be imported", m.hasLoadedImport("file:testing/ontology/testImport3/b.owl"));
    }

    protected class OWLLiteProfileExt
    extends OWLLiteProfile {
        protected OWLLiteProfileExt() {
        }

        public Map getSupportsMap() {
            return this.getCheckTable();
        }
    }

    protected class OWLDLProfileExt
    extends OWLDLProfile {
        protected OWLDLProfileExt() {
        }

        public Map getSupportsMap() {
            return this.getCheckTable();
        }
    }

    protected class OWLProfileExt
    extends OWLProfile {
        protected OWLProfileExt() {
        }

        public Map getSupportsMap() {
            return this.getCheckTable();
        }
    }
}

