/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.HitLARQ;
import com.hp.hpl.jena.query.larq.ScoreTest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.sparql.util.IteratorTruncate;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class IndexLARQ {
    private static Log log = LogFactory.getLog(IndexLARQ.class);
    private IndexReader reader = null;
    private QueryParser luceneQueryParser = null;

    public IndexLARQ(IndexReader r) {
        this(r, new StandardAnalyzer());
    }

    public IndexLARQ(IndexReader r, Analyzer a) {
        this(r, new QueryParser("index", a));
    }

    public IndexLARQ(IndexReader r, QueryParser qp) {
        this.reader = r;
        this.luceneQueryParser = qp;
    }

    public NodeIterator searchModelByIndex(String queryString) {
        return this.searchModelByIndex(null, queryString);
    }

    public NodeIterator searchModelByIndex(Model model, String queryString) {
        return this.searchModelByIndex(model, queryString, 0.0f);
    }

    public NodeIterator searchModelByIndex(final Model model, String queryString, float scoreLimit) {
        Map1 converter = new Map1(){

            public Object map1(Object object) {
                HitLARQ x = (HitLARQ)object;
                return ModelUtils.convertGraphNodeToRDFNode(x.getNode(), model);
            }
        };
        ClosableIterator iter = new Map1Iterator(converter, this.search(queryString));
        if (scoreLimit > 0.0f) {
            iter = new IteratorTruncate(new ScoreTest(scoreLimit), iter);
        }
        NodeIteratorImpl nIter = new NodeIteratorImpl((Iterator)iter, null);
        return nIter;
    }

    public boolean hasMatch(String queryString) {
        Iterator iter = this.search(queryString);
        return iter.hasNext();
    }

    public Iterator search(String queryString) {
        try {
            IndexSearcher searcher = new IndexSearcher(this.reader);
            Query query2 = this.luceneQueryParser.parse(queryString);
            if (log.isDebugEnabled()) {
                log.debug("Search: (" + query2.toString() + ")");
            }
            Hits hits = searcher.search(query2);
            Map1 converter = new Map1(){

                public Object map1(Object object) {
                    Hit h = (Hit)object;
                    return new HitLARQ(h);
                }
            };
            Map1Iterator iter = new Map1Iterator(converter, hits.iterator());
            return iter;
        }
        catch (Exception e2) {
            throw new ARQLuceneException("search", e2);
        }
    }

    public HitLARQ contains(Node node, String queryString) {
        try {
            Iterator iter = this.search(queryString);
            while (iter.hasNext()) {
                HitLARQ x = (HitLARQ)iter.next();
                if (x == null || !x.getNode().equals(node)) continue;
                return x;
            }
            return null;
        }
        catch (Exception e2) {
            throw new ARQLuceneException("contains", e2);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e2) {
            throw new ARQLuceneException("close", e2);
        }
    }
}

