/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestResourceFactory
extends TestCase {
    static final String uri1 = "http://example.org/example#a1";
    static final String uri2 = "http://example.org/example#a2";

    public static TestSuite suite() {
        return new TestSuite(TestResourceFactory.class);
    }

    public TestResourceFactory(String name) {
        super(name);
    }

    public void testCreateResource() {
        Resource r1 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue(r1.isAnon());
        Resource r2 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue(r2.isAnon());
        TestResourceFactory.assertTrue(!((Object)r1).equals(r2));
        r1 = ResourceFactory.createResource(uri1);
        TestResourceFactory.assertTrue(r1.getURI().equals(uri1));
    }

    public void testCreateProperty() {
        Property p1 = ResourceFactory.createProperty(uri1);
        TestResourceFactory.assertTrue(p1.getURI().equals(uri1));
        Property p2 = ResourceFactory.createProperty(uri1, "2");
        TestResourceFactory.assertTrue(p2.getURI().equals("http://example.org/example#a12"));
    }

    public void testCreateLiteral() {
        Literal l = ResourceFactory.createPlainLiteral("lex");
        TestResourceFactory.assertTrue(l.getLexicalForm().equals("lex"));
        TestResourceFactory.assertTrue(l.getLanguage().equals(""));
        TestResourceFactory.assertNull(l.getDatatype());
        TestResourceFactory.assertNull(l.getDatatypeURI());
    }

    public void testCreateTypedLiteral() {
        Literal l = ResourceFactory.createTypedLiteral("22", XSDDatatype.XSDinteger);
        TestResourceFactory.assertTrue(l.getLexicalForm().equals("22"));
        TestResourceFactory.assertTrue(l.getLanguage().equals(""));
        TestResourceFactory.assertTrue(l.getDatatype() == XSDDatatype.XSDinteger);
        TestResourceFactory.assertTrue(l.getDatatypeURI().equals(XSDDatatype.XSDinteger.getURI()));
    }

    public void testCreateTypedLiteralObject() {
        Literal l = ResourceFactory.createTypedLiteral(new Integer(22));
        TestResourceFactory.assertEquals("22", l.getLexicalForm());
        TestResourceFactory.assertEquals("", l.getLanguage());
        TestResourceFactory.assertEquals(XSDDatatype.XSDint, l.getDatatype());
    }

    public void testCreateStatement() {
        Resource s = ResourceFactory.createResource();
        Property p = ResourceFactory.createProperty(uri2);
        Resource o = ResourceFactory.createResource();
        Statement stmt = ResourceFactory.createStatement(s, p, o);
        TestResourceFactory.assertTrue(((Object)stmt.getSubject()).equals(s));
        TestResourceFactory.assertTrue(stmt.getPredicate().equals(p));
        TestResourceFactory.assertTrue(stmt.getObject().equals(o));
    }

    public void testGetInstance() {
        ResourceFactory.Interface factory = ResourceFactory.getInstance();
        Resource r1 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue(r1.isAnon());
        Resource r2 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue(r2.isAnon());
        TestResourceFactory.assertTrue(!((Object)r1).equals(r2));
    }

    public void testSetInstance() {
        Resource r = ResourceFactory.createResource();
        TestFactory factory = new TestFactory(r);
        ResourceFactory.setInstance(factory);
        TestResourceFactory.assertTrue(factory.equals(ResourceFactory.getInstance()));
        TestResourceFactory.assertTrue(ResourceFactory.createResource() == r);
    }

    class TestFactory
    implements ResourceFactory.Interface {
        Resource resource;

        TestFactory(Resource r) {
            this.resource = r;
        }

        public Resource createResource() {
            return this.resource;
        }

        public Resource createResource(String uriref) {
            return null;
        }

        public Literal createPlainLiteral(String string) {
            return null;
        }

        public Literal createTypedLiteral(String string, RDFDatatype datatype) {
            return null;
        }

        public Literal createTypedLiteral(Object value) {
            return null;
        }

        public Property createProperty(String uriref) {
            return null;
        }

        public Property createProperty(String namespace2, String localName) {
            return null;
        }

        public Statement createStatement(Resource subject, Property predicate, RDFNode object) {
            return null;
        }
    }
}

