/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestResourceImpl
extends ModelTestBase {
    public TestResourceImpl(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestResourceImpl.class);
    }

    public void testCannotAsNonLiteral() {
        Model m = ModelFactory.createDefaultModel();
        TestResourceImpl.resource(m, "plumPie").as(Resource.class);
    }

    public void testAsLiteral() {
        Model m = ModelFactory.createDefaultModel();
        try {
            TestResourceImpl.literal(m, "17").as(Resource.class);
            TestResourceImpl.fail("literals cannot be resources");
        }
        catch (ResourceRequiredException e2) {
            TestResourceImpl.pass();
        }
    }

    public void testNameSpace() {
        TestResourceImpl.assertEquals("eh:x", TestResourceImpl.resource("eh:xyz").getNameSpace());
        TestResourceImpl.assertEquals("http://d/", TestResourceImpl.resource("http://d/stuff").getNameSpace());
        TestResourceImpl.assertEquals("ftp://dd.com/12345", TestResourceImpl.resource("ftp://dd.com/12345").getNameSpace());
        TestResourceImpl.assertEquals("http://domain/spoo#", TestResourceImpl.resource("http://domain/spoo#anchor").getNameSpace());
        TestResourceImpl.assertEquals("ftp://abd/def#ghi#", TestResourceImpl.resource("ftp://abd/def#ghi#e11-2").getNameSpace());
    }

    public void testLocalName() {
        TestResourceImpl.assertEquals("yz", TestResourceImpl.resource("eh:xyz").getLocalName());
    }

    public void testHasURI() {
        TestResourceImpl.assertTrue(TestResourceImpl.resource("eh:xyz").hasURI("eh:xyz"));
        TestResourceImpl.assertFalse(TestResourceImpl.resource("eh:xyz").hasURI("eh:1yz"));
        TestResourceImpl.assertFalse(ResourceFactory.createResource().hasURI("42"));
    }
}

