/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBugs
extends TestCase {
    public static final String INPUT_SUBCLASS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns:ex=\"http://localhost:8080/axis/daml/a.daml#\"    xml:base=\"http://localhost:8080/axis/daml/a.daml\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"cls1\"/>    <daml:Class rdf:ID=\"cls2\">        <daml:subClassOf rdf:resource=\"#cls1\"/>    </daml:Class>    <ex:cls2 rdf:ID=\"test\"/></rdf:RDF>";
    public static final String INPUT_SUBPROPERTY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns=\"urn:x-hp-jena:test#\"    xml:base=\"urn:x-hp-jena:test\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"A\"/>    <daml:ObjectProperty rdf:ID=\"p\" />    <daml:ObjectProperty rdf:ID=\"q\">        <daml:subPropertyOf rdf:resource=\"#p\"/>    </daml:ObjectProperty>    <A rdf:ID=\"a0\"/>    <A rdf:ID=\"a1\">       <q rdf:resource=\"#a0\" />    </A></rdf:RDF>";

    public TestBugs(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBugs.class);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testIntersectionNPE() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/bad-intersection.owl");
        boolean foundBadList = false;
        try {
            InfGraph infgraph = ReasonerRegistry.getOWLReasoner().bind(base.getGraph());
            ExtendedIterator ci = infgraph.find(null, RDF.Nodes.type, OWL.Class.asNode());
            ci.close();
        }
        catch (ReasonerException e2) {
            foundBadList = true;
        }
        TestBugs.assertTrue("Correctly detected the illegal list", foundBadList);
    }

    public void testCardinality1() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/cardFPTest.owl");
        InfModel test = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), base);
        String NAMESPACE = "urn:foo#";
        Resource aDocument = test.getResource(NAMESPACE + "aDocument");
        Resource documentType = test.getResource(NAMESPACE + "Document");
        TestBugs.assertTrue("Cardinality-based classification", test.contains(aDocument, RDF.type, documentType));
    }

    public void testFunctorCCE() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/cceTest.owl");
        InfModel test = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), base);
        boolean b = this.anyInstancesOfNothing(test);
        ResIterator rIter = test.listSubjects();
        while (rIter.hasNext()) {
            Resource res = rIter.nextResource();
        }
    }

    private boolean anyInstancesOfNothing(Model model) {
        boolean hasAny = false;
        try {
            StmtIterator it = model.listStatements(null, RDF.type, OWL.Nothing);
            hasAny = it.hasNext();
            it.close();
        }
        catch (ConversionException x) {
            hasAny = false;
        }
        return hasAny;
    }

    public void testDAMLCCE() {
        DAMLModel m = ModelFactory.createDAMLModel();
        m.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        m.read("file:testing/reasoners/bugs/literalLeak.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        ResIterator rIter = m.listSubjects();
        while (rIter.hasNext()) {
            Resource res = rIter.nextResource();
            if (!res.asNode().isLiteral()) continue;
            TestBugs.assertTrue("Error in resource " + res, false);
        }
    }

    public void testSubClass() {
        OntModel model = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RDFS_INF, null);
        model.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        String base = "http://localhost:8080/axis/daml/a.daml#";
        model.read(new ByteArrayInputStream(INPUT_SUBCLASS.getBytes()), base);
        OntResource res = (OntResource)model.getResource(base + "test").as(OntResource.class);
        OntClass cls1 = (OntClass)model.getResource(base + "cls1").as(OntClass.class);
        OntClass cls2 = (OntClass)model.getResource(base + "cls2").as(OntClass.class);
        TestBugs.assertTrue("cls2 should be a super-class of cls1", cls2.hasSuperClass(cls1));
        TestBugs.assertTrue("res should have rdf:type cls1", res.hasRDFType(cls1));
        TestBugs.assertTrue("res should have rdf:type cls2", res.hasRDFType(cls2));
    }

    public void testSubProperty() {
        OntModel model = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RDFS_INF, null);
        String base = "urn:x-hp-jena:test#";
        model.read(new ByteArrayInputStream(INPUT_SUBPROPERTY.getBytes()), base);
        OntResource a0 = (OntResource)model.getResource(base + "a0").as(OntResource.class);
        OntResource a1 = (OntResource)model.getResource(base + "a1").as(OntResource.class);
        ObjectProperty p = model.getObjectProperty(base + "p");
        ObjectProperty q = model.getObjectProperty(base + "q");
        TestBugs.assertTrue("subProp relation present", q.hasProperty(RDFS.subPropertyOf, p));
        TestBugs.assertTrue("a1 q a0", a1.hasProperty((Property)q, a0));
        TestBugs.assertTrue("a1 p a0", a1.hasProperty((Property)p, a0));
    }

    public void testEquivalentClass1() {
        Model base = ModelFactory.createDefaultModel();
        base.read("file:testing/reasoners/bugs/equivalentClassTest.owl");
        InfModel test = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), base);
        String NAMESPACE = "urn:foo#";
        Resource A = test.getResource(NAMESPACE + "A");
        Resource B = test.getResource(NAMESPACE + "B");
        TestBugs.assertTrue("hasValue equiv deduction", test.contains(A, OWL.equivalentClass, B));
    }

    public void testOWLPropertyAxioms() {
        Model data = ModelFactory.createDefaultModel();
        Resource fp = data.createResource("urn:x-hp:eg/fp");
        Resource ifp = data.createResource("urn:x-hp:eg/ifp");
        Resource tp = data.createResource("urn:x-hp:eg/tp");
        Resource sp = data.createResource("urn:x-hp:eg/sp");
        data.add(fp, RDF.type, OWL.FunctionalProperty);
        data.add(ifp, RDF.type, OWL.InverseFunctionalProperty);
        data.add(tp, RDF.type, OWL.TransitiveProperty);
        data.add(sp, RDF.type, OWL.SymmetricProperty);
        InfModel infmodel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), data);
        TestBugs.assertTrue("property class axioms", infmodel.contains(fp, RDF.type, RDF.Property));
        TestBugs.assertTrue("property class axioms", infmodel.contains(ifp, RDF.type, RDF.Property));
        TestBugs.assertTrue("property class axioms", infmodel.contains(tp, RDF.type, RDF.Property));
        TestBugs.assertTrue("property class axioms", infmodel.contains(sp, RDF.type, RDF.Property));
        TestBugs.assertTrue("property class axioms", infmodel.contains(ifp, RDF.type, OWL.ObjectProperty));
        TestBugs.assertTrue("property class axioms", infmodel.contains(tp, RDF.type, OWL.ObjectProperty));
        TestBugs.assertTrue("property class axioms", infmodel.contains(sp, RDF.type, OWL.ObjectProperty));
    }

    public void testDeleteBug() {
        Model modelo = ModelFactory.createDefaultModel();
        modelo.read("file:testing/reasoners/bugs/deleteBug.owl");
        OntModel modeloOnt = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, modelo);
        Individual indi = modeloOnt.getIndividual("http://decsai.ugr.es/~ontoserver/bacarex2.owl#JS");
        indi.remove();
        StmtIterator it = modeloOnt.listStatements((Resource)indi, null, (RDFNode)null);
        boolean ok = !it.hasNext();
        it.close();
        TestBugs.assertTrue(ok);
    }

    public void testDeteleBug2() {
        Model m = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Resource r = m.createResource(NS + "r");
        Resource A = m.createResource(NS + "A");
        Resource B = m.createResource(NS + "B");
        Statement s = m.createStatement(r, RDF.type, A);
        m.add(s);
        String rules = "(?r rdf:type eg:A) -> (?r rdf:type eg:B).";
        GenericRuleReasoner grr = new GenericRuleReasoner(Rule.parseRules(rules));
        InfModel im = ModelFactory.createInfModel(grr, m);
        TestBugs.assertTrue(im.contains(r, RDF.type, B));
        TestBugs.assertTrue(im.getDeductionsModel().contains(r, RDF.type, B));
        im.remove(s);
        TestBugs.assertFalse(im.contains(r, RDF.type, B));
        TestBugs.assertFalse(im.getDeductionsModel().contains(r, RDF.type, B));
    }

    public void hiddenTestOWLLoop() {
        Model data = FileManager.get().loadModel("file:testing/reasoners/bugs/loop.owl");
        InfModel infmodel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), data);
        ((FBRuleInfGraph)infmodel.getGraph()).setTraceOn(true);
        String baseURI = "http://jena.hpl.hp.com/eg#";
        Resource C = infmodel.getResource(baseURI + "C");
        Resource I = infmodel.getResource(baseURI + "i");
        Property R = infmodel.getProperty(baseURI, "R");
        System.out.println("Check that the instance does have an R property");
        Statement s = I.getProperty(R);
        System.out.println(" - " + s);
        System.out.println("And that the type of the R property is C");
        Statement s2 = ((Resource)s.getObject()).getProperty(RDF.type);
        System.out.println(" - " + s2);
        System.out.println("But does that have an R property?");
        Statement s3 = ((Resource)s.getObject()).getProperty(R);
        System.out.println(" - " + s3);
        System.out.println("List all instances of C");
        int count = 0;
        StmtIterator i = infmodel.listStatements(null, RDF.type, C);
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            System.out.println(" - " + st);
            ++count;
        }
        System.out.println("OK");
    }

    public void testRangeBug() {
        Model model = FileManager.get().loadModel("file:testing/reasoners/bugs/rangeBug.owl");
        Model m = ModelFactory.createDefaultModel();
        Reasoner r = ReasonerRegistry.getOWLReasoner();
        InfModel omodel = ModelFactory.createInfModel(r, model);
        String baseuri = "http://decsai.ugr.es/~ontoserver/bacarex2.owl#";
        Resource js = omodel.getResource(baseuri + "JS");
        Resource surname = omodel.getResource(baseuri + "surname");
        Statement s = omodel.createStatement(surname, RDFS.range, OWL.Nothing);
        TestBugs.assertTrue(!omodel.contains(s));
    }

    public void testLiteralBug() {
        Model model = FileManager.get().loadModel("file:testing/reasoners/bugs/dtValidation.owl");
        Model m = ModelFactory.createDefaultModel();
        Reasoner r = ReasonerRegistry.getOWLReasoner();
        InfModel infmodel = ModelFactory.createInfModel(r, model);
        ValidityReport validity = infmodel.validate();
        TestBugs.assertTrue(validity.isValid());
    }

    public void testHide() {
        String NS = "http://jena.hpl.hp.com/bugs#";
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        OntClass c = m.createClass(NS + "C");
        Individual i = m.createIndividual(c);
        StmtIterator res = m.listStatements(null, RDF.type, c);
        TestUtil.assertIteratorValues(this, res, new Statement[]{m.createStatement((Resource)i, RDF.type, c)});
    }

    public void testHideXSDRange() {
        OntModelSpec[] specs = new OntModelSpec[]{OntModelSpec.OWL_MEM_RULE_INF, OntModelSpec.OWL_MEM_RDFS_INF, OntModelSpec.OWL_MEM_MINI_RULE_INF, OntModelSpec.OWL_MEM_MICRO_RULE_INF};
        for (int os = 0; os < specs.length; ++os) {
            OntModelSpec spec = specs[os];
            OntModel m = ModelFactory.createOntologyModel(spec, null);
            ExtendedIterator i = m.listOntProperties();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                if (r.getURI() == null || !r.getURI().startsWith("urn:x-hp-jena:rubrik/")) continue;
                TestBugs.assertTrue("Rubrik internal property leaked out: " + r + "(" + os + ")", false);
            }
        }
    }

    public void testBindSchemaValidate() {
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        Model schema = FileManager.get().loadModel("file:testing/reasoners/bugs/sbug.owl");
        Model data = FileManager.get().loadModel("file:testing/reasoners/bugs/sbug.rdf");
        InfModel infu = ModelFactory.createInfModel(reasoner, data.union(schema));
        ValidityReport validity = infu.validate();
        TestBugs.assertTrue(!validity.isValid());
        InfModel inf = ModelFactory.createInfModel(reasoner.bindSchema(schema), data);
        validity = inf.validate();
        TestBugs.assertTrue(!validity.isValid());
    }

    public void testGenericDeleteBug() {
        Model data = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Property p = data.createProperty(NS, "p");
        Resource x = data.createResource(NS + "x");
        Resource y = data.createResource(NS + "y");
        Statement sy = data.createStatement(y, p, "foo");
        data.add(sy);
        data.add(x, p, "foo");
        String rule = "[(?x eg:p ?m) (?y eg:p ?m) -> (?x eg:same ?y) (?y eg:same ?x)]";
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        reasoner.setRules(Rule.parseRules(rule));
        InfModel inf = ModelFactory.createInfModel(reasoner, data);
        TestUtil.assertIteratorLength(inf.listStatements(y, null, (RDFNode)null), 3);
        inf.remove(sy);
        TestUtil.assertIteratorLength(inf.listStatements(y, null, (RDFNode)null), 0);
    }

    public void testRETEInc() {
        String rule = "(?x ?p ?y) -> (?p rdf:type rdf:Property) .";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules(rule));
        InfModel m = ModelFactory.createInfModel(r, ModelFactory.createDefaultModel());
        Resource source = m.createResource("urn:alfie:testResource");
        Property prop = m.createProperty("urn:alfie:testProperty");
        Statement s1 = m.createStatement(source, prop, "value1");
        Statement s2 = m.createStatement(source, prop, "value2");
        m.add(s1);
        this.assertIsProperty(m, prop);
        m.add(s2);
        m.remove(s1);
        this.assertIsProperty(m, prop);
    }

    public void testRETEDec() {
        String rule = "(?x ?p ?y) -> (?p rdf:type rdf:Property) .";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules(rule));
        InfModel m = ModelFactory.createInfModel(r, ModelFactory.createDefaultModel());
        Resource source = m.createResource("urn:alfie:testResource");
        Property prop = m.createProperty("urn:alfie:testProperty");
        Statement s1 = m.createStatement(source, prop, "value1");
        Statement s2 = m.createStatement(source, prop, "value2");
        m.add((Resource)prop, RDF.type, RDF.Property);
        m.add(s1);
        m.prepare();
        m.remove(s1);
        this.assertIsProperty(m, prop);
    }

    private void assertIsProperty(Model m, Property prop) {
        TestBugs.assertTrue(m.contains((Resource)prop, RDF.type, RDF.Property));
    }

    public void testHideOnOWLThing() {
        Reasoner r = ReasonerRegistry.getOWLReasoner();
        Model data = ModelFactory.createDefaultModel();
        InfModel inf = ModelFactory.createInfModel(r, data);
        StmtIterator things = inf.listStatements(null, RDF.type, OWL.Thing);
        TestUtil.assertIteratorLength(things, 0);
    }

    public void testSomeDatatype() throws IOException {
        String uri = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String filename = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper tm = TypeMapper.getInstance();
        XSDDatatype.loadUserDefined(uri, new FileReader(filename), null, tm);
        Model data = ModelFactory.createDefaultModel();
        data.read("file:testing/reasoners/bugs/userDatatypes.owl");
        InfModel inf = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), data);
        String egNS = "http://jena.hpl.hp.com/eg#";
        Resource meR = inf.getResource(egNS + "me");
        Resource TestR = inf.getResource(egNS + "Test");
        TestBugs.assertTrue("somevalues inf for datatypes", inf.contains(meR, RDF.type, TestR));
        Resource Test2R = inf.getResource(egNS + "Test2");
        Resource me2R = inf.getResource(egNS + "me2");
        TestBugs.assertTrue("somevalues inf for datatypes", inf.contains(me2R, RDF.type, Test2R));
        TestBugs.assertTrue("somevalues inf for user datatypes", inf.contains(meR, RDF.type, Test2R));
    }

    public void testDAMLMicroReasonerSupports() {
        Reasoner r = DAMLMicroReasonerFactory.theInstance().create(null);
        TestBugs.assertTrue("Should support daml:subClassOf", r.supportsProperty(DAML_OIL.subClassOf));
        TestBugs.assertTrue("Should support daml:subPropertyOf", r.supportsProperty(DAML_OIL.subPropertyOf));
        TestBugs.assertTrue("Should support daml:domain", r.supportsProperty(DAML_OIL.domain));
        TestBugs.assertTrue("Should support daml:range", r.supportsProperty(DAML_OIL.range));
    }

    public static Model modelFromN3(String src) {
        String fullSource = "@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix eg: <http://jena.hpl.hp.com/eg#> .\n@prefix : <#> .\n" + src + "\n";
        Model result = ModelFactory.createDefaultModel();
        result.read(new StringReader(fullSource), "", "N3");
        return result;
    }

    public void test_oh_01() {
        String NS = "http://www.idi.ntnu.no/~herje/ja/";
        Resource[] expected = new Resource[]{ResourceFactory.createResource(NS + "reiseliv.owl#Reiseliv"), ResourceFactory.createResource(NS + "hotell.owl#Hotell"), ResourceFactory.createResource(NS + "restaurant.owl#Restaurant"), ResourceFactory.createResource(NS + "restaurant.owl#UteRestaurant"), ResourceFactory.createResource(NS + "restaurant.owl#UteBadRestaurant"), ResourceFactory.createResource(NS + "restaurant.owl#UteDoRestaurant"), ResourceFactory.createResource(NS + "restaurant.owl#SkogRestaurant")};
        this.test_oh_01scan(OntModelSpec.OWL_MEM, "No inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MINI_RULE_INF, "Mini rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MICRO_RULE_INF, "Micro rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_RULE_INF, "Full rule inf", expected);
    }

    public void test_der_validation() {
        Model abox = FileManager.get().loadModel("file:testing/reasoners/owl/nondetbug.rdf");
        List rules = FBRuleReasoner.loadRules("testing/reasoners/owl/nondetbug.rules");
        GenericRuleReasoner r = new GenericRuleReasoner(rules);
        for (int i = 0; i < 10; ++i) {
            InfModel im = ModelFactory.createInfModel(r, abox);
            TestBugs.assertTrue("failed on count " + i, im.contains(null, ReasonerVocabulary.RB_VALIDATION_REPORT, (RDFNode)null));
        }
    }

    private void test_oh_01scan(OntModelSpec s, String prompt, Resource[] expected) {
        String NS = "http://www.idi.ntnu.no/~herje/ja/reiseliv.owl#";
        OntModel m = ModelFactory.createOntologyModel(s, null);
        m.read("file:testing/ontology/bugs/test_oh_01.owl");
        OntClass r = m.getOntClass(NS + "Reiseliv");
        ArrayList<OntClass> q = new ArrayList<OntClass>();
        HashSet<OntClass> seen = new HashSet<OntClass>();
        q.add(r);
        while (!q.isEmpty()) {
            OntClass c = (OntClass)q.remove(0);
            seen.add(c);
            ExtendedIterator i = c.listSubClasses(true);
            while (i.hasNext()) {
                OntClass sub = (OntClass)i.next();
                if (seen.contains(sub)) continue;
                q.add(sub);
            }
        }
        int mask = (1 << expected.length) - 1;
        for (int j = 0; j < expected.length; ++j) {
            if (!seen.contains(expected[j])) continue;
            mask &= ~(1 << j);
        }
        Iterator k = seen.iterator();
        while (k.hasNext()) {
            Resource res = (Resource)k.next();
            boolean isExpected = false;
            for (int j = 0; !isExpected && j < expected.length; ++j) {
                isExpected = ((Object)expected[j]).equals(res);
            }
            if (isExpected) continue;
        }
        TestBugs.assertEquals("Some expected results were not seen", 0, mask);
    }

    public void test_domainInf() {
        OntModel m = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        String NS = "http://m3t4.com/ont/#";
        OntClass c1 = m.createClass(NS + "c1");
        OntClass c2 = m.createClass(NS + "c2");
        OntClass c3 = m.createClass(NS + "c3");
        ObjectProperty p1 = m.createObjectProperty(NS + "p1");
        UnionClass uc = m.createUnionClass(null, null);
        uc.addOperand(c1);
        TestBugs.assertEquals("Size should be 1", 1, uc.getOperands().size());
        TestBugs.assertTrue("uc should have c1 as union member", uc.getOperands().contains(c1));
        uc.addOperand(c2);
        TestBugs.assertEquals("Size should be 2", 2, uc.getOperands().size());
        TestUtil.assertIteratorValues(this, uc.listOperands(), new Object[]{c1, c2});
        uc.addOperand(c3);
        TestBugs.assertEquals("Size should be 3", 3, uc.getOperands().size());
        TestUtil.assertIteratorValues(this, uc.listOperands(), new Object[]{c1, c2, c3});
        p1.addDomain(uc);
    }

    public void testNonmonotonicCR() {
        String ruleSrc = "(eg:IndA eg:scoreA ?score), sum(?score 40 ?total), noValue(eg:IndA eg:flag_1 'true') -> drop(0), (eg:IndA eg:scoreA ?total), (eg:IndA eg:flag_1 'true').(eg:IndA eg:scoreA ?score), sum(?score 33 ?total), noValue(eg:IndA eg:flag_2 'true') -> drop(0), (eg:IndA eg:scoreA ?total), (eg:IndA eg:flag_2 'true').";
        List rules = Rule.parseRules(ruleSrc);
        Model data = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Resource i = data.createResource(NS + "IndA");
        Property scoreA = data.createProperty(NS, "scoreA");
        i.addProperty(scoreA, data.createTypedLiteral(100));
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel inf = ModelFactory.createInfModel(reasoner, data);
        NodeIterator values = inf.listObjectsOfProperty(i, scoreA);
        TestUtil.assertIteratorValues(this, values, new Object[]{data.createTypedLiteral(173)});
    }

    public void testIncrementalIU() {
        OntModel ontmodel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_MINI_RULE_INF);
        String homeuri = "http://abc/bcd/";
        Object[] ind = new Individual[6];
        OntClass classb = ontmodel.createClass(homeuri + "C");
        for (int i = 0; i < 6; ++i) {
            ind[i] = classb.createIndividual(homeuri + String.valueOf(i));
        }
        Object[] subind = new Individual[]{ind[0], ind[1], ind[2]};
        EnumeratedClass class1 = ontmodel.createEnumeratedClass(homeuri + "C1", ontmodel.createList((RDFNode[])subind));
        EnumeratedClass class2 = ontmodel.createEnumeratedClass(homeuri + "C2", ontmodel.createList((RDFNode[])ind));
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass classI = ontmodel.createIntersectionClass(null, list);
        UnionClass classU = ontmodel.createUnionClass(null, list);
        TestUtil.assertIteratorValues(this, classI.listInstances(), subind);
        TestUtil.assertIteratorValues(this, classU.listInstances(), ind);
    }

    public void testFactRules() {
        Model facts = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Property p = facts.createProperty(NS + "p");
        List rules = Rule.parseRules("makeTemp(?x) -> (?x, eg:p, eg:z). makeTemp(?x) makeTemp(?y) -> (?x, eg:p, ?y) . (?x, eg:p, eg:z) -> (?a, eg:p, eg:b). -> [ (eg:a eg:p eg:y) <- ].");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel inf = ModelFactory.createInfModel(reasoner, facts);
        inf.prepare();
        TestUtil.assertIteratorLength(inf.listStatements(null, p, (RDFNode)null), 4);
    }

    public void testFactChainRules() {
        Model facts = ModelFactory.createDefaultModel();
        String NS = "urn:x-hp:eg/";
        Property mother = facts.createProperty(NS + "mother");
        Property female = facts.createProperty(NS + "Female");
        mother.addProperty(RDFS.range, female);
        List rules = Rule.parseRules("-> tableAll(). \n[rdfs6:  (?p rdfs:subPropertyOf ?q), notEqual(?p,?q) -> [ (?a ?q ?b) <- (?a ?p ?b)] ] \n-> (eg:range rdfs:subPropertyOf rdfs:range). \n-> (rdfs:range rdfs:subPropertyOf eg:range). \n");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setTransitiveClosureCaching(true);
        InfModel inf = ModelFactory.createInfModel(reasoner, facts);
        Property egRange = inf.createProperty(NS + "range");
        TestUtil.assertIteratorValues(this, inf.listStatements(null, egRange, (RDFNode)null), new Object[]{inf.createStatement((Resource)mother, egRange, female)});
    }

    public void testEmptyRemove() {
        List rules = Rule.parseRules("-> (eg:i eg:prop eg:foo) .(?X eg:prop ?V) -> (?X eg:prop2 ?V) .(?X eg:prop eg:foo) noValue(?X eg:guard 'done') -> remove(0) (?X eg:guard 'done') .");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        InfModel im = ModelFactory.createInfModel(reasoner, ModelFactory.createDefaultModel());
        Resource i = im.createResource("urn:x-hp:eg/i");
        Property guard = im.createProperty("urn:x-hp:eg/guard");
        TestUtil.assertIteratorValues(this, im.listStatements(), new Object[]{im.createStatement(i, guard, "done")});
    }

    public void testBackwardDupRemoval() {
        String NS = "urn:x-hp:eg/";
        Model base = ModelFactory.createDefaultModel();
        Resource i = base.createResource(NS + "i");
        Resource a = base.createResource(NS + "a");
        Property p = base.createProperty(NS, "p");
        Property q = base.createProperty(NS, "q");
        Property r = base.createProperty(NS, "r");
        base.add(i, p, a);
        base.add(i, q, a);
        List rules = Rule.parseRules("(eg:i eg:r eg:a) <- (eg:i eg:p eg:a). (eg:i eg:r eg:a) <- (eg:i eg:q eg:a).");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setMode(GenericRuleReasoner.BACKWARD);
        InfModel im = ModelFactory.createInfModel(reasoner, base);
        TestUtil.assertIteratorLength(im.listStatements(i, r, a), 1);
    }

    public void testGroundClosure() {
        Flag myFlag = new Flag();
        BuiltinRegistry.theRegistry.register(myFlag);
        String NS = "http://ont.com/";
        PrintUtil.registerPrefix("ns", NS);
        String rules = "[r1: (ns:a ns:p ns:b) <- (ns:a ns:p ns:a)] [r2: (ns:a ns:p ns:b) <- flag()] [rt: (?a ns:q ?b) <- (?a ns:p ?b)] ";
        Model m = ModelFactory.createDefaultModel();
        Resource a = m.createResource(NS + "a");
        Resource b = m.createResource(NS + "b");
        Property p = m.createProperty(NS + "p");
        Property q = m.createProperty(NS + "q");
        m.add(a, p, a);
        GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules(rules));
        InfModel infModel = ModelFactory.createInfModel(reasoner, m);
        TestBugs.assertTrue(infModel.contains(a, q, b));
        TestBugs.assertTrue(!myFlag.fired);
    }

    public void testCMEInTrans() {
        OntModel model = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM_TRANS_INF);
        model.read("file:testing/reasoners/bugs/tgcCMEbug.owl");
    }

    private static class Flag
    extends BaseBuiltin {
        public boolean fired = false;

        private Flag() {
        }

        public String getName() {
            return "flag";
        }

        public boolean bodyCall(Node[] args, int length, RuleContext context) {
            this.fired = true;
            return true;
        }
    }
}

