/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.test.TestFBRules;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestGenericRules
extends TestCase {
    protected static Log logger = LogFactory.getLog(TestFBRules.class);
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node t = Node.createURI("t");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node C1 = Node.createURI("C1");
    Node C2 = Node.createURI("C2");
    Node C3 = Node.createURI("C3");
    Node ty = RDF.Nodes.type;
    Node sC = RDFS.Nodes.subClassOf;
    List ruleList = Rule.parseRules("[r1: (?a p ?b), (?b p ?c) -> (?a p ?c)][r2: (?a q ?b) -> (?a p ?c)]-> table(p). -> table(q).");
    Triple[] ans = new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.c), new Triple(this.a, this.p, this.c)};

    public TestGenericRules(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestGenericRules.class);
    }

    public void testForward() {
        Graph test = Factory.createGraphMem();
        test.add(new Triple(this.a, this.p, this.b));
        test.add(new Triple(this.b, this.p, this.c));
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setRules(this.ruleList);
        reasoner.setMode(GenericRuleReasoner.FORWARD);
        InfGraph infgraph = reasoner.bind(test);
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.p, null), this.ans);
        infgraph = reasoner.bindSchema(test).bind(Factory.createGraphMem());
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.p, null), this.ans);
    }

    public void testBackward() {
        Graph test = Factory.createGraphMem();
        test.add(new Triple(this.a, this.p, this.b));
        test.add(new Triple(this.b, this.p, this.c));
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setRules(this.ruleList);
        reasoner.setMode(GenericRuleReasoner.BACKWARD);
        InfGraph infgraph = reasoner.bind(test);
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.p, null), this.ans);
        infgraph = reasoner.bindSchema(test).bind(Factory.createGraphMem());
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.p, null), this.ans);
    }

    public void testHybrid() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.r, this.b));
        data.add(new Triple(this.p, this.ty, this.s));
        List rules = Rule.parseRules("[a1: -> (a rdf:type t)][r0: (?x r ?y) -> (?x p ?y)][r1: (?p rdf:type s) -> [r1b: (?x ?p ?y) <- (?y ?p ?x)]][r2: (?p rdf:type s) -> [r2b: (?x ?p ?x) <- (?x rdf:type t)]]-> tableAll().");
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setRules(rules);
        reasoner.setMode(GenericRuleReasoner.HYBRID);
        InfGraph infgraph = reasoner.bind(data);
        infgraph.setDerivationLogging(true);
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator di = infgraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestGenericRules.assertTrue(di.hasNext());
        RuleDerivation d = (RuleDerivation)di.next();
        TestGenericRules.assertTrue(d.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, d.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestGenericRules.assertTrue(!di.hasNext());
    }

    public void testBRuleErrorHandling() {
        Graph data = Factory.createGraphMem();
        List rules = Rule.parseRules("[a1: -> [(?x eg:p ?y) (?x eg:q ?y) <- (?x eg:r ?y)]]");
        boolean foundException = false;
        try {
            GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
            reasoner.setRules(rules);
            reasoner.setMode(GenericRuleReasoner.HYBRID);
            InfGraph infgraph = reasoner.bind(data);
            infgraph.prepare();
        }
        catch (ReasonerException e2) {
            foundException = true;
        }
        TestGenericRules.assertTrue("Catching use of multi-headed brules", foundException);
    }

    public void testParameters() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.r, this.b));
        data.add(new Triple(this.p, this.ty, this.s));
        Model m = ModelFactory.createDefaultModel();
        Resource configuration = m.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        configuration.addProperty(ReasonerVocabulary.PROPderivationLogging, "true");
        configuration.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        configuration.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules");
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(configuration);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.p, null), new Object[]{new Triple(this.a, this.p, this.a), new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.a)});
        Iterator di = infgraph.getDerivation(new Triple(this.b, this.p, this.a));
        TestGenericRules.assertTrue(di.hasNext());
        RuleDerivation d = (RuleDerivation)di.next();
        TestGenericRules.assertTrue(d.getRule().getName().equals("r1b"));
        TestUtil.assertIteratorValues(this, d.getMatches().iterator(), new Object[]{new Triple(this.a, this.p, this.b)});
        TestGenericRules.assertTrue(!di.hasNext());
        Model m2 = ModelFactory.createDefaultModel();
        Resource newConfig = m2.createResource();
        reasoner.addDescription(m2, newConfig);
        TestUtil.assertIteratorValues(this, newConfig.listProperties(), new Statement[]{m2.createStatement(newConfig, ReasonerVocabulary.PROPderivationLogging, "true"), m2.createStatement(newConfig, ReasonerVocabulary.PROPruleMode, "hybrid"), m2.createStatement(newConfig, ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules")});
        reasoner.setParameter(ReasonerVocabulary.PROPderivationLogging, "false");
        newConfig = m2.createResource();
        reasoner.addDescription(m2, newConfig);
        TestUtil.assertIteratorValues(this, newConfig.listProperties(), new Statement[]{m2.createStatement(newConfig, ReasonerVocabulary.PROPderivationLogging, "false"), m2.createStatement(newConfig, ReasonerVocabulary.PROPruleMode, "hybrid"), m2.createStatement(newConfig, ReasonerVocabulary.PROPruleSet, "testing/reasoners/genericRuleTest.rules")});
        m = ModelFactory.createDefaultModel();
        configuration = m.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        configuration.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        configuration.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/ruleset1.rules");
        configuration.addProperty(ReasonerVocabulary.PROPruleSet, "testing/reasoners/ruleset2.rules");
        reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(configuration);
        infgraph = reasoner.bind(Factory.createGraphMem());
        Node an = Node.createURI("urn:x-hp:eg/a");
        Node C = Node.createURI("urn:x-hp:eg/C");
        Node D = Node.createURI("urn:x-hp:eg/D");
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), new Object[]{new Triple(an, RDF.Nodes.type, C), new Triple(an, RDF.Nodes.type, D)});
        m = ModelFactory.createDefaultModel();
        configuration = m.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        configuration.addProperty(ReasonerVocabulary.PROPenableTGCCaching, m.createLiteral("true"));
        reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(configuration);
        InfModel im = ModelFactory.createInfModel(reasoner, ModelFactory.createDefaultModel());
        Resource Ac = im.createResource("urn:x-hp:eg/A");
        Resource Bc = im.createResource("urn:x-hp:eg/B");
        Resource Cc = im.createResource("urn:x-hp:eg/C");
        im.add(Ac, RDFS.subClassOf, Bc);
        im.add(Bc, RDFS.subClassOf, Cc);
        TestGenericRules.assertTrue("TGC enabled correctly", im.contains(Ac, RDFS.subClassOf, Cc));
    }

    public void testHybridFunctorFilter() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.r, this.b));
        data.add(new Triple(this.a, this.p, this.s));
        List rules = Rule.parseRules("[r0: (?x r ?y) (?x p ?z) -> (?x q func(?y, ?z)) ]");
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setRules(rules);
        reasoner.setMode(GenericRuleReasoner.HYBRID);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.q, null), new Object[0]);
        reasoner.setFunctorFiltering(false);
        infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(null, this.q, null), new Object[]{new Triple(this.a, this.q, Functor.makeFunctorNode("func", new Node[]{this.b, this.s}))});
    }

    public void testExtendedRuleParser() {
        List rules = Rule.rulesFromURL("file:testing/reasoners/ruleParserTest1.rules");
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setTransitiveClosureCaching(true);
        Model base = ModelFactory.createDefaultModel();
        InfModel m = ModelFactory.createInfModel(reasoner, base);
        String NS1 = "http://jena.hpl.hp.com/newprefix#";
        String NS2 = "http://jena.hpl.hp.com/newprefix2#";
        String NS3 = "http://jena.hpl.hp.com/newprefix3#";
        Resource A = m.getResource(NS1 + "A");
        Resource C = m.getResource(NS1 + "C");
        Property p = m.getProperty(NS2 + "p");
        Property a = m.getProperty(NS3 + "a");
        Resource foo = m.getResource(NS1 + "foo");
        TestGenericRules.assertTrue("@prefix test", m.contains(A, p, foo));
        TestGenericRules.assertTrue("@include RDFS test", m.contains(A, RDFS.subClassOf, C));
        TestGenericRules.assertTrue("@include test", m.contains((Resource)a, a, a));
    }

    public void testAddRemove() {
        this.doTestAddRemove(false);
        this.doTestAddRemove(true);
    }

    public void doTestAddRemove(boolean useTGC) {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, this.C1));
        data.add(new Triple(this.C1, this.sC, this.C2));
        data.add(new Triple(this.C2, this.sC, this.C3));
        List rules = Rule.parseRules("-> table(rdf:type).[r1: (?x p ?c) -> (?x rdf:type ?c)] [rdfs9:  (?x rdfs:subClassOf ?y) -> [ (?a rdf:type ?y) <- (?a rdf:type ?x)] ]");
        if (!useTGC) {
            rules.add(Rule.parseRule("[rdfs8:  (?a rdfs:subClassOf ?b), (?b rdfs:subClassOf ?c) -> (?a rdfs:subClassOf ?c)] "));
        }
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setRules(rules);
        reasoner.setMode(GenericRuleReasoner.HYBRID);
        reasoner.setTransitiveClosureCaching(useTGC);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C2), new Triple(this.a, this.ty, this.C3)});
        logger.debug("Checkpoint 1");
        infgraph.delete(new Triple(this.C1, this.sC, this.C2));
        TestUtil.assertIteratorValues(this, infgraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1)});
        logger.debug("Checkpoint 2");
        infgraph.add(new Triple(this.C1, this.sC, this.C3));
        infgraph.add(new Triple(this.b, this.p, this.C2));
        TestUtil.assertIteratorValues(this, infgraph.find(this.a, this.ty, null), new Object[]{new Triple(this.a, this.ty, this.C1), new Triple(this.a, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, infgraph.find(this.b, this.ty, null), new Object[]{new Triple(this.b, this.ty, this.C2), new Triple(this.b, this.ty, this.C3)});
        TestUtil.assertIteratorValues(this, data.find(null, null, null), new Object[]{new Triple(this.a, this.p, this.C1), new Triple(this.b, this.p, this.C2), new Triple(this.C2, this.sC, this.C3), new Triple(this.C1, this.sC, this.C3)});
    }

    public void testAddRemove2() {
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.a, this.p, Util.makeIntNode(0)));
        List rules = Rule.parseRules("(?x p ?v)-> (?x q inc(1, a)).\n(?x p ?v)-> (?x q inc(1, b)).\n(?x p ?v) (?x q inc(?i, ?t)) noValue(?x r ?t) sum(?v, ?i, ?s) -> remove(0,1), (?x p ?s) (?x r ?t).\n");
        GenericRuleReasoner reasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        reasoner.setRules(rules);
        reasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        InfGraph infgraph = reasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(this.a, this.p, null), new Object[]{new Triple(this.a, this.p, Util.makeIntNode(2))});
    }
}

