/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLPDerivation
extends TestCase {
    Node p = Node.createURI("p");
    Node q = Node.createURI("q");
    Node r = Node.createURI("r");
    Node s = Node.createURI("s");
    Node a = Node.createURI("a");
    Node b = Node.createURI("b");
    Node c = Node.createURI("c");
    Node d = Node.createURI("d");
    Node e = Node.createURI("e");

    public TestLPDerivation(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestLPDerivation.class);
    }

    public static InfGraph makeInfGraph(List rules, Graph data, Node[] tabled) {
        FBRuleReasoner reasoner = new FBRuleReasoner(rules);
        FBRuleInfGraph infgraph = (FBRuleInfGraph)reasoner.bind(data);
        for (int i = 0; i < tabled.length; ++i) {
            infgraph.setTabled(tabled[i]);
        }
        infgraph.setDerivationLogging(true);
        return infgraph;
    }

    private void doTest(String ruleSrc, Node[] tabled, Triple[] triples, TripleMatch query2, Triple[] matches2, int rulenumber) {
        List rules = Rule.parseRules(ruleSrc);
        Graph data = Factory.createGraphMem();
        for (int i = 0; i < triples.length; ++i) {
            data.add(triples[i]);
        }
        InfGraph infgraph = TestLPDerivation.makeInfGraph(rules, data, tabled);
        ExtendedIterator results = infgraph.find(query2);
        TestLPDerivation.assertTrue(results.hasNext());
        Triple result = (Triple)results.next();
        results.close();
        Rule rule = (Rule)rules.get(rulenumber);
        List<Triple> matchList = Arrays.asList(matches2);
        Iterator derivations = infgraph.getDerivation(result);
        TestLPDerivation.assertTrue(derivations.hasNext());
        RuleDerivation derivation = (RuleDerivation)derivations.next();
        TestLPDerivation.assertEquals(result, derivation.getConclusion());
        TestLPDerivation.assertEquals(matchList, derivation.getMatches());
        TestLPDerivation.assertEquals(rule, derivation.getRule());
    }

    public void testBasic() {
        this.doTest("(?x p ?y) <- (?x q ?y).", new Node[0], new Triple[]{new Triple(this.a, this.q, this.b)}, new Triple(this.a, this.p, this.b), new Triple[]{new Triple(this.a, this.q, this.b)}, 0);
    }

    public void testBasic2() {
        this.doTest("(?x p ?y) <- (?x q ?y). (?x p ?y) <- (?x r ?y).", new Node[0], new Triple[]{new Triple(this.a, this.r, this.b)}, new Triple(this.a, this.p, this.b), new Triple[]{new Triple(this.a, this.r, this.b)}, 1);
    }

    public void testComposite() {
        this.doTest("(?x p ?y) <- (?x q ?y) (?x r ?y).", new Node[0], new Triple[]{new Triple(this.a, this.q, this.b), new Triple(this.a, this.r, this.b)}, new Triple(this.a, this.p, this.b), new Triple[]{new Triple(this.a, this.q, this.b), new Triple(this.a, this.r, this.b)}, 0);
    }

    public void testChain() {
        this.doTest("(?x s ?y) <- (?x r ?y). (?x p ?y) <- (?x q ?y) (?x s ?y). ", new Node[0], new Triple[]{new Triple(this.a, this.q, this.b), new Triple(this.a, this.r, this.b)}, new Triple(this.a, this.p, this.b), new Triple[]{new Triple(this.a, this.q, this.b), new Triple(this.a, this.s, this.b)}, 1);
    }

    public void testTabled() {
        this.doTest("(?x p ?z) <- (?x p ?y) (?y p ?z).", new Node[]{this.p}, new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.a, this.p, this.c), new Triple(this.b, this.p, this.d)}, new Triple(this.a, this.p, this.d), new Triple[]{new Triple(this.a, this.p, this.b), new Triple(this.b, this.p, this.d)}, 0);
    }
}

