/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionStatementMethods
extends NewRegressionBase {
    protected Model m;
    protected Resource r;

    public NewRegressionStatementMethods(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionStatementMethods.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.r = this.m.createResource();
    }

    public void testGetResource() {
        NewRegressionStatementMethods.assertEquals(this.r, this.m.createStatement(this.r, RDF.value, this.r).getResource());
    }

    public void testGetResourceFailure() {
        try {
            this.m.createStatement(this.r, RDF.value, false).getResource();
            NewRegressionStatementMethods.fail("should trap non-resource object");
        }
        catch (ResourceRequiredException e2) {
            NewRegressionStatementMethods.pass();
        }
    }

    public void testGetTrueBoolean() {
        NewRegressionStatementMethods.assertEquals(true, this.m.createStatement(this.r, RDF.value, true).getLiteral().getBoolean());
    }

    public void testGetLiteralFailure() {
        try {
            this.m.createStatement(this.r, RDF.value, this.r).getLiteral();
            NewRegressionStatementMethods.fail("should trap non-literal object");
        }
        catch (LiteralRequiredException e2) {
            NewRegressionStatementMethods.pass();
        }
    }

    public void testBoolean() {
        NewRegressionStatementMethods.assertEquals(true, this.m.createStatement(this.r, RDF.value, true).getBoolean());
    }

    public void testByte() {
        NewRegressionStatementMethods.assertEquals((byte)1, this.m.createStatement(this.r, RDF.value, 1L).getByte());
    }

    public void testShort() {
        NewRegressionStatementMethods.assertEquals((short)2, this.m.createStatement(this.r, RDF.value, 2L).getShort());
    }

    public void testInt() {
        NewRegressionStatementMethods.assertEquals(-1, this.m.createStatement(this.r, RDF.value, -1L).getInt());
    }

    public void testLong() {
        NewRegressionStatementMethods.assertEquals(-2L, this.m.createStatement(this.r, RDF.value, -2L).getLong());
    }

    public void testChar() {
        NewRegressionStatementMethods.assertEquals('!', this.m.createStatement(this.r, RDF.value, '!').getChar());
    }

    public void testFloat() {
        NewRegressionStatementMethods.assertEquals(123.456f, this.m.createStatement(this.r, RDF.value, 123.456f).getFloat(), 5.0E-6f);
    }

    public void testDouble() {
        NewRegressionStatementMethods.assertEquals(-123.456, this.m.createStatement(this.r, RDF.value, -123.456).getDouble(), 5.0E-9);
    }

    public void testString() {
        NewRegressionStatementMethods.assertEquals("test 12 string", this.m.createStatement(this.r, RDF.value, "test 12 string").getString());
    }

    public void testStringWithLanguage() {
        String lang = "fr";
        NewRegressionStatementMethods.assertEquals("test 12 string", this.m.createStatement(this.r, RDF.value, "test 12 string", lang).getString());
        NewRegressionStatementMethods.assertEquals(lang, this.m.createStatement(this.r, RDF.value, "test 12 string", lang).getLanguage());
    }

    public void testResObj() {
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        NewRegressionStatementMethods.assertEquals(tvResObj, this.m.createStatement(this.r, RDF.value, tvResObj).getResource());
    }

    public void testLitObj() {
        NewRegressionStatementMethods.assertEquals(tvLitObj, this.m.createStatement(this.r, RDF.value, tvLitObj).getObject(new Regression.LitTestObjF()));
    }

    public void testBag() {
        Bag tvBag = this.m.createBag();
        NewRegressionStatementMethods.assertEquals(tvBag, this.m.createStatement(this.r, RDF.value, tvBag).getBag());
    }

    public void testSeq() {
        Seq tvSeq = this.m.createSeq();
        NewRegressionStatementMethods.assertEquals(tvSeq, this.m.createStatement(this.r, RDF.value, tvSeq).getSeq());
    }

    public void testAlt() {
        Alt tvAlt = this.m.createAlt();
        NewRegressionStatementMethods.assertEquals(tvAlt, this.m.createStatement(this.r, RDF.value, tvAlt).getAlt());
    }

    public void testChangeObjectBoolean() {
        Statement sTrue = this.loadInitialStatement();
        Statement sFalse = sTrue.changeObject(false);
        this.checkChangedStatementSP(sFalse);
        NewRegressionStatementMethods.assertEquals(false, sFalse.getBoolean());
        this.checkCorrectStatements(sTrue, sFalse);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, false));
    }

    public void testChangeObjectByte() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(1L);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals((byte)1, changed.getByte());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, 1L));
    }

    public void testChangeObjectShort() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(2L);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals((short)2, changed.getShort());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, 2L));
    }

    public void testChangeObjectInt() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(-1L);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals(-1, changed.getInt());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, -1L));
    }

    public void testChangeObjectLong() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(-2L);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals(-2L, changed.getLong());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, -2L));
    }

    public void testChangeObjectChar() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject('!');
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals('!', changed.getChar());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, '!'));
    }

    public void testChangeObjectFloat() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(123.456f);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals(123.456f, changed.getFloat(), 5.0E-6f);
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, 123.456f));
    }

    public void testChangeObjectDouble() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(-123.456);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals(-123.456, changed.getDouble(), 5.0E-9);
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, -123.456));
    }

    public void testChangeObjectString() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject("test 12 string");
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals("test 12 string", changed.getString());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, "test 12 string"));
    }

    public void testChangeObjectStringWithLanguage() {
        String lang = "en";
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject("test 12 string", lang);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals("test 12 string", changed.getString());
        NewRegressionStatementMethods.assertEquals(lang, changed.getLanguage());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, "test 12 string", lang));
    }

    public void testChangeObjectResObject() {
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(tvResObj);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals(tvResObj, changed.getResource());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, tvResObj));
    }

    public void testChangeObjectLiteral() {
        Statement sTrue = this.loadInitialStatement();
        this.m.remove(sTrue);
        NewRegressionStatementMethods.assertFalse(this.m.contains(sTrue));
        NewRegressionStatementMethods.assertFalse(this.m.contains(this.r, RDF.value, true));
    }

    public void testChangeObjectYByte() {
        Statement sTrue = this.loadInitialStatement();
        Statement changed = sTrue.changeObject(1L);
        this.checkChangedStatementSP(changed);
        NewRegressionStatementMethods.assertEquals((byte)1, changed.getByte());
        this.checkCorrectStatements(sTrue, changed);
        NewRegressionStatementMethods.assertTrue(this.m.contains(this.r, RDF.value, 1L));
    }

    protected void checkCorrectStatements(Statement sTrue, Statement changed) {
        NewRegressionStatementMethods.assertFalse(this.m.contains(sTrue));
        NewRegressionStatementMethods.assertFalse(this.m.contains(this.r, RDF.value, true));
        NewRegressionStatementMethods.assertTrue(this.m.contains(changed));
    }

    protected void checkChangedStatementSP(Statement changed) {
        NewRegressionStatementMethods.assertEquals(this.r, changed.getSubject());
        NewRegressionStatementMethods.assertEquals(RDF.value, changed.getPredicate());
    }

    protected Statement loadInitialStatement() {
        Statement sTrue = this.m.createStatement(this.r, RDF.value, true);
        this.m.add(sTrue);
        return sTrue;
    }
}

