/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class OpWriter {
    private static final int NL = 1;
    private static final int NoNL = -1;

    public static void out(OutputStream out, Op op, PrefixMapping pMap) {
        SerializationContext sCxt = new SerializationContext(pMap);
        OpWriter.out(new IndentedWriter(out), op, sCxt);
    }

    public static void out(OutputStream out, Op op, SerializationContext sCxt) {
        OpWriter.out(new IndentedWriter(out), op, sCxt);
    }

    public static void out(OutputStream out, Op op) {
        OpWriter.out(out, op, ARQConstants.getGlobalPrefixMap());
    }

    public static void out(IndentedWriter iWriter, Op op, PrefixMapping pMap) {
        SerializationContext sCxt = new SerializationContext(pMap);
        OpWriter.out(iWriter, op, sCxt);
    }

    public static void out(IndentedWriter iWriter, Op op, SerializationContext sCxt) {
        op.visit(new OpWriterWorker(iWriter, sCxt));
        iWriter.ensureStartOfLine();
        iWriter.flush();
    }

    public static void out(IndentedWriter iWriter, Op op) {
        OpWriter.out(iWriter, op, ARQConstants.getGlobalPrefixMap());
    }

    static class OpWriterWorker
    implements OpVisitor {
        private IndentedWriter out;
        private SerializationContext sContext;

        public OpWriterWorker(IndentedWriter out, SerializationContext sCxt) {
            this.sContext = sCxt;
            this.out = out;
        }

        private void visitOp2(Op2 op, ExprList exprs) {
            this.start(op, 1);
            this.printOp(op.getLeft());
            this.out.ensureStartOfLine();
            this.printOp(op.getRight());
            this.out.ensureStartOfLine();
            if (exprs != null) {
                ExprUtils.fmtPrefix(this.out, exprs);
            }
            this.finish(op);
        }

        private void visitOp1(Op1 op) {
            this.start(op, 1);
            this.printOp(op.getSubOp());
            this.finish(op);
        }

        public void visit(OpQuadPattern opQuadP) {
            if (opQuadP.getQuads().size() == 1) {
                this.start(opQuadP, -1);
                this.out.print(" ");
                this.formatQuad((Quad)opQuadP.getQuads().get(0));
                this.finish(opQuadP);
                return;
            }
            this.start(opQuadP, 1);
            ListIterator iter = opQuadP.getQuads().listIterator();
            while (iter.hasNext()) {
                Quad quad = (Quad)iter.next();
                this.formatQuad(quad);
                this.out.println();
            }
            this.finish(opQuadP);
        }

        public void visit(OpBGP opBGP) {
            if (opBGP.getPattern().size() == 1) {
                this.start(opBGP, -1);
                this.out.print(" ");
                this.formatTriple(opBGP.getPattern().get(0));
                this.finish(opBGP);
                return;
            }
            this.start(opBGP, 1);
            ListIterator iter = opBGP.getPattern().iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                this.formatTriple(t);
                this.out.println();
            }
            this.finish(opBGP);
        }

        public void visit(OpJoin opJoin) {
            this.visitOp2(opJoin, null);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            this.visitOp2(opLeftJoin, opLeftJoin.getExprs());
        }

        public void visit(OpDiff opDiff) {
            this.visitOp2(opDiff, null);
        }

        public void visit(OpUnion opUnion) {
            this.visitOp2(opUnion, null);
        }

        public void visit(OpFilter opFilter) {
            this.start(opFilter, -1);
            this.out.print(" ");
            ExprList exprs = opFilter.getExprs();
            if (exprs == null) {
                this.out.print("()");
            } else {
                ExprUtils.fmtPrefix(this.out, exprs, this.sContext.getPrefixMapping());
            }
            this.out.println();
            this.printOp(opFilter.getSubOp());
            this.finish(opFilter);
        }

        public void visit(OpGraph opGraph) {
            this.start(opGraph, -1);
            this.out.print(" ");
            this.out.println(FmtUtils.stringForNode(opGraph.getNode()));
            this.out.incIndent();
            opGraph.getSubOp().visit(this);
            this.finish(opGraph);
        }

        public void visit(OpTable opTable) {
            if (TableUnit.isJoinUnit(opTable.getTable())) {
                this.start(opTable, -1);
                this.out.print(" unit");
                this.finish(opTable);
                return;
            }
            this.start(opTable, 1);
            this.outputTable(opTable.getTable());
            this.finish(opTable);
        }

        private void outputTable(Table table) {
            QueryIterator qIter = table.iterator(null);
            while (qIter.hasNext()) {
                Binding b = qIter.nextBinding();
                this.outputRow(b);
                this.out.println();
            }
            qIter.close();
        }

        private void outputRow(Binding binding) {
            this.out.print("(");
            this.out.print("row");
            Iterator iter = binding.vars();
            while (iter.hasNext()) {
                Var v = (Var)iter.next();
                Node n = binding.get(v);
                this.out.print(" ");
                this.out.print("[");
                this.out.print(FmtUtils.stringForNode((Node)v, this.sContext));
                this.out.print(" ");
                this.out.print(FmtUtils.stringForNode(n, this.sContext));
                this.out.print("]");
            }
            this.out.print(")");
        }

        public void visit(OpDatasetNames dsNames) {
            this.start();
            this.out.print("TableDatasetNames");
            this.out.print(" ");
            this.out.print(this.slotToString(dsNames.getGraphNode()));
            this.finish();
        }

        public void visit(OpExt opExt) {
            opExt.output(this.out, this.sContext);
        }

        public void visit(OpNull opNull) {
            this.start(opNull, -1);
            this.finish();
        }

        public void visit(OpList opList) {
            this.visitOp1(opList);
        }

        public void visit(OpGroupAgg opGroupAgg) {
            this.start(opGroupAgg, -1);
            this.finish(opGroupAgg);
        }

        public void visit(OpOrder opOrder) {
            this.start(opOrder, -1);
            if (opOrder.getConditions().size() > 0) {
                String sep = " ";
                Iterator iter = opOrder.getConditions().iterator();
                while (iter.hasNext()) {
                    SortCondition sc = (SortCondition)iter.next();
                    this.out.print(sep);
                    sc.output(this.out, this.sContext);
                }
            }
            this.out.println();
            this.printOp(opOrder.getSubOp());
            this.finish(opOrder);
        }

        public void visit(OpProject opProject) {
            this.start(opProject, -1);
            this.out.print(" (");
            PrintUtils.Fmt fmt = new PrintUtils.Fmt(){

                public String fmt(Object thing) {
                    return ((Var)thing).toString();
                }
            };
            PrintUtils.printList(this.out, (Collection)opProject.getVars(), " ", fmt);
            this.out.println(")");
            this.printOp(opProject.getSubOp());
            this.finish(opProject);
        }

        public void visit(OpDistinct opDistinct) {
            this.visitOp1(opDistinct);
        }

        public void visit(OpReduced opReduced) {
            this.visitOp1(opReduced);
        }

        public void visit(OpSlice opSlice) {
            this.start(opSlice, -1);
            this.out.print(" ");
            this.out.print(Long.toString(opSlice.getStart()));
            this.out.print(" ");
            this.out.print(Long.toString(opSlice.getLength()));
            this.out.println();
            this.printOp(opSlice.getSubOp());
            this.finish(opSlice);
        }

        private void start() {
            this.out.print("(");
        }

        private void start(Op op, int newline) {
            this.start();
            this.out.print(op.getName());
            if (newline == 1) {
                this.out.println();
            }
            this.out.incIndent();
        }

        private void finish() {
            this.out.print(")");
        }

        private void finish(Op op) {
            this.out.decIndent();
            this.finish();
        }

        private void printOp(Op op) {
            if (op == null) {
                this.out.print("(null)");
            } else {
                op.visit(this);
            }
        }

        private void formatTriple(Triple tp) {
            this.out.print("[");
            this.out.print("triple");
            this.out.print(" ");
            this.out.print(this.slotToString(tp.getSubject()));
            this.out.print(" ");
            this.out.print(this.slotToString(tp.getPredicate()));
            this.out.print(" ");
            this.out.print(this.slotToString(tp.getObject()));
            this.out.print("]");
        }

        private void formatQuad(Quad qp) {
            this.out.print("[");
            this.out.print("quad");
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getGraph()));
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getSubject()));
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getPredicate()));
            this.out.print(" ");
            this.out.print(this.slotToString(qp.getObject()));
            this.out.print("]");
        }

        private String slotToString(Node n) {
            return FmtUtils.stringForNode(n, this.sContext);
        }
    }
}

