/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DataSourceGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataSourceGraphImpl
implements DataSourceGraph {
    Graph defaultGraph = null;
    Map namedGraphs = null;
    Lock lock = null;

    public DataSourceGraphImpl(Graph graph) {
        this.defaultGraph = graph;
        this.namedGraphs = new HashMap();
    }

    public DataSourceGraphImpl(Model model) {
        this(model.getGraph());
    }

    public DataSourceGraphImpl(Dataset dataset) {
        this.cloneDataset(dataset);
    }

    public DataSourceGraphImpl(DatasetGraph dataset) {
        this.cloneDatasetGraph(dataset);
    }

    public DataSourceGraphImpl() {
        this(GraphUtils.makeDefaultGraph());
    }

    public Graph getDefaultGraph() {
        if (this.defaultGraph == null) {
            System.err.println("** NULL default graph");
        }
        return this.defaultGraph;
    }

    public void setDefaultGraph(Graph g) {
        this.defaultGraph = g;
    }

    public Graph getGraph(Node graphName) {
        if (this.namedGraphs == null) {
            return null;
        }
        return (Graph)this.namedGraphs.get(graphName);
    }

    public void addGraph(Node graphName, Graph graph) {
        if (this.namedGraphs == null) {
            this.namedGraphs = new HashMap();
        }
        this.namedGraphs.put(graphName, graph);
    }

    public Graph removeGraph(Node graphName) {
        if (this.namedGraphs == null) {
            return null;
        }
        return (Graph)this.namedGraphs.remove(graphName);
    }

    public boolean containsGraph(Node graphName) {
        if (this.namedGraphs == null) {
            return false;
        }
        return this.namedGraphs.containsKey(graphName);
    }

    public Iterator listGraphNodes() {
        if (this.namedGraphs == null) {
            return new NullIterator();
        }
        return this.namedGraphs.keySet().iterator();
    }

    public int size() {
        return this.namedGraphs.size();
    }

    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockMRSW();
        }
        return this.lock;
    }

    public void cloneDataset(Dataset dataset) {
        if (dataset == null) {
            return;
        }
        if (dataset.getDefaultModel() != null) {
            this.defaultGraph = dataset.getDefaultModel().getGraph();
        }
        Iterator iter = dataset.listNames();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            Node graphRef = Node.createURI(uri);
            Model m = dataset.getNamedModel(uri);
            if (m == null) continue;
            this.addGraph(graphRef, m.getGraph());
        }
    }

    public DatasetGraph copy() {
        DataSourceGraphImpl ds = new DataSourceGraphImpl();
        ds.setDefaultGraph(this.getDefaultGraph());
        ds.namedGraphs = new HashMap(this.namedGraphs);
        return ds;
    }

    private void cloneDatasetGraph(DatasetGraph dataset) {
        if (!(dataset instanceof DataSourceGraphImpl)) {
            this.defaultGraph = dataset.getDefaultGraph();
            this.namedGraphs = new HashMap();
            Iterator iter = dataset.listGraphNodes();
            while (iter.hasNext()) {
                Node name = (Node)iter.next();
                this.addGraph(name, dataset.getGraph(name));
            }
            return;
        }
        DataSourceGraphImpl ds = (DataSourceGraphImpl)dataset;
        this.namedGraphs = new HashMap(ds.namedGraphs);
        this.defaultGraph = ds.defaultGraph;
    }

    public String toString() {
        String s = "{";
        s = this.getDefaultGraph() == null ? s + "<null>" : s + "[" + this.getDefaultGraph().size() + "]";
        Iterator iter = this.listGraphNodes();
        while (iter.hasNext()) {
            Node graphName = (Node)iter.next();
            String x = FmtUtils.stringForNode(graphName);
            s = s + ", (" + x + ", [" + this.getGraph(graphName).size() + "])";
        }
        s = s + "}";
        return s;
    }
}

