/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.VariableNotBoundException;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BindingComparator
implements Comparator {
    private Log log = LogFactory.getLog(BindingComparator.class);
    List conditions;
    private FunctionEnv env;

    public BindingComparator(List conditions, ExecutionContext execCxt) {
        this.conditions = conditions;
        this.env = execCxt;
    }

    public BindingComparator(List _conditions) {
        this.conditions = _conditions;
        this.env = new FunctionEnvBase();
    }

    public int compare(Object arg1, Object arg2) {
        Binding bind1 = (Binding)arg1;
        Binding bind2 = (Binding)arg2;
        Iterator iter = this.conditions.iterator();
        while (iter.hasNext()) {
            SortCondition sc = (SortCondition)iter.next();
            if (sc.expression == null) {
                throw new QueryExecException("Broken sort condition");
            }
            NodeValue nv1 = null;
            NodeValue nv2 = null;
            try {
                nv1 = sc.expression.eval(bind1, this.env);
            }
            catch (VariableNotBoundException ex) {
            }
            catch (ExprEvalException ex) {
                this.log.warn(ex.getMessage());
            }
            try {
                nv2 = sc.expression.eval(bind2, this.env);
            }
            catch (VariableNotBoundException ex) {
            }
            catch (ExprEvalException ex) {
                this.log.warn(ex.getMessage());
            }
            Node n1 = NodeValue.toNode(nv1);
            Node n2 = NodeValue.toNode(nv2);
            int x = BindingComparator.compareNodes(nv1, nv2, sc.direction);
            if (x == 0) continue;
            return x;
        }
        return BindingComparator.compareBindingsSyntactic(bind1, bind2);
    }

    private static int compareNodes(NodeValue nv1, NodeValue nv2, int direction) {
        int x = BindingComparator.compareNodesRaw(nv1, nv2);
        if (direction == Query.ORDER_DESCENDING) {
            x = -x;
        }
        return x;
    }

    public static int compareNodesRaw(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null) {
            return nv2 == null ? 0 : -1;
        }
        if (nv2 == null) {
            return 1;
        }
        return NodeValue.compareAlways(nv1, nv2);
    }

    public static int compareBindingsSyntactic(Binding bind1, Binding bind2) {
        int x = 0;
        Iterator iter = bind1.vars();
        while (iter.hasNext()) {
            Node n2;
            Var v = (Var)iter.next();
            Node n1 = bind1.get(v);
            x = NodeUtils.compareRDFTerms(n1, n2 = bind2.get(v));
            if (x == 0) continue;
            return x;
        }
        return x;
    }
}

