/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterFilter;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterFilterExpr
extends QueryIterFilter {
    private static Log log = LogFactory.getLog(QueryIterFilterExpr.class);
    Expr expr;

    public QueryIterFilterExpr(QueryIterator input, Expr expr, ExecutionContext context) {
        super(input, context);
        this.expr = expr;
    }

    public boolean accept(Binding binding) {
        boolean passFilter = false;
        try {
            Binding b = binding;
            passFilter = this.expr.isSatisfied(b, super.getExecContext());
        }
        catch (ExprException ex) {
            passFilter = false;
        }
        catch (Exception ex) {
            passFilter = false;
            log.warn("General exception in " + this.expr, ex);
        }
        if (!passFilter) {
            if (log.isDebugEnabled()) {
                log.debug("Reject: " + this.expr + " - " + binding);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Accept: " + this.expr + " - " + binding);
        }
        return true;
    }

    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Utils.className(this));
        out.print(" ");
        ExprUtils.fmtSPARQL(out, this.expr, cxt.getPrefixMapping());
    }
}

