/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.main.Stage;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.commons.logging.LogFactory;

public class StagePropertyFunction
implements Stage {
    Context context;
    Node predicate;
    PropFuncArg subjArgs;
    PropFuncArg objArgs;

    public static StagePropertyFunction make(Context context, PropFuncArg sArgs, Node predicate, PropFuncArg oArgs) {
        return new StagePropertyFunction(context, sArgs, predicate, oArgs);
    }

    private StagePropertyFunction(Context context, PropFuncArg sArgs, Node predicate, PropFuncArg oArgs) {
        this.context = context;
        this.subjArgs = sArgs;
        this.predicate = predicate;
        this.objArgs = oArgs;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        String uri = this.predicate.getURI();
        PropertyFunctionRegistry registry = StagePropertyFunction.chooseRegistry(execCxt.getContext());
        PropertyFunctionFactory factory = registry.get(uri);
        PropertyFunction propFunc = null;
        if (factory == null) {
            throw new QueryBuildException("No property function for '" + uri + "'");
        }
        propFunc = factory.create(uri);
        propFunc.build(this.getSubjArgs(), this.getPredicate(), this.getObjArgs(), execCxt);
        if (input == null) {
            LogFactory.getLog(this.getClass()).fatal("Null input to " + Utils.classShortName(this.getClass()));
        }
        QueryIterator qIter = propFunc.exec(input, this.getSubjArgs(), this.getPredicate(), this.getObjArgs(), execCxt);
        return qIter;
    }

    public PropFuncArg getSubjArgs() {
        return this.subjArgs;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public PropFuncArg getObjArgs() {
        return this.objArgs;
    }

    public static PropertyFunctionRegistry chooseRegistry(Context context) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }
}

