/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.RegexEngine;
import com.hp.hpl.jena.sparql.expr.RegexJava;
import com.hp.hpl.jena.sparql.expr.RegexXerces;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.apache.commons.logging.LogFactory;

public class E_Regex
extends ExprFunction {
    private static Symbol regexImpl = null;
    private static final String name = "regex";
    private RegexEngine regexEngine = null;
    private Expr expr;
    private Expr pattern;
    private Expr flags;

    public E_Regex(Expr _expr, Expr _pattern, Expr _flags) {
        super(name);
        this.expr = _expr;
        this.pattern = _pattern;
        this.flags = _flags;
        this.init();
    }

    public E_Regex(Expr _expr, String _pattern, String _flags) {
        super(name);
        this.expr = _expr;
        this.pattern = NodeValue.makeString(_pattern);
        this.flags = NodeValue.makeString(_flags);
        this.init();
    }

    private void init() {
        if (this.pattern.isConstant() && this.pattern.getConstant().isString() && (this.flags == null || this.flags.isConstant())) {
            this.regexEngine = E_Regex.makeRegexEngine(this.pattern.getConstant(), this.flags == null ? null : this.flags.getConstant());
        }
    }

    public NodeValue eval(Binding binding, FunctionEnv env) {
        boolean b;
        NodeValue v = this.expr.eval(binding, env);
        if (!v.isString()) {
            throw new ExprEvalException("REGEX: " + this.expr + " evaluates to " + v + ", which is not a string");
        }
        RegexEngine regex = this.regexEngine;
        if (regex == null) {
            NodeValue vPattern = this.pattern.eval(binding, env);
            NodeValue vFlags = this.flags == null ? null : this.flags.eval(binding, env);
            regex = E_Regex.makeRegexEngine(vPattern, vFlags);
        }
        return (b = regex.match(v.getString())) ? NodeValue.TRUE : NodeValue.FALSE;
    }

    public static RegexEngine makeRegexEngine(NodeValue vPattern, NodeValue vFlags) {
        if (!vPattern.isString()) {
            throw new ExprException("REGEX: Pattern is not a string: " + vPattern);
        }
        if (vFlags != null && !vFlags.isString()) {
            throw new ExprException("REGEX: Pattern flags are not a string: " + vFlags);
        }
        String s = vFlags == null ? null : vFlags.getString();
        return E_Regex.makeRegexEngine(vPattern.getString(), s);
    }

    public static RegexEngine makeRegexEngine(String pattern, String flags) {
        if (regexImpl.equals(ARQ.xercesRegex)) {
            return new RegexXerces(pattern, flags);
        }
        return new RegexJava(pattern, flags);
    }

    public Expr getArg(int i) {
        if (i == 1) {
            return this.expr;
        }
        if (i == 2) {
            return this.pattern;
        }
        if (i == 3) {
            return this.flags;
        }
        return null;
    }

    public int numArgs() {
        if (this.flags != null) {
            return 3;
        }
        return 2;
    }

    public Expr getRegexExpr() {
        return this.expr;
    }

    public Expr getFlags() {
        return this.flags;
    }

    public Expr getPattern() {
        return this.pattern;
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        Expr e2 = this.expr.copySubstitute(binding, foldConstants);
        Expr p = this.pattern.copySubstitute(binding, foldConstants);
        Expr f = this.flags == null ? null : this.flags.copySubstitute(binding, foldConstants);
        return new E_Regex(e2, p, f);
    }

    static {
        Object v = ARQ.getContext().get(ARQ.regexImpl, ARQ.javaRegex);
        if (v instanceof Symbol) {
            regexImpl = (Symbol)v;
        }
        if (v instanceof String) {
            regexImpl = Symbol.create((String)v);
        }
        if (regexImpl == null) {
            LogFactory.getLog(E_Regex.class).warn("Regex implementation some weird setting: default to Java");
            regexImpl = ARQ.javaRegex;
        }
        if (!regexImpl.equals(ARQ.javaRegex) && !regexImpl.equals(ARQ.xercesRegex)) {
            LogFactory.getLog(E_Regex.class).warn("Regex implementation not recognized : default to Java");
            regexImpl = ARQ.javaRegex;
        }
    }
}

