/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.junit.TestCaseARQ;
import com.hp.hpl.jena.sparql.junit.TestItem;

public class SyntaxTest
extends TestCaseARQ {
    static int count = 0;
    String queryString;
    boolean expectLegalSyntax;
    TestItem testItem;

    public SyntaxTest(String testName, TestItem t) {
        this(testName, t, true);
    }

    public SyntaxTest(String testName, TestItem t, boolean positiveTest) {
        super(testName);
        this.testItem = t;
        this.expectLegalSyntax = positiveTest;
    }

    public SyntaxTest(String testName, String queryString, boolean positiveTest) {
        super(testName);
        this.setTest(testName, queryString, positiveTest);
    }

    private void setTest(String testName, String _queryString, boolean positiveTest) {
        super.setName(testName);
        this.queryString = _queryString;
        this.expectLegalSyntax = positiveTest;
    }

    protected void runTest() throws Throwable {
        try {
            if (this.queryString == null) {
                this.queryFromTestItem(this.testItem);
            } else {
                this.queryFromString(this.queryString);
            }
            if (!this.expectLegalSyntax) {
                SyntaxTest.fail("Expected parse failure");
            }
        }
        catch (QueryException qEx) {
            if (this.expectLegalSyntax) {
                throw qEx;
            }
        }
        catch (Exception ex) {
            SyntaxTest.fail("Exception: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }
}

