/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.junit.QueryTestException;
import com.hp.hpl.jena.sparql.vocabulary.TestManifest;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestX;
import com.hp.hpl.jena.sparql.vocabulary.VocabTestQuery;
import com.hp.hpl.jena.util.junit.TestUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;

public class TestItem {
    private Resource testResource = null;
    private Resource actionResource = null;
    private String name;
    private boolean buildLuceneIndex = false;
    private String resultFile;
    private String comment;
    private List defaultGraphURIs;
    private List namedGraphURIs;
    private Resource testType = null;
    private String queryFile;
    private Syntax queryFileSyntax;
    private Resource queryForm;
    private Resource resultForm;

    public TestItem(Resource r, Resource defaultTestType, Syntax defaultQuerySyntax, DataFormat defaultDataSyntax) {
        this.testResource = r;
        if (!r.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name (" + r + ")");
        }
        this.name = this._getName();
        if (!r.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem '" + this.name + "' with no action");
        }
        this.testType = TestUtils.getResource(r, RDF.type);
        if (this.testType == null) {
            this.testType = defaultTestType;
        }
        this.queryFileSyntax = defaultQuerySyntax;
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.defaultGraphURIs = this._getDefaultGraphURIs();
        this.namedGraphURIs = this._getNamedGraphsURIs();
        this.queryFile = this._getQueryFile();
        this.queryFileSyntax = this._getSyntax(r.getModel(), this.queryFile, defaultQuerySyntax);
        if (this.queryFileSyntax == null && this.queryFile != null) {
            this.queryFileSyntax = Syntax.guessQueryFileSyntax(this.queryFile);
        }
        this.queryForm = this._getQueryForm();
        this.resultForm = this._getResultForm();
        this.buildLuceneIndex = this._getTextIndex();
    }

    public TestItem(String _name, String _queryFile, String _dataFile, String _resultFile) {
        this.name = _name;
        this.queryFile = _queryFile;
        this.defaultGraphURIs = new ArrayList();
        this.defaultGraphURIs.add(_dataFile);
        this.namedGraphURIs = new ArrayList();
        this.resultFile = _resultFile;
        this.comment = "";
        this.queryForm = null;
        this.resultForm = null;
        this.queryFileSyntax = Syntax.guessQueryFileSyntax(_queryFile);
    }

    public Resource getResource() {
        return this.testResource;
    }

    public Resource getTestType() {
        return this.testType;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public Syntax getQueryFileSyntax() {
        return this.queryFileSyntax;
    }

    public void setQueryFileSyntax(Syntax syntax) {
        this.queryFileSyntax = syntax;
    }

    public Resource getQueryForm() {
        return this.queryForm;
    }

    public Resource getResultForm() {
        return this.resultForm;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public List getDefaultGraphURIs() {
        return this.defaultGraphURIs;
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean requiresTextIndex() {
        return this.buildLuceneIndex;
    }

    private String _getName() {
        Statement s = this.testResource.getProperty(TestManifest.name);
        if (s == null) {
            return "<<unset>>";
        }
        return s.getString();
    }

    private Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    private String _getResultFile() {
        return TestUtils.getLiteralOrURI(this.testResource, TestManifest.result);
    }

    private String _getComment() {
        Statement s = this.testResource.getProperty(RDFS.comment);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    private List _getDefaultGraphURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.data);
        while (cIter.hasNext()) {
            Object obj = cIter.next();
            String df = ((Statement)obj).getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    private List _getNamedGraphsURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.graphData);
        while (cIter.hasNext()) {
            Object obj = cIter.next();
            String df = ((Statement)obj).getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    private String _getQueryFile() {
        Resource r = this._getAction();
        if (r.hasProperty(VocabTestQuery.query)) {
            return TestUtils.getLiteralOrURI(r, VocabTestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    private Resource _getQueryForm() {
        return null;
    }

    private Resource _getResultForm() {
        return null;
    }

    private Syntax _getSyntax(Model m, String uri, Syntax def) {
        Resource r = m.createResource(uri);
        if (r.hasProperty(RDF.type)) {
            return Syntax.make(r.getProperty(RDF.type).getResource().getURI());
        }
        return def;
    }

    private boolean _getTextIndex() {
        Statement s = this.testResource.getProperty(TestManifestX.textIndex);
        if (s == null) {
            return false;
        }
        return s.getString().equalsIgnoreCase("true");
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        String name = this.getName();
        sbuff.append("Name: " + name);
        if (this.getComment() != null) {
            sbuff.append("    Comment: " + this.getComment());
        }
        return sbuff.toString();
    }
}

