/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.JenaURIException;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.lang.QNameException;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.TripleCollector;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Set;

public class ParserBase {
    protected final Node XSD_TRUE = Node.createLiteral("true", null, XSDDatatype.XSDboolean);
    protected final Node XSD_FALSE = Node.createLiteral("false", null, XSDDatatype.XSDboolean);
    protected final Node nRDFtype = RDF.type.asNode();
    protected final Node nRDFnil = RDF.nil.asNode();
    protected final Node nRDFfirst = RDF.first.asNode();
    protected final Node nRDFrest = RDF.rest.asNode();
    protected final Node nRDFsubject = RDF.subject.asNode();
    protected final Node nRDFpredicate = RDF.predicate.asNode();
    protected final Node nRDFobject = RDF.object.asNode();
    protected boolean inConstructTemplate = false;
    final LabelToNodeMap bNodeLabels = LabelToNodeMap.createBNodeMap();
    final LabelToNodeMap anonVarLabels;
    LabelToNodeMap activeLabelMap = this.anonVarLabels = LabelToNodeMap.createVarMap();
    Set oldLabels = new HashSet();
    Prologue prologue;
    static final String bNodeLabelStart = "_:";
    RefBoolean skolomizedBNodes = new RefBoolean(ARQ.constantBNodeLabels);

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    protected void setInConstructTemplate(boolean b) {
        this.inConstructTemplate = b;
        this.activeLabelMap = this.inConstructTemplate ? this.bNodeLabels : this.anonVarLabels;
    }

    protected Element compressGroupOfOneGroup(ElementGroup elg) {
        Element e1;
        if (elg.getElements().size() == 1 && (e1 = (Element)elg.getElements().get(0)) instanceof ElementGroup) {
            return e1;
        }
        return elg;
    }

    protected Node makeNodeInteger(String lexicalForm) {
        return Node.createLiteral(lexicalForm, null, XSDDatatype.XSDinteger);
    }

    protected Node makeNodeDouble(String lexicalForm) {
        return Node.createLiteral(lexicalForm, null, XSDDatatype.XSDdouble);
    }

    protected Node makeNodeDecimal(String lexicalForm) {
        return Node.createLiteral(lexicalForm, null, XSDDatatype.XSDdecimal);
    }

    protected Node stripSign(Node node) {
        if (!node.isLiteral()) {
            return node;
        }
        String lex = node.getLiteralLexicalForm();
        String lang = node.getLiteralLanguage();
        RDFDatatype dt = node.getLiteralDatatype();
        if (!lex.startsWith("-") && !lex.startsWith("+")) {
            throw new ARQInternalErrorException("Literal does not start with a sign: " + lex);
        }
        lex = lex.substring(1);
        return Node.createLiteral(lex, lang, dt);
    }

    protected Node makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return this.makeNode(lexicalForm, langTag, uri);
    }

    protected Node makeNode(String lexicalForm, String langTag, String datatypeURI) {
        Node n = null;
        if (datatypeURI != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = Node.createLiteral(lexicalForm, null, dType);
        } else {
            n = Node.createLiteral(lexicalForm, langTag, null);
        }
        return n;
    }

    protected long integerValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
            return Long.parseLong(s, 16);
        }
        return Long.parseLong(s);
    }

    protected double doubleValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        double valDouble = Double.parseDouble(s);
        return valDouble;
    }

    protected String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    protected String stripQuotes3(String s) {
        return s.substring(3, s.length() - 3);
    }

    protected String stripChars(String s, int n) {
        return s.substring(n, s.length());
    }

    protected Var createVariable(String s, int line, int column) {
        s = s.substring(1);
        return Var.alloc(s);
    }

    protected Node createNodeFromPrefixedName(String s, int line, int column) {
        s = this.fixupPrefixedName(s, line, column);
        return Node.createURI(s);
    }

    protected Node createNodeFromURI(String s, int line, int column) {
        String uriStr = s = this.stripQuotes(s);
        if (this.skolomizedBNodes.getValue() && s.startsWith(bNodeLabelStart)) {
            s = s.substring(bNodeLabelStart.length());
            Node n = Node.createAnon(new AnonId(s));
            return n;
        }
        if (this.getPrologue() != null && this.getPrologue().getResolver() != null) {
            try {
                uriStr = this.getPrologue().getResolver().resolve(uriStr);
            }
            catch (JenaURIException ex) {
                this.throwParseException(ex.getMessage(), line, column);
            }
        }
        return Node.createURI(uriStr);
    }

    protected void startBasicGraphPattern() {
        this.activeLabelMap.clear();
    }

    protected void endBasicGraphPattern() {
        this.oldLabels.addAll(this.activeLabelMap.getLabels());
    }

    protected void startTriplesBlock() {
    }

    protected void endTriplesBlock() {
    }

    protected void startGroup(ElementGroup elg) {
        this.endBasicGraphPattern();
        this.startBasicGraphPattern();
    }

    protected void endGroup(ElementGroup elg) {
        this.endBasicGraphPattern();
    }

    protected Node createListNode() {
        return this.createBNode();
    }

    protected Node createBNode() {
        return this.activeLabelMap.allocNode();
    }

    protected Node createBNode(String label, int line, int column) {
        if (this.oldLabels.contains(label)) {
            this.throwParseException("Blank node reused across basic graph patterns: " + label, line, column);
        }
        return this.activeLabelMap.asNode(label);
    }

    private String fixupPrefixedName(String qname, int line, int column) {
        String s = this.getPrologue().expandPrefixedName(qname);
        if (s == null) {
            String msg = "Line " + line + ", column " + column;
            throw new QNameException(msg + ": Unresolved prefixed name: " + qname, line, column);
        }
        return s;
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected void insert(TripleCollector acc, Node s, Node p, Node o) {
        acc.addTriple(new Triple(s, p, o));
    }

    protected void insert(TripleCollector acc, int index, Node s, Node p, Node o) {
        acc.addTriple(index, new Triple(s, p, o));
    }

    protected Expr asExpr(Node n) {
        return ExprUtils.nodeToExpr(n);
    }

    protected Expr asExprNoSign(Node n) {
        String lex = n.getLiteralLexicalForm();
        String lang = n.getLiteralLanguage();
        String dtURI = n.getLiteralDatatypeURI();
        n = this.makeNode(lex, lang, dtURI);
        return ExprUtils.nodeToExpr(n);
    }

    public static String testUnescapeStr(String s) {
        return new ParserBase().unescapeStr(s);
    }

    protected String unescapeStr(String s) {
        return this.unescape(s, '\\', false, 1, 1);
    }

    protected String unescapeStr(String s, int line, int column) {
        return this.unescape(s, '\\', false, line, column);
    }

    private String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= s.length() - 1) {
                    this.throwParseException("Illegal escape at end of string", line, column);
                }
                char ch2 = s.charAt(i + 1);
                ++column;
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        this.throwParseException("\\u escape too short", line, column);
                    }
                    x = this.hex(s, i + 1, 4, line, column);
                    sb.append((char)x);
                    i += 4;
                    column += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        this.throwParseException("\\U escape too short", line, column);
                    }
                    x = this.hex(s, i + 1, 8, line, column);
                    sb.append((char)x);
                    i += 8;
                    column += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            this.throwParseException("Unknown escape: \\" + ch2, line, column);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private int hex(String s, int i, int len, int line, int column) {
        if (i + len >= s.length()) {
            // empty if block
        }
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s.charAt(j);
            ++column;
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    this.throwParseException("Illegal hex escape: " + ch, line, column);
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }

    protected void throwParseException(String msg, int line, int column) {
        throw new QueryParseException("Line " + line + ", column " + column + ": " + msg, line, column);
    }
}

