/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.modify.lang.ParserSPARUL;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.op.UpdateLoad;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.util.FileManager;
import java.io.PrintStream;
import java.util.Iterator;

public class DEV {
    protected static Node s = Node.create("http://example/r");
    protected static Node p = Node.create("http://example/p");
    protected static Node o1 = Node.create("2007");
    protected static Triple triple1 = new Triple(s, p, o1);
    protected static Node o2 = Node.create("1066");
    protected static Triple triple2 = new Triple(s, p, o2);

    public static void main(String[] argv) {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple1);
        graph.add(triple2);
        UpdateInsert ins = new UpdateInsert(graph);
        ins.addGraphName("http://foo");
        System.out.println(ins);
        System.exit(0);
        String filename = null;
        if (argv.length > 1) {
            System.err.println("Usage: SPARUL [file|-]");
        }
        if (argv.length == 0) {
            argv = new String[]{"MOD"};
        }
        filename = argv[0];
        DEV.buildRequest();
        System.exit(0);
    }

    public static void reader(String filename) {
        UpdateRequest update = UpdateFactory.read(filename);
        GraphStore gStore = GraphStoreFactory.create();
        gStore.execute(update);
    }

    public static void buildRequest() {
        UpdateRequest update = UpdateFactory.create();
        update.addUpdate(new UpdateCreate("http://example/progGraph"));
        update.addUpdate(new UpdateLoad("file:D.ttl"));
        GraphStore gStore = GraphStoreFactory.create();
        gStore.execute(update);
        DEV.printGraphStore(gStore, update);
    }

    public static void printGraphStore(GraphStore gStore, UpdateRequest update) {
        PrintStream out = System.out;
        out.println("**** Default graph");
        DEV.printGraph(out, gStore.getDefaultGraph());
        Iterator iter = gStore.listGraphNodes();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            out.println("**** Graph: " + FmtUtils.stringForNode(n, update.getPrefixMapping()));
            DEV.printGraph(out, gStore.getGraph(n));
        }
    }

    public static void printGraph(PrintStream out, Graph graph) {
        Model m = ModelFactory.createModelForGraph(graph);
        m.write(out, "TTL");
    }

    public static void simple(String[] argv) {
        String str2 = null;
        str2 = argv[0].equals("-") ? FileManager.get().readWholeFileAsUTF8(System.in) : FileManager.get().readWholeFileAsUTF8(argv[0]);
        ParserSPARUL p = new ParserSPARUL();
        UpdateRequest update = new UpdateRequest();
        p.parse(update, str2);
        System.out.println("Finished parsing");
        String serialForm = update.toString();
        System.out.print(serialForm);
        p = new ParserSPARUL();
        update = new UpdateRequest();
        p.parse(update, serialForm);
    }
}

