/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.serializer.FmtExprPrefix;
import com.hp.hpl.jena.sparql.serializer.FormatterBase;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementUnsaid;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterPrefix
extends FormatterBase
implements FormatterElement,
FormatterTemplate {
    static int INDENT = 2;
    static final boolean closingBracketOnSameLine = true;
    static final boolean allowDoubles = true;
    protected String openMarker = "(";
    protected String closeMarker = ")";
    static final boolean hideBlocks = true;

    public FormatterPrefix(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterPrefix fmt = new FormatterPrefix(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterPrefix.format(b.getIndentedWriter(), cxt, el);
        return b.toString();
    }

    public boolean topMustBeGroup() {
        return false;
    }

    private void format(Triple t) {
        this.printOpen();
        this.out.print("triplepattern");
        this.out.print(" ");
        this.formatTriple(t);
        this.printClose();
    }

    public void visit(ElementTriplesBlock el) {
        this.printOpen();
        this.out.print("basicgraphpattern");
        this.out.incIndent(INDENT);
        ListIterator iter = el.getTriples().iterator();
        while (iter.hasNext()) {
            this.out.newline();
            Triple t = (Triple)iter.next();
            this.format(t);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementDataset el) {
        el.getPatternElement().visit(this);
    }

    public void visit(ElementFilter el) {
        this.printOpen();
        this.out.print("filter");
        this.out.incIndent(INDENT);
        this.out.print(" ");
        FmtExprPrefix.format(this.out, this.context, el.getExpr());
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementUnion el) {
        this.multiElement("union", el.getElements().iterator());
    }

    public void visit(ElementGroup el) {
        this.multiElement("group", el.getElements().iterator());
    }

    public void visit(ElementOptional el) {
        this.singleElement("optional", el.getOptionalElement());
    }

    public void visit(ElementNamedGraph el) {
        this.printOpen();
        this.out.print("graph");
        this.out.print(" ");
        this.out.print(this.slotToString(el.getGraphNameNode()));
        this.out.incIndent(INDENT);
        this.out.newline();
        el.getElement().visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementUnsaid el) {
        this.singleElement("unsaid", el.getElement());
    }

    private void singleElement(String name, Element element) {
        this.printOpen();
        this.out.print(name);
        this.out.incIndent(INDENT);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void doubleElement(String name, Element el_1, Element el_2) {
        this.printOpen();
        this.out.print(name);
        this.out.println();
        this.out.incIndent(INDENT);
        el_1.visit(this);
        this.out.newline();
        el_2.visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void multiElement(String name, Iterator iter) {
        this.printOpen();
        this.out.print(name);
        this.out.incIndent(INDENT);
        while (iter.hasNext()) {
            this.out.newline();
            Element element = (Element)iter.next();
            element.visit(this);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(TemplateTriple template) {
        this.printOpen();
        this.out.print("triplepattern");
        this.out.print(" ");
        this.formatTriple(template.getTriple());
        this.printClose();
    }

    public void visit(TemplateGroup tGroup) {
        this.printOpen();
        this.out.print("templategroup");
        this.out.incIndent(INDENT);
        Iterator iter = tGroup.templates();
        while (iter.hasNext()) {
            this.out.newline();
            Template sub = (Template)iter.next();
            sub.visit(this);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void printOpen() {
        this.out.print(this.openMarker);
    }

    private void printClose() {
        this.out.print(this.closeMarker);
    }
}

