/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.test.suites;

import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestContext
extends TestCase {
    Symbol p1 = Symbol.create("p1");
    Symbol p2 = Symbol.create("p2");

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestContext.class);
        ts.setName("TestContext");
        return ts;
    }

    public void testCxt1() {
        Context cxt = new Context();
    }

    public void testCxt2() {
        Context cxt = new Context();
        TestContext.assertTrue("Defined in empty context", !cxt.isDefined(this.p1));
        cxt.set(this.p1, "v");
        TestContext.assertTrue("Not defined after .set", cxt.isDefined(this.p1));
        Object v = cxt.get(this.p1);
        TestContext.assertSame("Not the same", "v", v);
    }

    public void testCxt3() {
        Context cxt = new Context();
        cxt.set(this.p1, "v");
        cxt.setIfUndef(this.p1, "w");
        Object v = cxt.get(this.p1);
        TestContext.assertSame("Not as first set", "v", v);
    }

    public void testCxt4() {
        Context cxt = new Context();
        cxt.set(this.p1, "true");
        TestContext.assertTrue("Not true", cxt.isTrue(this.p1));
        TestContext.assertTrue("Not true or undef", cxt.isTrueOrUndef(this.p1));
        TestContext.assertTrue("Not false or undef", cxt.isFalseOrUndef(this.p2));
        TestContext.assertTrue("False when undef", !cxt.isFalse(this.p2));
    }

    public void testCxt5() {
        Context cxt = new Context();
        cxt.set(this.p1, "false");
        TestContext.assertTrue("Not false", cxt.isFalse(this.p1));
        TestContext.assertTrue("Not false or undef", cxt.isFalseOrUndef(this.p1));
    }

    public void testCxt6() {
        Context cxt = new Context();
        cxt.setTrue(this.p1);
        TestContext.assertTrue("Not true", cxt.isTrue(this.p1));
        String x = cxt.getAsString(this.p1);
        TestContext.assertEquals("Not string 'true'", "true", x);
    }
}

