/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ListIterator;

public class FmtUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static NodeToLabelMap bNodeMap = new NodeToLabelMap("b", false);
    static boolean applyUnicodeEscapes = false;

    public static String stringForTriple(Triple triple) {
        return FmtUtils.stringForNode(triple.getSubject()) + " " + FmtUtils.stringForNode(triple.getPredicate()) + " " + FmtUtils.stringForNode(triple.getObject());
    }

    public static String stringForTriple(Triple triple, PrefixMapping prefixMap) {
        return FmtUtils.stringForNode(triple.getSubject(), prefixMap) + " " + FmtUtils.stringForNode(triple.getPredicate(), prefixMap) + " " + FmtUtils.stringForNode(triple.getObject(), prefixMap);
    }

    public static void formatTriple(IndentedWriter out, Triple triple, SerializationContext sCxt) {
        out.print(FmtUtils.stringForNode(triple.getSubject(), sCxt));
        out.print(" ");
        out.print(FmtUtils.stringForNode(triple.getPredicate(), sCxt));
        out.print(" ");
        out.print(FmtUtils.stringForNode(triple.getObject(), sCxt));
        out.print(" .");
    }

    public static void formatPattern(IndentedWriter out, BasicPattern pattern, SerializationContext sCxt) {
        boolean first = true;
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            if (!first) {
                out.println();
            }
            Triple t = (Triple)iter.next();
            FmtUtils.formatTriple(out, t, sCxt);
            first = false;
        }
    }

    public static String stringForQuad(Quad quad) {
        return FmtUtils.stringForNode(quad.getGraph()) + " " + FmtUtils.stringForNode(quad.getSubject()) + " " + FmtUtils.stringForNode(quad.getPredicate()) + " " + FmtUtils.stringForNode(quad.getObject());
    }

    public static String stringForQuad(Quad quad, PrefixMapping prefixMap) {
        return FmtUtils.stringForNode(quad.getGraph(), prefixMap) + " " + FmtUtils.stringForNode(quad.getSubject(), prefixMap) + " " + FmtUtils.stringForNode(quad.getPredicate(), prefixMap) + " " + FmtUtils.stringForNode(quad.getObject(), prefixMap);
    }

    public static String stringForObject(Object obj) {
        if (obj == null) {
            return "<<null>>";
        }
        if (obj instanceof RDFNode) {
            return FmtUtils.stringForRDFNode((RDFNode)obj);
        }
        if (obj instanceof Node) {
            return FmtUtils.stringForNode((Node)obj);
        }
        return obj.toString();
    }

    public static String stringForRDFNode(RDFNode obj) {
        Model m = null;
        if (obj instanceof Resource) {
            m = ((Resource)obj).getModel();
        }
        return FmtUtils.stringForRDFNode(obj, new SerializationContext(m));
    }

    public static String stringForRDFNode(RDFNode obj, SerializationContext context) {
        return FmtUtils.stringForNode(obj.asNode(), context);
    }

    public static String stringForLiteral(Node_Literal literal, SerializationContext context) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        if (datatype != null) {
            if (datatype.equals(XSD.integer.getURI())) {
                try {
                    String s1 = s;
                    if (s.startsWith("+")) {
                        s1 = s.substring(1);
                    }
                    new BigInteger(s1);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.decimal.getURI()) && s.indexOf(46) > 0) {
                try {
                    new BigDecimal(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xboolean.getURI())) {
                if (s.equalsIgnoreCase("true")) {
                    return s;
                }
                if (s.equalsIgnoreCase("false")) {
                    return s;
                }
            }
        }
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, s, true);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(FmtUtils.stringForURI(datatype, context));
        }
        return sbuff.toString();
    }

    public static String stringForString(String str2) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, str2, true);
        sbuff.append("\"");
        return sbuff.toString();
    }

    public static String stringForResource(Resource r) {
        return FmtUtils.stringForResource(r, FmtUtils.newSerializationContext(r.getModel()));
    }

    public static String stringForResource(Resource r, SerializationContext context) {
        return FmtUtils.stringForNode(r.asNode(), context);
    }

    public static String stringForNode(Node n) {
        return FmtUtils.stringForNode(n, ARQConstants.getGlobalPrefixMap());
    }

    public static String stringForNode(Node n, PrefixMapping prefixMap) {
        return FmtUtils.stringForNode(n, FmtUtils.newSerializationContext(prefixMap));
    }

    public static String stringForNode(Node n, SerializationContext context) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            if (context == null) {
                return "[bNode]";
            }
            if (context.getBNodeMap() == null) {
                return "[bNode]";
            }
            return context.getBNodeMap().asString(n);
        }
        if (n.isLiteral()) {
            return FmtUtils.stringForLiteral((Node_Literal)n, context);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return FmtUtils.stringForURI(uri, context);
        }
        if (n.isVariable()) {
            if (!Var.isBlankNodeVar(n)) {
                return "?" + n.getName();
            }
            if (context == null) {
                return "_:" + n.getName();
            }
            return context.getBNodeMap().asString(n);
        }
        return n.toString();
    }

    public static String stringForURI(String uri, SerializationContext context) {
        if (context == null) {
            return FmtUtils.stringForURI(uri, (PrefixMapping)null);
        }
        return FmtUtils.stringForURI(uri, context.getPrefixMapping());
    }

    public static String stringForURI(String uri, PrefixMapping mapping) {
        if (mapping != null) {
            String tmp = mapping.shortForm(uri);
            if (FmtUtils.checkValidPrefixName(tmp, uri)) {
                return tmp;
            }
            tmp = mapping.qnameFor(uri);
            if (FmtUtils.checkValidPrefixName(tmp, uri)) {
                return tmp;
            }
        }
        return "<" + FmtUtils.stringEsc(uri) + ">";
    }

    private static boolean checkValidPrefixName(String prefixedName, String uri) {
        if (!FmtUtils.isShort(prefixedName, uri)) {
            return false;
        }
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            throw new ARQInternalErrorException("Broken short form -- " + prefixedName);
        }
        String p = prefixedName.substring(0, i);
        String x = prefixedName.substring(i + 1);
        return FmtUtils.checkValidPrefix(p) && FmtUtils.checkValidLocalname(x);
    }

    private static boolean isShort(String prefixedName, String uri) {
        return prefixedName != null && !prefixedName.equals(uri);
    }

    private static boolean checkValidPrefix(String prefixStr) {
        if (prefixStr.startsWith("_")) {
            return false;
        }
        return FmtUtils.checkValidLocalname(prefixStr);
    }

    private static boolean checkValidLocalname(String localname2) {
        if (localname2.length() == 0) {
            return true;
        }
        char ch1 = localname2.charAt(0);
        if (!Character.isLetter(ch1) && ch1 != '_') {
            return false;
        }
        if (localname2.endsWith(".")) {
            return false;
        }
        if (localname2.startsWith(".")) {
            return false;
        }
        if (localname2.startsWith(".")) {
            return false;
        }
        if (localname2.indexOf(47) >= 0) {
            return false;
        }
        char ch = localname2.charAt(0);
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        return ch == '_';
    }

    public static String stringEsc(String s) {
        return FmtUtils.stringEsc(s, true);
    }

    public static String stringEsc(String s, boolean singleLineString) {
        StringBuffer sb = new StringBuffer();
        FmtUtils.stringEsc(sb, s, singleLineString);
        return sb.toString();
    }

    public static void stringEsc(StringBuffer sbuff, String s) {
        FmtUtils.stringEsc(sbuff, s, true);
    }

    public static void stringEsc(StringBuffer sbuff, String s, boolean singleLineString) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (singleLineString && (c == '\n' || c == '\r' || c == '\f')) {
                if (c == '\n') {
                    sbuff.append("\\n");
                }
                if (c == '\t') {
                    sbuff.append("\\t");
                }
                if (c == '\r') {
                    sbuff.append("\\r");
                }
                if (c != '\f') continue;
                sbuff.append("\\f");
                continue;
            }
            if (!applyUnicodeEscapes) {
                sbuff.append(c);
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                sbuff.append(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase();
            sbuff.append("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                sbuff.append("0");
            }
            sbuff.append(hexstr);
        }
    }

    public static void resetBNodeLabels() {
        bNodeMap = new NodeToLabelMap("b", false);
    }

    private static SerializationContext newSerializationContext(PrefixMapping prefixMapping) {
        return new SerializationContext(prefixMapping, bNodeMap);
    }
}

