/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import com.hp.hpl.jena.xmloutput.impl.SimpleLogger;
import com.hp.hpl.jena.xmloutput.test.XMLOutputTestBase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import junit.framework.Assert;

public class TestXMLFeatures
extends XMLOutputTestBase {
    private String base1 = "http://example/foobar";
    private String base2 = "http://example/barfoo";
    protected static String file1 = "testing/abbreviated/namespaces.rdf";
    static final int BadPropURI = 1;
    static final int NoError = 0;
    static final int ExtraTriples = 2;
    static final int BadURI = 3;
    static String[][] rData1 = new String[][]{{"", "http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z[?]x=a"}, {"same-document", "", null, null, null, null, null, null}, {"absolute", "/a/b/c/d/", "/a/b/c/d/e/f/g/", "/a/b/C/D", "/A/B#foo/", "/a/b/c/d/X#bar", null, "/a/b/c/d/z[?]x=a"}, {"relative", "[.]", "e/f/g/", null, null, "X#bar", null, "z[?]x=a"}, {"parent", "[.][.]/d/", "[.][.]/d/e/f/g/", null, null, "[.][.]/d/X#bar", null, "[.][.]/d/z[?]x=a"}, {"network", "//www.example.org/a/b/c/d/", "//www.example.org/a/b/c/d/e/f/g/", "//www.example.org/a/b/C/D", "//www.example.org/A/B#foo/", "//www.example.org/a/b/c/d/X#bar", "//example.com/A", "//www.example.org/a/b/c/d/z[?]x=a"}, {"grandparent", "[.][.]/[.][.]/c/d/", "[.][.]/[.][.]/c/d/e/f/g/", "[.][.]/[.][.]/C/D", null, "[.][.]/[.][.]/c/d/X#bar", null, "[.][.]/[.][.]/c/d/z[?]x=a"}};
    static String[][] rData2 = new String[][]{{"", "http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z[?]x=a"}, {"same-document", null, null, null, null, null, null, null}, {"absolute", "/a/b/c/d/", "/a/b/c/d/e/f/g/", "/a/b/C/D", "/A/B#foo/", "/a/b/c/d/X#bar", null, "/a/b/c/d/z[?]x=a"}, {"relative", "d/", "d/e/f/g/", null, null, "d/X#bar", null, "d/z[?]x=a"}, {"parent", "[.][.]/c/d/", "[.][.]/c/d/e/f/g/", "[.][.]/C/D", null, "[.][.]/c/d/X#bar", null, "[.][.]/c/d/z[?]x=a"}, {"network", "//www.example.org/a/b/c/d/", "//www.example.org/a/b/c/d/e/f/g/", "//www.example.org/a/b/C/D", "//www.example.org/A/B#foo/", "//www.example.org/a/b/c/d/X#bar", "//example.com/A", "//www.example.org/a/b/c/d/z[?]x=a"}, {"grandparent", "[.][.]/[.][.]/b/c/d/", "[.][.]/[.][.]/b/c/d/e/f/g/", "[.][.]/[.][.]/b/C/D", null, "[.][.]/[.][.]/b/c/d/X#bar", null, "[.][.]/[.][.]/b/c/d/z[?]x=a"}};
    static String[][] rData3 = new String[][]{{"", "http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z[?]x=a"}, {"same-document", null, null, null, "#foo/", null, null, null}, {"absolute", "/a/b/c/d/", "/a/b/c/d/e/f/g/", "/a/b/C/D", "/A/B#foo/", "/a/b/c/d/X#bar", null, "/a/b/c/d/z[?]x=a"}, {"relative", null, null, null, "B#foo/", null, null, null}, {"parent", "[.][.]/a/b/c/d/", "[.][.]/a/b/c/d/e/f/g/", "[.][.]/a/b/C/D", "[.][.]/A/B#foo/", "[.][.]/a/b/c/d/X#bar", null, "[.][.]/a/b/c/d/z[?]x=a"}, {"network", "//www.example.org/a/b/c/d/", "//www.example.org/a/b/c/d/e/f/g/", "//www.example.org/a/b/C/D", "//www.example.org/A/B#foo/", "//www.example.org/a/b/c/d/X#bar", "//example.com/A", "//www.example.org/a/b/c/d/z[?]x=a"}, {"grandparent", null, null, null, null, null, null, null}};
    private static String[] uris = new String[]{"http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d/e/f/g/", "http://www.example.org/a/b/C/D", "http://www.example.org/A/B#foo/", "http://www.example.org/a/b/c/d/X#bar", "http://example.com/A", "http://www.example.org/a/b/c/d/z?x=a"};
    static IRIFactory factory = IRIFactory.jenaImplementation();

    TestXMLFeatures(String name, String lang) {
        super(name, lang);
    }

    public String toString() {
        return this.getName() + " " + this.lang;
    }

    public void SUPPRESSEDtestRelativeURI() {
        Model m = ModelFactory.createDefaultModel();
        m.createResource("foo").addProperty(RDF.value, "bar");
        m.write(new OutputStream(){

            public void write(int b) throws IOException {
            }
        }, this.lang);
    }

    public void SUPPRESStestNoStripes() throws IOException {
        this.check("testing/abbreviated/collection.rdf", "                              <[a-zA-Z][-a-zA-Z0-9._]*:Class", XMLOutputTestBase.Change.blockRules("resourcePropertyElt"), "http://example.org/foo");
    }

    public void SUPPRESSEDtestBrokenPrefixing() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        m.add(ModelTestBase.statement(m, "a http://bingle.bongle/booty#PP b"));
        m.add(ModelTestBase.statement(m, "c http://dingle.dongle/dooty#PP d"));
        StringWriter sw = new StringWriter();
        m.write(sw);
        Model m2 = ModelFactory.createDefaultModel();
        String written = sw.toString();
        m2.read(new StringReader(written), "");
        StringWriter sw2 = new StringWriter();
        m2.write(sw2);
        String s2 = sw2.toString();
        int first = s2.indexOf("xmlns:j.0=");
        int last = s2.lastIndexOf("xmlns:j.0=");
        TestXMLFeatures.assertEquals(first, last);
        System.out.println(sw2.toString());
    }

    public void testNullBaseWithAbbrev() {
        ModelFactory.createDefaultModel().write(new StringWriter(), this.lang, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug696057() throws IOException {
        File f = File.createTempFile("jena", ".rdf");
        String fileName = f.getAbsolutePath();
        Model m = TestXMLFeatures.createMemModel();
        m.read(new FileInputStream("testing/wg/rdfms-syntax-incomplete/test001.rdf"), "");
        RDFDefaultErrorHandler.silent = true;
        Model m1 = null;
        SimpleLogger old = null;
        try {
            old = BaseXMLWriter.setLogger(new SimpleLogger(){

                public void warn(String s) {
                }

                public void warn(String s, Exception e2) {
                }
            });
            m.write(new FileWriter(fileName), this.lang);
            m1 = TestXMLFeatures.createMemModel();
            m1.read(new FileInputStream(fileName), "");
        }
        finally {
            RDFDefaultErrorHandler.silent = false;
            BaseXMLWriter.setLogger(old);
        }
        TestXMLFeatures.assertTrue("Use of FileWriter", m.isIsomorphicWith(m1));
        f.delete();
    }

    public void testXMLBase() throws IOException {
        this.check(file1, "xml:base=['\"]" + this.base2 + "['\"]", new XMLOutputTestBase.Change(){

            public void modify(RDFWriter writer) {
                String oldvalue = (String)writer.setProperty("xmlbase", TestXMLFeatures.this.base1);
                Assert.assertTrue("xmlbase valued non-null", oldvalue == null);
                oldvalue = (String)writer.setProperty("xmlbase", TestXMLFeatures.this.base2);
                Assert.assertEquals("xmlbase valued incorrect.", TestXMLFeatures.this.base1, oldvalue);
            }
        });
    }

    public void testPropertyURI() throws IOException {
        this.doBadPropTest(this.lang);
    }

    void doBadPropTest(String lg) throws IOException {
        Model m = TestXMLFeatures.createMemModel();
        m.add(m.createResource(), m.createProperty("http://example/", "foo#"), "foo");
        File file = File.createTempFile("rdf", ".xml");
        FileOutputStream fwriter = new FileOutputStream(file);
        try {
            m.write(fwriter, lg);
            fwriter.close();
            TestXMLFeatures.fail("Writer did not detect bad property URI");
        }
        catch (InvalidPropertyURIException je) {
            // empty catch block
        }
        file.delete();
    }

    public void testUseNamespace() throws IOException {
        this.check(file1, "xmlns:eg=['\"]http://example.org/#['\"]", XMLOutputTestBase.Change.setPrefix("eg", "http://example.org/#"));
    }

    public void testSingleQuote() throws IOException {
        this.check(file1, "'", "\"", XMLOutputTestBase.Change.setProperty("attributeQuoteChar", "'"));
    }

    public void testDoubleQuote() throws IOException {
        this.check(file1, "\"", "'", XMLOutputTestBase.Change.setProperty("attributeQuoteChar", "\""));
    }

    public void testUseDefaultNamespace() throws IOException {
        this.check(file1, "xmlns=['\"]http://example.org/#['\"]", XMLOutputTestBase.Change.setPrefix("", "http://example.org/#"));
    }

    public void testUseUnusedNamespace() throws IOException {
        this.check(file1, "xmlns:unused=['\"]http://unused.org/#['\"]", XMLOutputTestBase.Change.setPrefix("unused", "http://unused.org/#"));
    }

    public void testRDFNamespace() throws IOException {
        this.check(file1, "xmlns:r=['\"]" + RDF.getURI() + "['\"]", "rdf:", new XMLOutputTestBase.Change(){

            public void modify(Model m) {
                m.removeNsPrefix("rdf");
                m.setNsPrefix("r", RDF.getURI());
            }
        });
    }

    public void testTab() throws IOException {
        this.check(file1, "          ", XMLOutputTestBase.Change.setProperty("tab", "5"));
    }

    public void testNoTab() throws IOException {
        this.check(file1, "  ", XMLOutputTestBase.Change.setProperty("tab", "0"));
    }

    public void testNoLiteral() throws IOException {
        this.check("testing/wg/rdfms-xml-literal-namespaces/test001.rdf", "#XMLLiteral", "[\"']Literal[\"']", XMLOutputTestBase.Change.setProperty("blockrules", "parseTypeLiteralPropertyElt"));
    }

    public void testRDFDefaultNamespace() throws IOException {
        this.check(file1, "xmlns=['\"]" + RDF.getURI() + "['\"].*" + "xmlns:j.cook.up=['\"]" + RDF.getURI() + "['\"]", XMLOutputTestBase.Change.setPrefix("", RDF.getURI()));
    }

    public void testBadPrefixNamespace() throws IOException {
    }

    public void testDuplicateNamespace() throws IOException {
        this.check(file1, "xmlns:eg[12]=['\"]http://example.org/#['\"]", "xmlns:eg[12]=['\"]http://example.org/#['\"].*xmlns:eg[12]=['\"]http://example.org/#['\"]", new XMLOutputTestBase.Change(){

            public void modify(Model m) {
                m.setNsPrefix("eg1", "http://example.org/#");
                m.setNsPrefix("eg2", "http://example.org/#");
            }
        });
    }

    public void testEntityDeclaration() throws IOException {
        this.check(file1, "<!DOCTYPE rdf:RDF \\[[^]]*<!ENTITY spoo *'goo:boo'>", "SPONGLE", XMLOutputTestBase.Change.setProperty("showDoctypeDeclaration", true).andSetPrefix("spoo", "goo:boo"));
    }

    public void testEntityUse() throws IOException {
        this.check(file1, "rdf:resource=\"&ex0;spoo\"", "SPONGLE", XMLOutputTestBase.Change.setProperty("showDoctypeDeclaration", true));
    }

    public void testDuplicatePrefix() throws IOException {
        this.check(file1, "xmlns:eg=['\"]http://example.org/file[12]#['\"]", null, new XMLOutputTestBase.Change(){

            public void modify(Model m) {
                m.setNsPrefix("eg", "http://example.org/file1#");
                m.setNsPrefix("eg", "http://example.org/file2#");
            }
        });
    }

    void setNsPrefixSysProp(String prefix, String uri) {
        System.setProperty("com.hp.hpl.jena.nsprefix." + uri, prefix);
    }

    public void testUseNamespaceSysProp() throws IOException {
        this.check(file1, "xmlns:eg=['\"]http://example.org/#['\"]", new XMLOutputTestBase.Change(){

            public void modify(RDFWriter writer) {
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/#");
            }
        });
    }

    public void testDefaultNamespaceSysProp() throws IOException {
        this.check(file1, "xmlns=['\"]http://example.org/#['\"]", new XMLOutputTestBase.Change(){

            public void modify(RDFWriter writer) {
                TestXMLFeatures.this.setNsPrefixSysProp("", "http://example.org/#");
            }
        });
    }

    public void testDuplicateNamespaceSysProp() throws IOException {
        this.check(file1, "xmlns:eg[12]=['\"]http://example.org/#['\"]", "xmlns:eg[12]=['\"]http://example.org/#['\"].*xmlns:eg[12]=['\"]http://example.org/#['\"]", new XMLOutputTestBase.Change(){

            public void modify(RDFWriter writer) {
                TestXMLFeatures.this.setNsPrefixSysProp("eg1", "http://example.org/#");
                TestXMLFeatures.this.setNsPrefixSysProp("eg2", "http://example.org/#");
            }
        });
    }

    public void testDuplicatePrefixSysProp() throws IOException {
        this.check(file1, "xmlns:eg=['\"]http://example.org/file[12]#['\"]", null, new XMLOutputTestBase.Change(){

            public void modify(RDFWriter writer) {
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/file1#");
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/file2#");
            }
        });
    }

    public void testDuplicatePrefixSysPropAndExplicit() throws IOException {
        this.check(file1, "xmlns:eg=['\"]http://example.org/file[12]#['\"]", null, new XMLOutputTestBase.Change(){

            public void modify(Model m) {
                m.setNsPrefix("eg", "http://example.org/file1#");
                TestXMLFeatures.this.setNsPrefixSysProp("eg", "http://example.org/file2#");
            }
        });
    }

    public void testUTF8DeclAbsent() throws IOException {
        this.check(file1, "utf-8", null, "<\\?xml", XMLOutputTestBase.Change.none());
    }

    public void testUTF16DeclAbsent() throws IOException {
        this.check(file1, "utf-16", null, "<\\?xml", false, XMLOutputTestBase.Change.none());
    }

    public void testUTF8DeclPresent() throws IOException {
        this.check(file1, "utf-8", "<\\?xml", null, XMLOutputTestBase.Change.setProperty("showXmlDeclaration", true));
    }

    public void testUTF16DeclPresent() throws IOException {
        this.check(file1, "utf-16", "<\\?xml", null, XMLOutputTestBase.Change.setProperty("showXmlDeclaration", true));
    }

    public void testISO8859_1_DeclAbsent() throws IOException {
        this.check(file1, "iso-8859-1", null, "<\\?xml", XMLOutputTestBase.Change.setProperty("showXmlDeclaration", false));
    }

    public void testISO8859_1_DeclPresent() throws IOException {
        this.check(file1, "iso-8859-1", "<\\?xml[^?]*ISO-8859-1", null, XMLOutputTestBase.Change.none());
    }

    public void testStringDeclAbsent() throws IOException {
        this.check(file1, null, "<\\?xml", XMLOutputTestBase.Change.none());
    }

    public void testStringDeclPresent() throws IOException {
        this.check(file1, "<\\?xml", "encoding", XMLOutputTestBase.Change.setProperty("showXmlDeclaration", true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkPropURI(String s, String p, Object val, int behaviour) throws IOException {
        TestXMLFeatures.blockLogger();
        Node blank = Node.createAnon();
        Node prop = Node.createURI(s);
        Graph g = Factory.createGraphMem();
        g.add(Triple.create(blank, prop, blank));
        Model m = ModelFactory.createModelForGraph(g);
        StringWriter w = new StringWriter();
        RDFWriter rw = m.getWriter(this.lang);
        if (p != null) {
            rw.setProperty(p, val);
        }
        try {
            rw.write(m, w, "http://example.org/");
            w.close();
            String f = w.toString();
            switch (behaviour) {
                case 1: {
                    TestXMLFeatures.fail("Bad property URI <" + s + "> was not detected.");
                }
                case 3: {
                    TestXMLFeatures.fail("Bad URI <" + s + "> was not detected.");
                    break;
                }
            }
            Model m2 = TestXMLFeatures.createMemModel();
            RDFReader rdr = m2.getReader("RDF/XML");
            rdr.setProperty("error-mode", "lax");
            rdr.read(m2, new StringReader(f), "http://example.org/");
            switch (behaviour) {
                case 2: {
                    TestXMLFeatures.assertTrue("Expecting Brickley behaviour.", m2.size() == 3L);
                    return;
                }
                case 0: {
                    TestXMLFeatures.assertTrue("Comparing Model written out and read in.", m.isIsomorphicWith(m2));
                    return;
                }
            }
            return;
        }
        catch (BadURIException e2) {
            if (behaviour != 3) throw e2;
            return;
        }
        catch (InvalidPropertyURIException je) {
            if (behaviour != 1) throw je;
            return;
        }
        catch (JenaException e3) {
            throw e3;
        }
        finally {
            TestXMLFeatures.unblockLogger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadURIAsProperty1() throws IOException {
        this.checkPropURI("_:aa", null, null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadURIAsProperty2() throws IOException {
        this.checkPropURI("_:aa", "allowBadURIs", "true", 0);
    }

    public void testLiAsProperty1() throws IOException {
        this.checkPropURI(RDF.getURI() + "li", null, null, 1);
    }

    public void testDescriptionAsProperty() throws IOException {
        this.checkPropURI(RDF.getURI() + "Description", null, null, 1);
    }

    public void testBadProperty1() throws IOException {
        this.checkPropURI("http://x/a.b/", null, null, 1);
    }

    public void testRelativeAPI() {
        RDFWriter w = TestXMLFeatures.createMemModel().getWriter(this.lang);
        String old = (String)w.setProperty("relativeURIs", "");
        TestXMLFeatures.assertEquals("default value check", old, "same-document, absolute, relative, parent");
        w.setProperty("relativeURIs", "network, grandparent,relative,  ");
        w.setProperty("relativeURIs", "  parent, same-document, network, parent, absolute ");
        TestXMLFeatures.blockLogger();
        w.setProperty("relativeURIs", "foo");
        TestXMLFeatures.assertTrue("A warning should have been generated.", TestXMLFeatures.unblockLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relative(String relativeParam, String base, Collection regexesPresent, Collection regexesAbsent) throws IOException {
        Model m = TestXMLFeatures.createMemModel();
        m.read("file:testing/abbreviated/relative-uris.rdf");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RDFWriter writer = m.getWriter(this.lang);
        writer.setProperty("relativeURIs", relativeParam);
        writer.write(m, bos, base);
        bos.close();
        String contents = bos.toString("UTF8");
        try {
            Model m2 = TestXMLFeatures.createMemModel();
            m2.read(new StringReader(contents), base);
            TestXMLFeatures.assertTrue(m.isIsomorphicWith(m2));
            Iterator it = regexesPresent.iterator();
            while (it.hasNext()) {
                String regexPresent = (String)it.next();
                TestXMLFeatures.assertTrue("Looking for /" + regexPresent + "/", Pattern.compile(Util.substituteStandardEntities(regexPresent), 32).matcher(contents).find());
            }
            it = regexesAbsent.iterator();
            while (it.hasNext()) {
                String regexAbsent = (String)it.next();
                TestXMLFeatures.assertTrue("Looking for (not) /" + regexAbsent + "/", !Pattern.compile("[\"']" + Util.substituteStandardEntities(regexAbsent) + "[\"']", 32).matcher(contents).find());
            }
            contents = null;
        }
        finally {
            if (contents != null) {
                System.err.println("===================");
                System.err.println("Offending content - " + this.toString());
                System.err.println("===================");
                System.err.println(contents);
                System.err.println("===================");
            }
        }
    }

    private void relative(int i, String base, String[][] d) throws IOException {
        HashSet<String> in = new HashSet<String>();
        HashSet<String> out = new HashSet<String>();
        for (int j = 1; j < d[i].length; ++j) {
            in.add(d[i][j] == null ? d[0][j] : d[i][j]);
            if (i == 0 || d[i][j] == null) continue;
            out.add(d[0][j]);
        }
        this.relative(d[i][0], base, in, out);
    }

    public void testRelative() throws Exception {
        for (int i = 0; i < 7; ++i) {
            this.relative(i, "http://www.example.org/a/b/c/d/", rData1);
            this.relative(i, "http://www.example.org/a/b/c/d", rData2);
            this.relative(i, "http://www.example.org/A/B#", rData3);
        }
    }

    public static void main(String[] args) throws Exception {
        String[] b = new String[]{"http://www.example.org/a/b/c/d/", "http://www.example.org/a/b/c/d", "http://www.example.org/A/B#"};
        String[] n = new String[]{"", "same-document", "absolute", "relative", "parent", "network", "grandparent"};
        for (int k = 0; k < b.length; ++k) {
            System.out.println("// " + b[k]);
            IRI bb = factory.create(b[k]);
            for (int i = 0; i < n.length; ++i) {
                System.out.print(" { \"" + n[i] + "\", ");
                int f = BaseXMLWriter.str2flags(n[i]);
                for (int j = 0; j < uris.length; ++j) {
                    String r = bb.relativize(uris[j], f).toString();
                    System.out.print(i != 0 && r.equals(uris[j]) ? "null, " : "\"" + r + "\"" + ", ");
                }
                System.out.println("},");
            }
        }
    }
}

