/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.xhtml2scorm;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jp.ac.do_johodai.j314.xhtml2scorm.AnsData;
import jp.ac.do_johodai.j314.xhtml2scorm.MetaData;
import jp.ac.do_johodai.j314.xhtml2scorm.MyEntityResolver;
import jp.ac.do_johodai.j314.xhtml2scorm.MyLSResourceResolver;
import jp.ac.do_johodai.j314.xhtml2scorm.MyNamespaceContext;
import jp.ac.do_johodai.j314.xhtml2scorm.Y;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

class InputXHTML {
    File file = null;
    MetaData parentMD;
    MetaData myMD;
    Document doc;
    String errMessage = null;
    AnsData ansData = new AnsData();
    static final String xhtmlNS = "http://www.w3.org/1999/xhtml";

    InputXHTML(File f) {
        this.file = f;
        if (!this.loadFile(f)) {
            return;
        }
        if (!this.makeMyMetaData()) {
            return;
        }
    }

    DOMImplementationLS getDomImpl() {
        try {
            DOMImplementationRegistry dir = DOMImplementationRegistry.newInstance();
            DOMImplementationLS di = (DOMImplementationLS)((Object)dir.getDOMImplementation("LS 3.0"));
            return di;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    boolean loadFile(File f) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new MyEntityResolver());
            this.doc = db.parse(f);
            return true;
        }
        catch (Exception e) {
            this.errMessage = "XHTML\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            e.printStackTrace();
            return false;
        }
    }

    boolean makeMyMetaData() {
        try {
            String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            NodeList nl = this.doc.getElementsByTagNameNS(rdfNS, "RDF");
            Node n = nl.item(0);
            DOMImplementationLS di = this.getDomImpl();
            LSOutput out = di.createLSOutput();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            out.setByteStream(baos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(n, out);
            String s = new String(baos.toByteArray(), "UTF-8");
            s = s.trim();
            baos.close();
            String base = this.file.toURI().toURL().toExternalForm();
            this.myMD = s.equals("") ? new MetaData(base) : new MetaData(s, base);
        }
        catch (Exception e) {
            String base = this.file.toString();
            this.myMD = new MetaData(base);
        }
        String ul = "/:html/:body/:ul[@id='metadata']/:li/text()";
        Node[] ul0 = this.xpath(ul, this.doc);
        String[] metaTagName = new String[ul0.length];
        String[] tmpString = null;
        for (int metaCount = 0; metaCount < ul0.length; ++metaCount) {
            tmpString = ul0[metaCount].getTextContent().split(": ");
            metaTagName[metaCount] = tmpString[0].trim();
            if (metaTagName[metaCount].equals("title")) {
                this.myMD.setTitle(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("keywords")) {
                this.myMD.setKeywords(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("description")) {
                this.myMD.setDescription(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("difficuly")) {
                this.myMD.setDifficulty(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("learningtime")) {
                this.myMD.setLearningtime(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("kind")) {
                this.myMD.setKind(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("catalog")) {
                this.myMD.setCatalog(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("entry")) {
                this.myMD.setEntry(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("requires")) {
                this.myMD.setEntry(tmpString[1]);
                continue;
            }
            if (metaTagName[metaCount].equals("creator")) {
                this.myMD.setCreator(tmpString[1]);
                continue;
            }
            if (!metaTagName[metaCount].equals("created")) continue;
            this.myMD.setCreated(tmpString[1]);
        }
        try {
            String mdFName = this.file.getName();
            mdFName = mdFName.substring(0, mdFName.lastIndexOf(46)) + ".md";
            File f = new File(this.file.getParentFile(), mdFName);
            if (f.exists()) {
                String line;
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                BufferedReader fr = new BufferedReader(isr);
                int metaCount = 0;
                while ((line = fr.readLine()) != null) {
                    System.out.println(line);
                    tmpString = line.split(": ");
                    if (tmpString[0].trim().equals("title")) {
                        this.myMD.setTitle(tmpString[1]);
                    } else if (tmpString[0].trim().equals("keywords")) {
                        this.myMD.setKeywords(tmpString[1]);
                    } else if (tmpString[0].trim().equals("description")) {
                        this.myMD.setDescription(tmpString[1]);
                    } else if (tmpString[0].trim().equals("difficulty")) {
                        this.myMD.setDifficulty(tmpString[1]);
                    } else if (tmpString[0].trim().equals("learningtime")) {
                        this.myMD.setLearningtime(tmpString[1]);
                    } else if (tmpString[0].trim().equals("kind")) {
                        this.myMD.setKind(tmpString[1]);
                    } else if (tmpString[0].trim().equals("catalog")) {
                        this.myMD.setCatalog(tmpString[1]);
                    } else if (tmpString[0].trim().equals("entry")) {
                        this.myMD.setEntry(tmpString[1]);
                    } else if (tmpString[0].trim().equals("requires")) {
                        this.myMD.setEntry(tmpString[1]);
                    } else if (tmpString[0].trim().equals("creator")) {
                        this.myMD.setCreator(tmpString[1]);
                    } else if (tmpString[0].trim().equals("created")) {
                        this.myMD.setCreated(tmpString[1]);
                    }
                    ++metaCount;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    void setParentMetaData(MetaData m) {
        this.parentMD = m;
        this.myMD.setParent(this.parentMD);
    }

    boolean isValid() {
        return this.errMessage == null;
    }

    String getErrMessage() {
        return this.errMessage;
    }

    Node[] xpath(String query, Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            Node[] ret = new Node[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                ret[i] = nl.item(i);
            }
            return ret;
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    void convert() {
        Node[] n = this.xpath("/:html/:body/:ul[@class='sentakuInfo']", this.doc);
        for (int i = 0; i < n.length; ++i) {
            this.convertSentaku((Element)n[i]);
        }
    }

    void convertSentaku(Element e) {
        Node p = e.getParentNode();
        Element ee = this.doc.createElement("gaha");
        p.replaceChild(ee, e);
    }

    boolean writeSCORM(File f) {
        try {
            Y.convert(this.doc, this);
            DOMImplementationLS di = this.getDomImpl();
            LSOutput out = di.createLSOutput();
            FileOutputStream fos = new FileOutputStream(f);
            out.setByteStream(fos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(this.doc, out);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean writeMetaData(File f) {
        try {
            URL url = this.getClass().getResource("/jp/ac/do_johodai/j314/xhtml2scorm/resources/default_lom.xml");
            InputStream is = url.openStream();
            DOMImplementationLS di = this.getDomImpl();
            LSInput in = di.createLSInput();
            in.setByteStream(is);
            LSParser parser = di.createLSParser((short)1, null);
            DOMConfiguration c = parser.getDomConfig();
            c.setParameter("resource-resolver", new MyLSResourceResolver());
            Document d = parser.parse(in);
            is.close();
            d = Y.makeMetaDoc(d, this.myMD);
            FileOutputStream fos = new FileOutputStream(f);
            LSOutput out = di.createLSOutput();
            out.setByteStream(fos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(d, out);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isNeededAnsData() {
        return this.ansData.isNeededAnsData();
    }

    boolean writeAnsData(File f) {
        return this.ansData.writeAnsData(f);
    }
}

