/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.xhtml2scorm;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.util.FileManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import jp.ac.do_johodai.j314.xhtml2scorm.MD1General;
import jp.ac.do_johodai.j314.xhtml2scorm.MD2LifeCycle;
import jp.ac.do_johodai.j314.xhtml2scorm.MD3MetaMetadata;
import jp.ac.do_johodai.j314.xhtml2scorm.MD4Technical;
import jp.ac.do_johodai.j314.xhtml2scorm.MD5Educational;
import jp.ac.do_johodai.j314.xhtml2scorm.MD6Rights;
import jp.ac.do_johodai.j314.xhtml2scorm.MD7Relation;
import jp.ac.do_johodai.j314.xhtml2scorm.MD8Annotation;
import jp.ac.do_johodai.j314.xhtml2scorm.MD9Classification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaData {
    File file = null;
    String fileName = null;
    Model model = null;
    MetaData parent = null;
    ArrayList<MetaData> children = new ArrayList();
    MD1General general = null;
    MD2LifeCycle lifeCycle = null;
    MD3MetaMetadata metaMetadata = null;
    MD4Technical technical = null;
    MD5Educational educational = null;
    MD6Rights rights = null;
    MD7Relation relation = null;
    ArrayList<MD8Annotation> annotation = null;
    ArrayList<MD9Classification> classification = null;

    MetaData(File f) {
        this.file = f;
        this.fileName = f.getName();
        if (f.exists()) {
            this.readFile(f);
        }
        if (this.model != null) {
            this.make();
        }
    }

    MetaData(String s, String base) {
        this.readString(s, base);
        this.fileName = base.substring(base.lastIndexOf(47) + 1);
        if (this.fileName.endsWith(".xhtml")) {
            this.fileName = this.fileName.substring(0, this.fileName.length() - 6) + ".S.xhtml";
        } else if (this.fileName.endsWith(".html")) {
            this.fileName = this.fileName.substring(0, this.fileName.length() - 5) + ".S.xhtml";
        } else {
            System.out.println("???gaha???");
        }
        if (this.model != null) {
            this.make();
        }
    }

    MetaData(String base) {
        this.fileName = base.substring(base.lastIndexOf(47) + 1);
        if (this.fileName.endsWith(".xhtml")) {
            this.fileName = this.fileName.substring(0, this.fileName.length() - 6) + ".S.xhtml";
        } else if (this.fileName.endsWith(".html")) {
            this.fileName = this.fileName.substring(0, this.fileName.length() - 5) + ".S.xhtml";
        } else {
            System.out.println("???gaha???");
        }
        this.makeEmpty();
    }

    void readFile(File f) {
        try {
            String url = f.toURI().toURL().toExternalForm();
            this.model = FileManager.get().loadModel(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.model = null;
        }
    }

    void readString(String s, String base) {
        try {
            this.model = ModelFactory.createDefaultModel();
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes("UTF-8"));
            this.model.read((InputStream)bais, base);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.model = null;
        }
    }

    void makeEmpty() {
        this.general = new MD1General();
        this.lifeCycle = new MD2LifeCycle();
        this.metaMetadata = new MD3MetaMetadata();
        this.technical = new MD4Technical();
        this.educational = new MD5Educational();
        this.rights = new MD6Rights();
        this.relation = new MD7Relation();
        this.annotation = new ArrayList();
        this.classification = new ArrayList();
    }

    void make() {
        this.makeEmpty();
        String pre = "http://x314.do-johodai.ac.jp/scormmeta/";
        Property p = this.model.getProperty(pre + "title");
        NodeIterator ni = this.model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            this.general.title = ni.next().toString();
        }
        if ((ni = this.model.listObjectsOfProperty(p = this.model.getProperty(pre + "description"))).hasNext()) {
            this.general.description = ni.next().toString();
        }
        if ((ni = this.model.listObjectsOfProperty(p = this.model.getProperty(pre + "keywords"))).hasNext()) {
            this.general.keywords = ni.next().toString();
        }
        if ((ni = this.model.listObjectsOfProperty(p = this.model.getProperty(pre + "author"))).hasNext()) {
            this.lifeCycle.contribute = ni.next().toString();
        }
        if ((ni = this.model.listObjectsOfProperty(p = this.model.getProperty(pre + "difficulty"))).hasNext()) {
            this.educational.difficulty = ni.next().toString();
        }
        if ((ni = this.model.listObjectsOfProperty(p = this.model.getProperty(pre + "learningtime"))).hasNext()) {
            this.educational.typicallearningtime = ni.next().toString();
        }
        if ((ni = this.model.listObjectsOfProperty(p = this.model.getProperty(pre + "rights"))).hasNext()) {
            this.rights.description = ni.next().toString();
        }
    }

    void setParent(MetaData m) {
        this.parent = m;
        if (!m.children.contains(this)) {
            m.children.add(this);
        }
    }

    boolean hasChild() {
        return this.children.size() != 0;
    }

    String getFileName() {
        return this.fileName;
    }

    ArrayList<MetaData> getChildren() {
        return new ArrayList<MetaData>(this.children);
    }

    MetaData makeParentMetaData() {
        if (this.parent != null) {
            return this.parent;
        }
        File pFile = this.file.getParentFile().getParentFile();
        if (pFile == null) {
            return null;
        }
        pFile = new File(pFile, "mutial_metadata.n3");
        MetaData pm = new MetaData(pFile);
        this.setParent(pm);
        return pm;
    }

    String getTitle() {
        if (this.general.title != null) {
            return this.general.title;
        }
        return null;
    }

    void setTitle(String titleName) {
        this.general.title = titleName.trim();
    }

    String getDescription() {
        if (this.general.description != null) {
            return this.general.description;
        }
        return null;
    }

    void setDescription(String Description) {
        this.general.description = Description.trim();
    }

    String getKeywords() {
        if (this.general.keywords != null) {
            return this.general.keywords;
        }
        return null;
    }

    void setKeywords(String keywords) {
        this.general.keywords = keywords.trim();
    }

    String getAuthor() {
        if (this.lifeCycle.contribute != null) {
            return this.lifeCycle.contribute;
        }
        if (this.parent != null) {
            return this.parent.getAuthor();
        }
        return null;
    }

    String getDifficulty() {
        if (this.educational.difficulty != null) {
            return this.educational.difficulty;
        }
        return null;
    }

    void setDifficulty(String difficulty) {
        this.educational.difficulty = difficulty.trim();
    }

    String getLearningtime() {
        if (this.educational.typicallearningtime != null) {
            return this.educational.typicallearningtime;
        }
        return null;
    }

    void setLearningtime(String learningtime) {
        String[] tmp = new String[3];
        tmp = learningtime.split(":");
        tmp[0] = "PT" + tmp[0] + "H";
        tmp[1] = tmp[1] + "M";
        tmp[2] = tmp[2].trim() + "S";
        this.educational.typicallearningtime = learningtime = tmp[0] + tmp[1] + tmp[2];
    }

    String getKind() {
        if (this.relation.kind != null) {
            return this.relation.kind;
        }
        return null;
    }

    void setKind(String kind) {
        this.relation.kind = kind.trim();
    }

    String getEntry() {
        if (this.relation.entry != null) {
            return this.relation.entry;
        }
        return null;
    }

    void setEntry(String entry) {
        this.relation.entry = entry.trim();
    }

    String getCatalog() {
        if (this.relation.catalog != null) {
            return this.relation.catalog;
        }
        return null;
    }

    void setCatalog(String catalog) {
        this.relation.catalog = catalog.trim();
    }

    String getRights() {
        if (this.rights.description != null) {
            return this.rights.description;
        }
        if (this.parent != null) {
            return this.parent.getRights();
        }
        return null;
    }

    String getCreator() {
        if (this.lifeCycle.Author != null) {
            return this.lifeCycle.Author;
        }
        return null;
    }

    void setCreator(String creator) {
        this.lifeCycle.Author = creator.trim();
    }

    String getCreated() {
        if (this.lifeCycle.date != null) {
            return this.lifeCycle.date;
        }
        return null;
    }

    void setCreated(String created) {
        this.lifeCycle.date = created.trim();
    }
}

