/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.processors;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.bean.ColumnNameMapping;
import jp.sourceforge.sxdbutils.bean.NameMapping;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

public class BeanRowProcessor
implements SxRowProcessor {
    protected final Class beanClass;
    protected final NameMapping nameMapping;
    private static final NameMapping DEFAULT_NAME_MAPPING = new ColumnNameMapping();
    protected PropertyMpping[] propertyMppings;

    public BeanRowProcessor(Class beanClass) {
        this(beanClass, DEFAULT_NAME_MAPPING);
    }

    public BeanRowProcessor(Class beanClass, NameMapping nameMapping) {
        this.beanClass = beanClass;
        this.nameMapping = nameMapping;
    }

    public void init(ResultSetMetaData rsmd) throws SQLException {
        Map propertyDescriptorMap = this.readPropertyDescriptor(this.beanClass);
        ArrayList<PropertyMpping> list = new ArrayList<PropertyMpping>();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            PropertyMpping propertyMapping = this.getPropertyMapping(rsmd, i + 1, propertyDescriptorMap);
            if (propertyMapping == null) continue;
            list.add(propertyMapping);
        }
        this.propertyMppings = list.toArray(new PropertyMpping[list.size()]);
    }

    public Object process(ResultSet rs) throws SQLException {
        Object bean = ReflectionUtil.newInstance(this.beanClass);
        PropertyMpping propertyMpping = null;
        for (int i = 0; i < this.propertyMppings.length; ++i) {
            propertyMpping = this.propertyMppings[i];
            propertyMpping.writeProperty(bean, rs);
        }
        return bean;
    }

    protected PropertyMpping getPropertyMapping(ResultSetMetaData rsmd, int columnIndex, Map propertyDescriptorMap) throws SQLException {
        String columnName = rsmd.getColumnLabel(columnIndex);
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescriptorMap.get(this.nameMapping.toIntermediateName(columnName));
        if (propertyDescriptor == null) {
            return null;
        }
        Method setter = propertyDescriptor.getWriteMethod();
        if (setter == null || "class".equals(propertyDescriptor.getName())) {
            return null;
        }
        int sqlType = rsmd.getColumnType(columnIndex);
        ValueType valueType = this.getValueType(propertyDescriptor, sqlType);
        if (valueType == null) {
            return null;
        }
        PropertyMpping propertySetter = new PropertyMpping();
        propertySetter.columnIndex = columnIndex;
        propertySetter.columnName = columnName;
        propertySetter.sqlType = sqlType;
        propertySetter.setter = setter;
        propertySetter.valueType = valueType;
        return propertySetter;
    }

    protected ValueType getValueType(PropertyDescriptor propertyDescriptor, int sqlType) {
        return TypeMappings.getValueType(propertyDescriptor.getPropertyType(), sqlType);
    }

    protected Map readPropertyDescriptor(Class beanClass) {
        Map propertyDescriptorMap = this.nameMapping.createIntermediateMap();
        this.readPropertyDescriptorToMap(beanClass, propertyDescriptorMap);
        return propertyDescriptorMap;
    }

    protected void readPropertyDescriptorToMap(Class type, Map propertyDescriptorMap) {
        if ("java.lang.Object".equals(type.getName())) {
            return;
        }
        this.readPropertyDescriptorToMap(type.getSuperclass(), propertyDescriptorMap);
        PropertyDescriptor[] propertyDescriptors = ReflectionUtil.propertyDescriptors(type);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            propertyDescriptorMap.put(this.nameMapping.toIntermediateName(propertyDescriptor), propertyDescriptor);
        }
    }

    protected static class PropertyMpping {
        String columnName;
        ValueType valueType;
        Method setter;
        int sqlType;
        int columnIndex;

        protected PropertyMpping() {
        }

        void writeProperty(Object bean, ResultSet rset) throws SQLException {
            try {
                ReflectionUtil.invoke(bean, this.setter, this.valueType.getValue(rset, this.columnIndex));
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + "\u3067\u51e6\u7406\u3059\u308b\u969b\u306b\u3001\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
            }
        }

        public String toString() {
            return "columnName=" + this.columnName + "; sqlType=" + this.sqlType + "; setter=" + this.setter.getName() + "; resultReader=" + this.valueType.getClass().getName();
        }
    }
}

