/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sourceforge.sxdbutils.types.AbstractValueType;
import org.apache.commons.lang.BooleanUtils;

public class BooleanNumericType
extends AbstractValueType {
    private static final BigDecimal TRUE = new BigDecimal("1");
    private static final BigDecimal FALSE = new BigDecimal("0");
    private final boolean primitive;

    public BooleanNumericType(boolean primitive) {
        this.primitive = primitive;
    }

    public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
        BigDecimal bd = rset.getBigDecimal(columnIndex);
        if (bd == null) {
            return this.primitive ? Boolean.FALSE : null;
        }
        return BooleanUtils.toBooleanObject((int)bd.intValue());
    }

    public Object toBindParameterValue(Object value) {
        return (Boolean)value != false ? TRUE : FALSE;
    }
}

