package jp.sourceforge.sxdbutils.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


public class QueryUtil {
	private QueryUtil() {
	}

//	@SuppressWarnings("unchecked")
//	public static <T> T cast(Object x) {
//		return (T) x;
//	}

//	public static String toString(Object object) {
//		if (object == null)
//			return "null";
//
//		if (object instanceof Map) {
//			return toString((Map<?, ?>) object);
//		}
//		if (object instanceof Collection) {
//			return toString((Collection<?>) object);
//		}
//		if (object.getClass().isArray()) {
//			return Arrays.toString((Object[]) object);
//		}
//		return String.valueOf(object);
//	}

//	public static <T> String toString(Collection<T> collection) {
//		StringBuilder builder = new StringBuilder();
//		builder.append("{");
//		boolean div = false;
//		for (T t : collection) {
//			if (div)
//				builder.append(',');
//			builder.append(toString(t));
//			div = true;
//		}
//		builder.append("}");
//		return builder.toString();
//	}

//	public static <K, V> String toString(Map<K, V> map) {
//		StringBuilder builder = new StringBuilder();
//		builder.append("{");
//		boolean div = false;
//		for (Map.Entry<K, V> entry : map.entrySet()) {
//			if (div)
//				builder.append(',');
//			Object value = entry.getValue();
//			builder.append(entry.getKey() + ":" + toString(value));
//			div = true;
//		}
//		builder.append("}");
//		return builder.toString();
//	}
//
	public static boolean isBlank(CharSequence chars) {
		int len;
		if (chars == null || (len = chars.length()) == 0) {
			return true;
		}
		for (int i = 0; i < len; i++) {
			if ((Character.isWhitespace(chars.charAt(i)) == false)) {
				return false;
			}
		}
		return true;
	}

	public static boolean isEmpty(CharSequence chars) {
		if (chars == null)
			return true;
		return chars.length() == 0;
	}

	/**
	 * 指定されたインデックスから、指定文字列を置き換えて、次のインデックスを返す。 置き換えた次の位置を返す。
	 * 
	 * @param builder
	 * @param from
	 * @param to
	 * @return
	 */
	public static int replace(StringBuffer builder, String from, String to) {
		return replace(builder, from, to, 0);
	}

	/**
	 * 指定文字列を置き換えて、次の位置を返す。
	 * 
	 * @param builder
	 * @param from
	 * @param to
	 * @param fromIndex
	 * @return
	 */
	public static int replace(StringBuffer builder, String from, String to,
			int fromIndex) {
		int start = builder.indexOf(from, fromIndex);
		if (start == -1)
			return -1;
		int end = start + from.length();
		if (builder.length() < end)
			return -1;
		builder.replace(start, end, to);
		return start + to.length();
	}

	/**
	 * 指定された文字列を全て置き換えて、置き換えた個数を返す。
	 * 
	 * @param builder
	 * @param from
	 * @param to
	 * @return
	 */
	public static int replaceAll(StringBuffer builder, String from, String to) {
		int i = 0;
		int index = 0;
		while ((index = replace(builder, from, to, index)) != -1)
			i++;

		return i;
	}
	
	public static String sqlDateFormat(Date date){
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(date);
	}
	
	public static String sqlDateFormat(Calendar cal){
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(cal);
	}
	
	
}
