package jp.sourceforge.sxdbutils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public interface ValueType {
	/**
	 * ResultSetから任意の型で値を取り出します。
	 * 
	 * @param rset
	 * @param columnIndex
	 * @return
	 * @throws SQLException
	 */
	Object getValue(ResultSet rset, int columnIndex) throws SQLException;

	/**
	 * バインドパラメータとして使用する際、 {@link PreparedStatement}のsetObjectメソッドに渡す値に変換します。
	 * これは、commons-dbtilsのQueryRunnerが拡張できない状況では、
	 * PreparedStatementに直接値をセットすることができないからです。
	 * 
	 * @param value
	 * @return
	 */
	Object toBindParameterValue(Object value);
	
//	void bindValue(PreparedStatement pstmt,int parameterIndex, Object value) throws SQLException;
//	void setNull(PreparedStatement pstmt,int parameterIndex, Object value) throws SQLException;
}