package jp.sourceforge.sxdbutils.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.SxQueryRunner;

public class BeanPersistenceHelper {

	public int execute(Connection connection, QueryFactory factory, Object bean)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.update(connection, factory.toQuery(bean));
	}

	public int[] execute(Connection connection, QueryFactory factory,
			Collection beans) throws SQLException {
		List queries = new ArrayList();
		for (Iterator iterator = beans.iterator(); iterator.hasNext();) {
			Object bean = (Object) iterator.next();
			Query q = factory.toQuery(bean);
			queries.add(q);
		}
		int[] result = new int[queries.size()];
		SxQueryRunner runner = new SxQueryRunner();
		for (int i = 0; i < queries.size(); i++) {
			result[i] = runner.update(connection, (Query) queries.get(i));
		}
		return result;

	}

	public int[] executeBatch(Connection connection, QueryFactory factory,
			Collection beans) throws SQLException {
		Object[][] batchParams = new Object[beans.size()][];
		int i = 0;
		for (Iterator iterator = beans.iterator(); iterator.hasNext();) {
			Object bean = (Object) iterator.next();
			batchParams[i++] = factory.toBindParameters(bean);
		}
		SxQueryRunner runner = new SxQueryRunner();
		return runner.batch(connection, factory.getSql(), batchParams);
	}

}
