package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.SxRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 最初の1行のみを処理するハンドラです。 1行も取得できなかった場合はnullを返します。
 * 
 * @author chinpei
 * 
 */
public class SingleHandler implements ResultSetHandler {

	protected final SxRowProcessor processor;

	public SingleHandler(SxRowProcessor processor) {
		this.processor = processor;
	}

	public SingleHandler() {
		this.processor = null;
	}

	protected SxRowProcessor getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		if (rs.next()) {
			SxRowProcessor proc = getProcessor();
			proc.init(rs.getMetaData());
			return proc.process(rs);
		}
		return null;

	}

}
