package jp.sourceforge.sxdbutils.template.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.SxQueryRunner;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.handlers.ListHandler;
import jp.sourceforge.sxdbutils.handlers.SingleHandler;

public abstract class AbstractSelectTemplate implements SelectTemplate {
	protected abstract Connection getConnection() throws SQLException;

	protected abstract Class getBeanClass();

	protected abstract SxRowProcessor createBeanProcessor(Class beanClass);

	protected SingleHandler createSingleHandler(Class beanClass) {
		return new SingleHandler(createBeanProcessor(beanClass));
	}

	protected ListHandler createListHandler(Class beanClass) {
		return new ListHandler(createBeanProcessor(beanClass));
	}

	public Object executeQueryToBean(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query,
				createSingleHandler(getBeanClass()));
	}

	public List executeQueryToBeanList(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return (List)runner.query(getConnection(), query,
				createListHandler(getBeanClass()));
	}

	public Object executeQueryToBean(Query query, Class beanClass)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query,
				createSingleHandler(beanClass));
	}

	public List executeQueryToBeanList(Query query, Class beanClass)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return (List) runner.query(getConnection(), query,
				createListHandler(beanClass));
	}

}
