package jp.sourceforge.sxdbutils.types;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.util.OthersUtils;

public class ByteArrayType extends AbstractValueType {

	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		InputStream in = null;
		try {
			in = rset.getAsciiStream(columnIndex);
			if (in == null)
				return null;
			return OthersUtils.toByteArray(in);
		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			OthersUtils.closeQuietly(in);
		}
	}
	// protected int getSqlType() {
	// return Types.BINARY;
	// }

}
